/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.smart;

import blusunrize.immersiveengineering.client.models.smart.ConnModelReal;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;

public class ConnLoader
implements ICustomModelLoader {
    public static final String RESOURCE_LOCATION = "models/block/smartmodel/";
    public static Map<String, ImmutableMap<String, String>> textureReplacements = new HashMap<String, ImmutableMap<String, String>>();
    public static Map<String, ResourceLocation> baseModels = new HashMap<String, ResourceLocation>();

    public void func_110549_a(IResourceManager resourceManager) {
        ConnModelReal.cache.clear();
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return modelLocation.func_110623_a().contains(RESOURCE_LOCATION);
    }

    public IModel loadModel(ResourceLocation modelLocation) throws IOException {
        String name;
        ResourceLocation r;
        String resourcePath = modelLocation.func_110623_a();
        int pos = resourcePath.indexOf("conn_");
        if (pos >= 0 && (r = baseModels.get(name = resourcePath.substring(pos += 5))) != null) {
            if (textureReplacements.containsKey(name)) {
                return new ConnModelBase(r, textureReplacements.get(name));
            }
            return new ConnModelBase(r);
        }
        return ModelLoaderRegistry.getMissingModel();
    }

    static {
        baseModels.put("conn_lv", new ResourceLocation("immersiveengineering:block/connector/connectorLV.obj"));
        baseModels.put("rel_lv", new ResourceLocation("immersiveengineering:block/connector/connectorLV.obj"));
        textureReplacements.put("rel_lv", (ImmutableMap<String, String>)ImmutableMap.of((Object)"#immersiveengineering:blocks/connector_connectorLV", (Object)"immersiveengineering:blocks/connector_relayLV"));
        baseModels.put("conn_mv", new ResourceLocation("immersiveengineering:block/connector/connectorMV.obj"));
        baseModels.put("rel_mv", new ResourceLocation("immersiveengineering:block/connector/connectorMV.obj"));
        textureReplacements.put("rel_mv", (ImmutableMap<String, String>)ImmutableMap.of((Object)"#immersiveengineering:blocks/connector_connectorMV", (Object)"immersiveengineering:blocks/connector_relayMV"));
        baseModels.put("conn_hv", new ResourceLocation("immersiveengineering:block/connector/connectorHV.obj"));
        baseModels.put("rel_hv", new ResourceLocation("immersiveengineering:block/connector/relayHV.obj"));
        baseModels.put("conn_struct", new ResourceLocation("immersiveengineering:block/connector/connectorStructural.obj"));
        baseModels.put("breaker_off", new ResourceLocation("immersiveengineering:block/connector/breakerSwitch_off.obj"));
        baseModels.put("breaker_on", new ResourceLocation("immersiveengineering:block/connector/breakerSwitch_on.obj"));
        baseModels.put("eMeter", new ResourceLocation("immersiveengineering:block/connector/eMeter.obj"));
        baseModels.put("redstoneBreaker", new ResourceLocation("immersiveengineering:block/connector/redstoneBreaker.obj"));
        baseModels.put("transformer_hv_left", new ResourceLocation("immersiveengineering:block/connector/transformer_hv_left.obj"));
        baseModels.put("transformer_hv_right", new ResourceLocation("immersiveengineering:block/connector/transformer_hv_right.obj"));
        baseModels.put("transformer_mv_left", new ResourceLocation("immersiveengineering:block/connector/transformer_mv_left.obj"));
        baseModels.put("transformer_mv_right", new ResourceLocation("immersiveengineering:block/connector/transformer_mv_right.obj"));
        baseModels.put("transformer_mv_post", new ResourceLocation("immersiveengineering:block/connector/transformerPost.obj"));
        baseModels.put("eLantern", new ResourceLocation("immersiveengineering:block/metalDevice/eLantern.obj"));
        baseModels.put("eLantern_on", new ResourceLocation("immersiveengineering:block/metalDevice/eLantern.obj"));
        textureReplacements.put("eLantern_on", (ImmutableMap<String, String>)ImmutableMap.of((Object)"#immersiveengineering:blocks/metalDevice1_electricLantern", (Object)"immersiveengineering:blocks/metalDevice1_electricLantern_on"));
        baseModels.put("floodlight", new ResourceLocation("immersiveengineering:block/metalDevice/floodlight.obj.ie"));
        baseModels.put("floodlight_on", new ResourceLocation("immersiveengineering:block/metalDevice/floodlight.obj.ie"));
        textureReplacements.put("floodlight_on", (ImmutableMap<String, String>)ImmutableMap.of((Object)"#immersiveengineering:blocks/metalDevice1_floodlight", (Object)"immersiveengineering:blocks/metalDevice1_floodlight_on"));
        baseModels.put("balloon", new ResourceLocation("immersiveengineering:block/balloon.obj"));
    }

    private class ConnModelBase
    implements IModel {
        ResourceLocation base;
        ImmutableMap<String, String> texReplace;

        public ConnModelBase(ResourceLocation b, ImmutableMap<String, String> t) {
            this.base = b;
            this.texReplace = t;
        }

        public ConnModelBase(ResourceLocation b) {
            this(b, (ImmutableMap<String, String>)ImmutableMap.of((Object)"", (Object)""));
        }

        public Collection<ResourceLocation> getDependencies() {
            return ImmutableList.of((Object)this.base);
        }

        public Collection<ResourceLocation> getTextures() {
            try {
                ArrayList<ResourceLocation> ret = new ArrayList<ResourceLocation>(ModelLoaderRegistry.getModel((ResourceLocation)this.base).getTextures());
                for (String tex : this.texReplace.values()) {
                    ret.add(new ResourceLocation(tex));
                }
                ret.add(new ResourceLocation("ImmersiveEngineering".toLowerCase() + ":blocks/wire"));
                return ret;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public IFlexibleBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            try {
                IModel model = ModelLoaderRegistry.getModel((ResourceLocation)this.base);
                if (model instanceof OBJModel) {
                    model = ((OBJModel)model).retexture(this.texReplace);
                    OBJModel obj = (OBJModel)model;
                    model = obj.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
                }
                return new ConnModelReal((IBakedModel)model.bake(state, Attributes.DEFAULT_BAKED_FORMAT, bakedTextureGetter));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public IModelState getDefaultState() {
            return null;
        }
    }
}

