/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.shader;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ShaderCaseRevolver
extends ShaderCase {
    public int[] colourBlade = new int[4];
    public String additionalTexture = null;
    public TextureAtlasSprite i_revolverBase;
    public TextureAtlasSprite i_revolverOverlay;
    public TextureAtlasSprite i_revolverGrip;
    public TextureAtlasSprite i_revolverUncoloured;
    public TextureAtlasSprite i_revolverAdditional;

    public ShaderCaseRevolver(String overlayType, int[] colourGrip, int[] colourPrimary, int[] colourSecondary, int[] colourBlade, String additionalTexture) {
        super(overlayType, colourGrip, colourPrimary, colourSecondary, "immersiveengineering:revolvers/shaders/revolver_");
        this.colourBlade = colourBlade;
        this.additionalTexture = additionalTexture;
    }

    @Override
    public String getShaderType() {
        return "revolver";
    }

    @Override
    public int getPasses(ItemStack shader, ItemStack item, String modelPart) {
        int i;
        int n = i = this.additionalTexture != null ? 1 : 0;
        if (modelPart.equals("cosmetic_compensator")) {
            return 1 + i;
        }
        if (modelPart.equals("bayonet_attachment") || modelPart.equals("player_bayonet") || modelPart.equals("dev_bayonet") || modelPart.equals("player_mag") || modelPart.equals("dev_mag")) {
            return 2 + i;
        }
        return 3 + i;
    }

    @Override
    public TextureAtlasSprite getReplacementSprite(ItemStack shader, ItemStack item, String modelPart, int pass) {
        boolean hasUncoloured;
        int maxPass = this.getPasses(shader, item, modelPart);
        boolean bl = hasUncoloured = modelPart.equals("barrel") || modelPart.equals("dev_scope") || modelPart.equals("player_mag") || modelPart.equals("dev_mag") || modelPart.equals("player_electro_0") || modelPart.equals("player_electro_1");
        if (pass == maxPass - 1 && hasUncoloured) {
            return this.i_revolverUncoloured;
        }
        if (pass == maxPass - (hasUncoloured ? 2 : 1) && this.i_revolverAdditional != null) {
            return this.i_revolverAdditional;
        }
        switch (modelPart) {
            case "revolver_frame": {
                return pass == 0 ? this.i_revolverGrip : (pass == 1 ? this.i_revolverBase : this.i_revolverOverlay);
            }
            case "barrel": 
            case "dev_scope": 
            case "player_mag": 
            case "dev_mag": 
            case "player_electro_0": 
            case "player_electro_1": 
            case "player_bayonet": 
            case "dev_bayonet": {
                return pass == 0 ? this.i_revolverBase : this.i_revolverOverlay;
            }
            case "bayonet_attachment": {
                return pass == 0 ? this.i_revolverGrip : this.i_revolverOverlay;
            }
            case "cosmetic_compensator": {
                return this.i_revolverOverlay;
            }
        }
        return this.i_revolverBase;
    }

    @Override
    public int[] getRGBAColourModifier(ItemStack shader, ItemStack item, String modelPart, int pass) {
        boolean hasUncoloured;
        int maxPass = this.getPasses(shader, item, modelPart);
        boolean bl = hasUncoloured = modelPart.equals("barrel") || modelPart.equals("dev_scope") || modelPart.equals("player_mag") || modelPart.equals("dev_mag") || modelPart.equals("player_electro_0") || modelPart.equals("player_electro_1");
        if (hasUncoloured && pass == maxPass - 1) {
            return defaultWhite;
        }
        if (pass == maxPass - (hasUncoloured ? 2 : 1) && this.i_revolverAdditional != null) {
            return this.colourOverlay;
        }
        int i = this.getTextureType(modelPart, pass);
        if (i == 0) {
            return this.colourUnderlying;
        }
        if (i == 1) {
            return this.colourPrimary;
        }
        if (i == 2) {
            return this.colourSecondary;
        }
        if (i == 3) {
            return this.colourBlade;
        }
        return defaultWhite;
    }

    public int getTextureType(String modelPart, int pass) {
        int i = 0;
        switch (modelPart) {
            case "revolver_frame": {
                i = pass;
                break;
            }
            case "barrel": 
            case "dev_scope": 
            case "player_mag": 
            case "dev_mag": 
            case "player_electro_0": 
            case "player_electro_1": {
                i = pass + 1;
                break;
            }
            case "cosmetic_compensator": {
                i = 2;
                break;
            }
            case "bayonet_attachment": {
                if (pass != 1) break;
                i = 2;
                break;
            }
            case "player_bayonet": 
            case "dev_bayonet": {
                i = pass == 1 ? 2 : 3;
            }
        }
        return i;
    }

    @Override
    public void stichTextures(TextureMap map, int sheetID) {
        this.i_revolverBase = ApiUtils.getRegisterSprite(map, "immersiveengineering:revolvers/shaders/revolver_0");
        this.i_revolverOverlay = ApiUtils.getRegisterSprite(map, this.baseTexturePath + "1_" + this.overlayType);
        this.i_revolverGrip = ApiUtils.getRegisterSprite(map, "immersiveengineering:revolvers/shaders/revolver_grip");
        this.i_revolverUncoloured = ApiUtils.getRegisterSprite(map, "immersiveengineering:revolvers/shaders/revolver_uncoloured");
        if (this.additionalTexture != null) {
            this.i_revolverAdditional = ApiUtils.getRegisterSprite(map, this.baseTexturePath + this.additionalTexture);
        }
    }

    @Override
    public void modifyRender(ItemStack shader, ItemStack item, String modelPart, int pass, boolean pre, boolean inventory) {
        if (modelPart.equals("cosmetic_compensator")) {
            if (pre) {
                GL11.glDisable((int)2884);
            } else {
                GL11.glEnable((int)2884);
            }
        }
    }
}

