/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy.wires;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.DimensionBlockPos;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IICProxy;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.client.models.smart.ConnModelReal;
import blusunrize.immersiveengineering.common.IESaveData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class ImmersiveNetHandler {
    public static ImmersiveNetHandler INSTANCE;
    public Map<Integer, ConcurrentHashMap<BlockPos, Set<Connection>>> directConnections = new ConcurrentHashMap<Integer, ConcurrentHashMap<BlockPos, Set<Connection>>>();
    public Map<BlockPos, Set<AbstractConnection>> indirectConnections = new ConcurrentHashMap<BlockPos, Set<AbstractConnection>>();
    public Map<Integer, HashMap<Connection, Integer>> transferPerTick = new HashMap<Integer, HashMap<Connection, Integer>>();
    public Map<DimensionBlockPos, IICProxy> proxies = new ConcurrentHashMap<DimensionBlockPos, IICProxy>();

    private ConcurrentHashMap<BlockPos, Set<Connection>> getMultimap(int dimension) {
        if (this.directConnections.get(dimension) == null) {
            ConcurrentHashMap mm = new ConcurrentHashMap();
            this.directConnections.put(dimension, mm);
        }
        return this.directConnections.get(dimension);
    }

    public HashMap<Connection, Integer> getTransferedRates(int dimension) {
        if (!this.transferPerTick.containsKey(dimension)) {
            this.transferPerTick.put(dimension, new HashMap());
        }
        return this.transferPerTick.get(dimension);
    }

    public void addConnection(World world, BlockPos node, BlockPos connection, int distance, WireType cableType) {
        if (!this.getMultimap(world.field_73011_w.func_177502_q()).containsKey(node)) {
            this.getMultimap(world.field_73011_w.func_177502_q()).put(node, Collections.newSetFromMap(new ConcurrentHashMap()));
        }
        this.getMultimap(world.field_73011_w.func_177502_q()).get(node).add(new Connection(node, connection, cableType, distance));
        if (!this.getMultimap(world.field_73011_w.func_177502_q()).containsKey(connection)) {
            this.getMultimap(world.field_73011_w.func_177502_q()).put(connection, Collections.newSetFromMap(new ConcurrentHashMap()));
        }
        this.getMultimap(world.field_73011_w.func_177502_q()).get(connection).add(new Connection(connection, node, cableType, distance));
        this.resetCachedIndirectConnections();
        if (world.func_175667_e(node)) {
            world.func_175641_c(node, world.func_180495_p(node).func_177230_c(), -1, 0);
        }
        if (world.func_175667_e(connection)) {
            world.func_175641_c(connection, world.func_180495_p(connection).func_177230_c(), -1, 0);
        }
        IESaveData.setDirty(world.field_73011_w.func_177502_q());
    }

    public void addConnection(World world, BlockPos node, Connection con) {
        if (!this.getMultimap(world.field_73011_w.func_177502_q()).containsKey(node)) {
            this.getMultimap(world.field_73011_w.func_177502_q()).put(node, Collections.newSetFromMap(new ConcurrentHashMap()));
        }
        this.getMultimap(world.field_73011_w.func_177502_q()).get(node).add(con);
        this.resetCachedIndirectConnections();
        IESaveData.setDirty(world.field_73011_w.func_177502_q());
    }

    public void addConnection(int world, BlockPos node, Connection con) {
        if (!this.getMultimap(world).containsKey(node)) {
            this.getMultimap(world).put(node, Collections.newSetFromMap(new ConcurrentHashMap()));
        }
        this.getMultimap(world).get(node).add(con);
        this.resetCachedIndirectConnections();
        IESaveData.setDirty(world);
    }

    public void removeConnection(World world, Connection con) {
        if (con == null || world == null) {
            return;
        }
        for (Set<Connection> conl : this.getMultimap(world.field_73011_w.func_177502_q()).values()) {
            Iterator<Connection> it = conl.iterator();
            while (it.hasNext()) {
                Connection itCon = it.next();
                if (!con.hasSameConnectors(itCon)) continue;
                it.remove();
                IImmersiveConnectable iic = ApiUtils.toIIC(itCon.end, world);
                if (iic != null) {
                    iic.removeCable(itCon);
                }
                if ((iic = ApiUtils.toIIC(itCon.start, world)) != null) {
                    iic.removeCable(itCon);
                }
                if (world.func_175667_e(itCon.start)) {
                    world.func_175641_c(itCon.start, world.func_180495_p(itCon.start).func_177230_c(), -1, 0);
                }
                if (!world.func_175667_e(itCon.end)) continue;
                world.func_175641_c(itCon.end, world.func_180495_p(itCon.end).func_177230_c(), -1, 0);
            }
        }
        this.resetCachedIndirectConnections();
        IESaveData.setDirty(world.field_73011_w.func_177502_q());
    }

    public Set<Integer> getRelevantDimensions() {
        return this.directConnections.keySet();
    }

    public Collection<Connection> getAllConnections(World world) {
        Set<Connection> ret = Collections.newSetFromMap(new ConcurrentHashMap());
        for (Set<Connection> conlist : this.getMultimap(world.field_73011_w.func_177502_q()).values()) {
            ret.addAll(conlist);
        }
        return ret;
    }

    public synchronized Set<Connection> getConnections(World world, BlockPos node) {
        if (world != null && world.field_73011_w != null) {
            ConcurrentHashMap<BlockPos, Set<Connection>> map = this.getMultimap(world.field_73011_w.func_177502_q());
            return map.get(node);
        }
        return null;
    }

    public void clearAllConnections(World world) {
        this.getMultimap(world.field_73011_w.func_177502_q()).clear();
    }

    public void clearAllConnections(int world) {
        this.getMultimap(world).clear();
    }

    public void clearConnectionsOriginatingFrom(BlockPos node, World world) {
        if (this.getMultimap(world.field_73011_w.func_177502_q()).containsKey(node)) {
            this.getMultimap(world.field_73011_w.func_177502_q()).get(node).clear();
        }
        this.resetCachedIndirectConnections();
    }

    public void resetCachedIndirectConnections() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.indirectConnections.clear();
        } else {
            ConnModelReal.cache.clear();
        }
    }

    public void clearAllConnectionsFor(BlockPos node, World world, boolean doDrops) {
        IImmersiveConnectable iic;
        if (this.getMultimap(world.field_73011_w.func_177502_q()).containsKey(node)) {
            this.getMultimap(world.field_73011_w.func_177502_q()).get(node).clear();
        }
        if ((iic = ApiUtils.toIIC(node, world)) != null) {
            iic.removeCable(null);
        }
        for (Set<Connection> conl : this.getMultimap(world.field_73011_w.func_177502_q()).values()) {
            Iterator<Connection> it = conl.iterator();
            while (it.hasNext()) {
                Connection con = it.next();
                if (!node.equals((Object)con.start) && !node.equals((Object)con.end)) continue;
                it.remove();
                IImmersiveConnectable other = node.equals((Object)con.start) ? ApiUtils.toIIC(con.end, world) : ApiUtils.toIIC(con.start, world);
                if (iic != null) {
                    iic.removeCable(con);
                }
                if (other != null) {
                    other.removeCable(con);
                }
                if (node.equals((Object)con.end)) {
                    double dx = (double)node.func_177958_n() + 0.5 + (double)Math.signum(con.start.func_177958_n() - con.end.func_177958_n());
                    double dy = (double)node.func_177956_o() + 0.5 + (double)Math.signum(con.start.func_177956_o() - con.end.func_177956_o());
                    double dz = (double)node.func_177952_p() + 0.5 + (double)Math.signum(con.start.func_177952_p() - con.end.func_177952_p());
                    if (doDrops && world.func_82736_K().func_82766_b("doTileDrops")) {
                        world.func_72838_d((Entity)new EntityItem(world, dx, dy, dz, con.cableType.getWireCoil()));
                    }
                    if (!world.func_175667_e(con.start)) continue;
                    world.func_175641_c(con.start, world.func_180495_p(con.start).func_177230_c(), -1, 0);
                    continue;
                }
                if (!world.func_175667_e(con.end)) continue;
                world.func_175641_c(con.end, world.func_180495_p(con.end).func_177230_c(), -1, 0);
            }
        }
        if (world.func_175667_e(node)) {
            world.func_175641_c(node, world.func_180495_p(node).func_177230_c(), -1, 0);
        }
        IESaveData.setDirty(world.field_73011_w.func_177502_q());
        this.resetCachedIndirectConnections();
    }

    public void setProxy(DimensionBlockPos pos, IICProxy p) {
        if (p == null) {
            this.proxies.remove((Object)pos);
        } else {
            this.proxies.put(pos, p);
        }
    }

    public void addProxy(IICProxy p) {
        if (p == null) {
            return;
        }
        this.setProxy(new DimensionBlockPos(p.getPos(), p.getDimension()), p);
    }

    public void clearAllConnectionsFor(BlockPos node, World world, TargetingInfo target) {
        WireType type;
        IImmersiveConnectable iic = ApiUtils.toIIC(node, world);
        WireType wireType = type = target == null ? null : iic.getCableLimiter(target);
        if (type == null) {
            return;
        }
        for (Set<Connection> conl : this.getMultimap(world.field_73011_w.func_177502_q()).values()) {
            Iterator<Connection> it = conl.iterator();
            while (it.hasNext()) {
                Connection con = it.next();
                if (con.cableType != type || !node.equals((Object)con.start) && !node.equals((Object)con.end)) continue;
                it.remove();
                IImmersiveConnectable other = node.equals((Object)con.start) ? ApiUtils.toIIC(con.end, world) : ApiUtils.toIIC(con.start, world);
                if (iic != null) {
                    iic.removeCable(con);
                }
                if (other != null) {
                    other.removeCable(con);
                }
                if (node.equals((Object)con.end)) {
                    double dx = (double)node.func_177958_n() + 0.5 + (double)Math.signum(con.start.func_177958_n() - con.end.func_177958_n());
                    double dy = (double)node.func_177956_o() + 0.5 + (double)Math.signum(con.start.func_177956_o() - con.end.func_177956_o());
                    double dz = (double)node.func_177952_p() + 0.5 + (double)Math.signum(con.start.func_177952_p() - con.end.func_177952_p());
                    if (world.func_82736_K().func_82766_b("doTileDrops")) {
                        world.func_72838_d((Entity)new EntityItem(world, dx, dy, dz, con.cableType.getWireCoil()));
                    }
                    if (!world.func_175667_e(con.start)) continue;
                    world.func_175641_c(con.start, world.func_180495_p(con.start).func_177230_c(), -1, 0);
                    continue;
                }
                if (!world.func_175667_e(con.end)) continue;
                world.func_175641_c(con.end, world.func_180495_p(con.end).func_177230_c(), -1, 0);
            }
        }
        if (world.func_175667_e(node)) {
            world.func_175641_c(node, world.func_180495_p(node).func_177230_c(), -1, 0);
        }
        IESaveData.setDirty(world.field_73011_w.func_177502_q());
        this.resetCachedIndirectConnections();
    }

    public Set<AbstractConnection> getIndirectEnergyConnections(BlockPos node, World world) {
        return this.getIndirectEnergyConnections(node, world, false);
    }

    public Set<AbstractConnection> getIndirectEnergyConnections(BlockPos node, World world, boolean ignoreIsEnergyOutput) {
        if (!ignoreIsEnergyOutput && this.indirectConnections.containsKey(node)) {
            return this.indirectConnections.get(node);
        }
        ArrayList<IImmersiveConnectable> openList = new ArrayList<IImmersiveConnectable>();
        Set<AbstractConnection> closedList = Collections.newSetFromMap(new ConcurrentHashMap());
        ArrayList<BlockPos> checked = new ArrayList<BlockPos>();
        HashMap<BlockPos, BlockPos> backtracker = new HashMap<BlockPos, BlockPos>();
        checked.add(node);
        Set<Connection> conL = this.getConnections(world, node);
        if (conL != null) {
            for (Connection con : conL) {
                IImmersiveConnectable end = ApiUtils.toIIC(con.end, world);
                if (end == null) continue;
                openList.add(end);
                backtracker.put(con.end, node);
            }
        }
        IImmersiveConnectable next = null;
        int closedListMax = 1200;
        while (closedList.size() < 1200 && !openList.isEmpty()) {
            next = (IImmersiveConnectable)openList.get(0);
            if (!checked.contains(ApiUtils.toBlockPos(next))) {
                Set<Connection> conLN;
                if (ignoreIsEnergyOutput || next.isEnergyOutput()) {
                    BlockPos last = ApiUtils.toBlockPos(next);
                    WireType averageType = null;
                    int distance = 0;
                    ArrayList<Connection> connectionParts = new ArrayList<Connection>();
                    block2: while (last != null) {
                        Set<Connection> conLB;
                        BlockPos prev = last;
                        if ((last = (BlockPos)backtracker.get(last)) == null || (conLB = this.getConnections(world, last)) == null) continue;
                        for (Connection conB : conLB) {
                            if (!conB.end.equals((Object)prev)) continue;
                            connectionParts.add(0, conB);
                            distance += conB.length;
                            if (averageType != null && conB.cableType.getTransferRate() >= averageType.getTransferRate()) continue block2;
                            averageType = conB.cableType;
                            continue block2;
                        }
                    }
                    closedList.add(new AbstractConnection(ApiUtils.toBlockPos(node), ApiUtils.toBlockPos(next), averageType, distance, connectionParts.toArray(new Connection[connectionParts.size()])));
                }
                if ((conLN = this.getConnections(world, ApiUtils.toBlockPos(next))) != null) {
                    for (Connection con : conLN) {
                        IImmersiveConnectable end;
                        if (!next.allowEnergyToPass(con) || (end = ApiUtils.toIIC(con.end, world)) == null || checked.contains(con.end) || openList.contains(end)) continue;
                        openList.add(end);
                        backtracker.put(con.end, ApiUtils.toBlockPos(next));
                    }
                }
                checked.add(ApiUtils.toBlockPos(next));
            }
            openList.remove(0);
        }
        if (!ignoreIsEnergyOutput && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            if (!this.indirectConnections.containsKey(node)) {
                this.indirectConnections.put(node, Collections.newSetFromMap(new ConcurrentHashMap()));
            }
            this.indirectConnections.get(node).addAll(closedList);
        }
        return closedList;
    }

    public static class AbstractConnection
    extends Connection {
        public Connection[] subConnections;

        public AbstractConnection(BlockPos start, BlockPos end, WireType cableType, int length, Connection ... subConnections) {
            super(start, end, cableType, length);
            this.subConnections = subConnections;
        }

        public float getPreciseLossRate(int energyInput, int connectorMaxInput) {
            float f = 0.0f;
            for (Connection c : this.subConnections) {
                float length = (float)c.length / (float)c.cableType.getMaxLength();
                float baseLoss = (float)c.cableType.getLossRatio();
                float mod = (float)(connectorMaxInput - energyInput) / (float)connectorMaxInput / 0.25f * 0.1f;
                f += length * (baseLoss + baseLoss * mod);
            }
            return Math.min(f, 1.0f);
        }

        public float getAverageLossRate() {
            float f = 0.0f;
            for (Connection c : this.subConnections) {
                float length = (float)c.length / (float)c.cableType.getMaxLength();
                float baseLoss = (float)c.cableType.getLossRatio();
                f += length * baseLoss;
            }
            return Math.min(f, 1.0f);
        }
    }

    public static class Connection
    implements Comparable<Connection> {
        public BlockPos start;
        public BlockPos end;
        public WireType cableType;
        public int length;
        public Vec3[] catenaryVertices;
        public static final int vertices = 17;

        public Connection(BlockPos start, BlockPos end, WireType cableType, int length) {
            this.start = start;
            this.end = end;
            this.cableType = cableType;
            this.length = length;
        }

        public boolean hasSameConnectors(Connection o) {
            if (!(o instanceof Connection)) {
                return false;
            }
            Connection con = o;
            boolean n0 = this.start.equals((Object)con.start) && this.end.equals((Object)con.end);
            boolean n1 = this.start.equals((Object)con.end) && this.end.equals((Object)con.start);
            return n0 || n1;
        }

        public Vec3[] getSubVertices(World world) {
            if (this.catenaryVertices == null) {
                Vec3 vStart = new Vec3((double)this.start.func_177958_n(), (double)this.start.func_177956_o(), (double)this.start.func_177952_p());
                Vec3 vEnd = new Vec3((double)this.end.func_177958_n(), (double)this.end.func_177956_o(), (double)this.end.func_177952_p());
                IImmersiveConnectable iicStart = ApiUtils.toIIC(this.start, world);
                IImmersiveConnectable iicEnd = ApiUtils.toIIC(this.end, world);
                if (iicStart != null) {
                    vStart = ApiUtils.addVectors(vStart, iicStart.getConnectionOffset(this));
                }
                if (iicEnd != null) {
                    vEnd = ApiUtils.addVectors(vEnd, iicEnd.getConnectionOffset(this));
                }
                this.catenaryVertices = ApiUtils.getConnectionCatenary(this, vStart, vEnd);
            }
            return this.catenaryVertices;
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            if (this.start != null) {
                tag.func_74783_a("start", new int[]{this.start.func_177958_n(), this.start.func_177956_o(), this.start.func_177952_p()});
            }
            if (this.end != null) {
                tag.func_74783_a("end", new int[]{this.end.func_177958_n(), this.end.func_177956_o(), this.end.func_177952_p()});
            }
            tag.func_74778_a("cableType", this.cableType.getUniqueName());
            tag.func_74768_a("length", this.length);
            return tag;
        }

        public static Connection readFromNBT(NBTTagCompound tag) {
            if (tag == null) {
                return null;
            }
            int[] iStart = tag.func_74759_k("start");
            BlockPos start = new BlockPos(iStart[0], iStart[1], iStart[2]);
            int[] iEnd = tag.func_74759_k("end");
            BlockPos end = new BlockPos(iEnd[0], iEnd[1], iEnd[2]);
            WireType type = ApiUtils.getWireTypeFromNBT(tag, "cableType");
            if (start != null && end != null && type != null) {
                return new Connection(start, end, type, tag.func_74762_e("length"));
            }
            return null;
        }

        @Override
        public int compareTo(Connection o) {
            if (this.equals(o)) {
                return 0;
            }
            int distComp = Integer.compare(this.length, o.length);
            int cableComp = -1 * Integer.compare(this.cableType.getTransferRate(), o.cableType.getTransferRate());
            if (cableComp != 0) {
                return cableComp;
            }
            if (distComp != 0) {
                return distComp;
            }
            if (this.start.func_177958_n() != o.start.func_177958_n()) {
                return this.start.func_177958_n() > o.start.func_177958_n() ? 1 : -1;
            }
            if (this.start.func_177956_o() != o.start.func_177956_o()) {
                return this.start.func_177956_o() > o.start.func_177956_o() ? 1 : -1;
            }
            if (this.start.func_177952_p() != o.start.func_177952_p()) {
                return this.start.func_177952_p() > o.start.func_177952_p() ? 1 : -1;
            }
            if (this.end.func_177958_n() != o.end.func_177958_n()) {
                return this.end.func_177958_n() > o.end.func_177958_n() ? 1 : -1;
            }
            if (this.end.func_177956_o() != o.end.func_177956_o()) {
                return this.end.func_177956_o() > o.end.func_177956_o() ? 1 : -1;
            }
            if (this.end.func_177952_p() != o.end.func_177952_p()) {
                return this.end.func_177952_p() > o.end.func_177952_p() ? 1 : -1;
            }
            return 0;
        }
    }
}

