/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy.wires;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldServer;

public class IICProxy
implements IImmersiveConnectable {
    private boolean canEnergyPass;
    private int dim;
    private BlockPos pos;

    public IICProxy(boolean allowPass, int dimension, BlockPos _pos) {
        this.canEnergyPass = allowPass;
        this.dim = dimension;
        this.pos = _pos;
    }

    public IICProxy(TileEntity te) {
        if (!(te instanceof IImmersiveConnectable)) {
            throw new IllegalArgumentException("Can't create an IICProxy for a null/non-IIC TileEntity");
        }
        this.dim = te.func_145831_w().field_73011_w.func_177502_q();
        this.canEnergyPass = ((IImmersiveConnectable)te).allowEnergyToPass(null);
        this.pos = Utils.toCC(te);
    }

    @Override
    public boolean allowEnergyToPass(ImmersiveNetHandler.Connection c) {
        return this.canEnergyPass;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getDimension() {
        return this.dim;
    }

    @Override
    public void removeCable(ImmersiveNetHandler.Connection connection) {
        WorldServer w = MinecraftServer.func_71276_C().func_71218_a(this.dim);
        if (w == null) {
            IELogger.warn("Tried to remove a wire in dimension " + this.dim + " which does not exist");
            return;
        }
        TileEntity te = w.func_175625_s(this.pos);
        if (!(te instanceof IImmersiveConnectable)) {
            return;
        }
        ((IImmersiveConnectable)te).removeCable(connection);
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public boolean isEnergyOutput() {
        return false;
    }

    @Override
    public int outputEnergy(int amount, boolean simulate, int energyType) {
        return 0;
    }

    @Override
    public boolean canConnectCable(WireType cableType, TargetingInfo target) {
        return false;
    }

    @Override
    public void connectCable(WireType cableType, TargetingInfo target) {
    }

    @Override
    public WireType getCableLimiter(TargetingInfo target) {
        return null;
    }

    @Override
    public void onEnergyPassthrough(int amount) {
    }

    @Override
    public Vec3 getRaytraceOffset(IImmersiveConnectable link) {
        return null;
    }

    @Override
    public Vec3 getConnectionOffset(ImmersiveNetHandler.Connection con) {
        return null;
    }

    public static IICProxy readFromNBT(NBTTagCompound nbt) {
        return new IICProxy(nbt.func_74767_n("pass"), nbt.func_74762_e("dim"), new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z")));
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound ret = new NBTTagCompound();
        ret.func_74768_a("dim", this.dim);
        ret.func_74768_a("x", this.pos.func_177958_n());
        ret.func_74768_a("y", this.pos.func_177956_o());
        ret.func_74768_a("z", this.pos.func_177952_p());
        ret.func_74757_a("pass", this.canEnergyPass);
        return ret;
    }

    @Override
    public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target) {
        return this.pos;
    }
}

