/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.oredict.OreDictionary;

public class IngredientStack {
    public ItemStack stack;
    public List<ItemStack> stackList;
    public String oreName;
    public int inputSize;
    public boolean useNBT;

    public IngredientStack(ItemStack stack) {
        this.stack = stack;
        this.inputSize = stack.field_77994_a;
    }

    public IngredientStack(String oreName, int inputSize) {
        this.oreName = oreName;
        this.inputSize = inputSize;
    }

    public IngredientStack(String oreName) {
        this(oreName, 1);
    }

    public IngredientStack(List<ItemStack> stackList, int inputSize) {
        this.stackList = stackList;
        this.inputSize = inputSize;
    }

    public IngredientStack(List<ItemStack> stackList) {
        this(stackList, 1);
    }

    public IngredientStack setUseNBT(boolean useNBT) {
        this.useNBT = useNBT;
        return this;
    }

    public boolean matches(Object input) {
        if (input == null) {
            return false;
        }
        if (input instanceof IngredientStack) {
            return this.equals(input) && this.inputSize <= ((IngredientStack)input).inputSize;
        }
        if (input instanceof ItemStack) {
            return this.matchesItemStack((ItemStack)input);
        }
        if (input instanceof ItemStack[]) {
            for (ItemStack iStack : (ItemStack[])input) {
                if (!this.matchesItemStack(iStack)) continue;
                return true;
            }
        } else if (input instanceof List) {
            for (Object io : (List)input) {
                if (!this.matches(io)) continue;
                return true;
            }
        } else if (input instanceof String) {
            if (this.oreName != null) {
                return this.oreName.equals((String)input);
            }
            return ApiUtils.compareToOreName(this.stack, (String)input);
        }
        return false;
    }

    public ItemStack getExampleStack() {
        List ores;
        ItemStack ret = this.stack;
        if (ret == null && this.stackList != null && this.stackList.size() > 0) {
            ret = this.stackList.get(0);
        }
        if (ret == null && this.oreName != null && (ores = OreDictionary.getOres((String)this.oreName)) != null && ores.size() > 0) {
            ret = (ItemStack)ores.get(0);
        }
        return ret;
    }

    public boolean matchesItemStack(ItemStack input) {
        if (this.oreName != null) {
            return ApiUtils.compareToOreName(input, this.oreName) && this.inputSize <= input.field_77994_a;
        }
        if (this.stackList != null) {
            for (ItemStack iStack : this.stackList) {
                if (!OreDictionary.itemMatches((ItemStack)iStack, (ItemStack)input, (boolean)false) || this.inputSize > input.field_77994_a) continue;
                return true;
            }
        }
        if (!OreDictionary.itemMatches((ItemStack)this.stack, (ItemStack)input, (boolean)false) || this.inputSize > input.field_77994_a) {
            return false;
        }
        if (this.useNBT) {
            if (this.stack.func_77942_o() != input.func_77942_o()) {
                return false;
            }
            if (!this.stack.func_77942_o() && !input.func_77942_o()) {
                return true;
            }
            if (!this.stack.func_77978_p().equals((Object)input.func_77978_p())) {
                return false;
            }
        }
        return true;
    }

    public boolean matchesItemStackIgnoringSize(ItemStack input) {
        if (this.oreName != null) {
            return ApiUtils.compareToOreName(input, this.oreName);
        }
        if (this.stackList != null) {
            for (ItemStack iStack : this.stackList) {
                if (!OreDictionary.itemMatches((ItemStack)iStack, (ItemStack)input, (boolean)false)) continue;
                return true;
            }
        }
        if (!OreDictionary.itemMatches((ItemStack)this.stack, (ItemStack)input, (boolean)false)) {
            return false;
        }
        if (this.useNBT) {
            if (this.stack.func_77942_o() != input.func_77942_o()) {
                return false;
            }
            if (!this.stack.func_77942_o() && !input.func_77942_o()) {
                return true;
            }
            if (!this.stack.func_77978_p().equals((Object)input.func_77978_p())) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IngredientStack)) {
            return false;
        }
        if (this.oreName != null && ((IngredientStack)object).oreName != null) {
            return this.oreName.equals(((IngredientStack)object).oreName);
        }
        if (this.stackList != null) {
            if (((IngredientStack)object).stack != null) {
                for (ItemStack iStack : this.stackList) {
                    if (!OreDictionary.itemMatches((ItemStack)iStack, (ItemStack)((IngredientStack)object).stack, (boolean)false)) continue;
                    return true;
                }
            } else {
                for (ItemStack iStack : this.stackList) {
                    for (ItemStack iStack2 : ((IngredientStack)object).stackList) {
                        if (!OreDictionary.itemMatches((ItemStack)iStack, (ItemStack)iStack2, (boolean)false)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        if (this.stack != null && ((IngredientStack)object).stack != null) {
            ItemStack otherStack = ((IngredientStack)object).stack;
            if (!OreDictionary.itemMatches((ItemStack)this.stack, (ItemStack)otherStack, (boolean)false)) {
                return false;
            }
            if (this.useNBT) {
                if (this.stack.func_77942_o() != otherStack.func_77942_o()) {
                    return false;
                }
                if (!this.stack.func_77942_o() && !otherStack.func_77942_o()) {
                    return true;
                }
                if (!this.stack.func_77978_p().equals((Object)otherStack.func_77978_p())) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.oreName != null) {
            nbt.func_74778_a("oreName", this.oreName);
            nbt.func_74768_a("nbtType", 0);
        } else if (this.stackList != null) {
            NBTTagList list = new NBTTagList();
            for (ItemStack stack : this.stackList) {
                if (stack == null) continue;
                list.func_74742_a((NBTBase)stack.func_77955_b(new NBTTagCompound()));
            }
            nbt.func_74782_a("stackList", (NBTBase)list);
            nbt.func_74768_a("nbtType", 1);
        } else {
            nbt.func_74782_a("stack", (NBTBase)this.stack.func_77955_b(new NBTTagCompound()));
            nbt.func_74768_a("nbtType", 2);
            nbt.func_74757_a("useNBT", this.useNBT);
        }
        nbt.func_74768_a("inputSize", this.inputSize);
        return nbt;
    }

    public static IngredientStack readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("nbtType")) {
            switch (nbt.func_74762_e("nbtType")) {
                case 0: {
                    return new IngredientStack(nbt.func_74779_i("oreName"), nbt.func_74762_e("inputSize"));
                }
                case 1: {
                    NBTTagList list = nbt.func_150295_c("stackList", 10);
                    ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        stackList.add(ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(i)));
                    }
                    return new IngredientStack(stackList, nbt.func_74762_e("inputSize"));
                }
                case 2: {
                    ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("stack"));
                    stack.field_77994_a = nbt.func_74762_e("inputSize");
                    IngredientStack ingr = new IngredientStack(stack);
                    ingr.useNBT = nbt.func_74767_n("useNBT");
                    return ingr;
                }
            }
        }
        return null;
    }
}

