/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.DimensionBlockPos;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.energy.wires.IICProxy;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ApiUtils {
    public static boolean compareToOreName(ItemStack stack, String oreName) {
        if (!ApiUtils.isExistingOreName(oreName)) {
            return false;
        }
        ItemStack comp = ApiUtils.copyStackWithAmount(stack, 1);
        List s = OreDictionary.getOres((String)oreName);
        for (ItemStack st : s) {
            if (!ItemStack.func_77989_b((ItemStack)comp, (ItemStack)st)) continue;
            return true;
        }
        return false;
    }

    public static boolean stackMatchesObject(ItemStack stack, Object o) {
        if (o instanceof ItemStack) {
            return OreDictionary.itemMatches((ItemStack)((ItemStack)o), (ItemStack)stack, (boolean)false);
        }
        if (o instanceof List) {
            for (Object io : (List)o) {
                if (!(io instanceof ItemStack) || !OreDictionary.itemMatches((ItemStack)((ItemStack)io), (ItemStack)stack, (boolean)false)) continue;
                return true;
            }
        } else if (o instanceof String) {
            return ApiUtils.compareToOreName(stack, (String)o);
        }
        return false;
    }

    public static ItemStack copyStackWithAmount(ItemStack stack, int amount) {
        if (stack == null) {
            return null;
        }
        ItemStack s2 = stack.func_77946_l();
        s2.field_77994_a = amount;
        return s2;
    }

    public static boolean stacksMatchIngredientList(List<IngredientStack> list, ItemStack ... stacks) {
        ArrayList<ItemStack> queryList = new ArrayList<ItemStack>(stacks.length);
        for (ItemStack s : stacks) {
            if (s == null) continue;
            queryList.add(s.func_77946_l());
        }
        for (IngredientStack ingr : list) {
            if (ingr == null) continue;
            int amount = ingr.inputSize;
            Iterator it = queryList.iterator();
            while (it.hasNext()) {
                ItemStack query = (ItemStack)it.next();
                if (query == null) continue;
                if (ingr.matchesItemStackIgnoringSize(query)) {
                    if (query.field_77994_a > amount) {
                        query.field_77994_a -= amount;
                        amount = 0;
                    } else {
                        amount -= query.field_77994_a;
                        query.field_77994_a = 0;
                    }
                }
                if (query.field_77994_a <= 0) {
                    it.remove();
                }
                if (amount > 0) continue;
                break;
            }
            if (amount <= 0) continue;
            return false;
        }
        return true;
    }

    public static ComparableItemStack createComparableItemStack(ItemStack stack) {
        ComparableItemStack comp = new ComparableItemStack(stack);
        if (stack.func_77942_o()) {
            comp.setUseNBT(true);
        }
        return comp;
    }

    public static boolean isExistingOreName(String name) {
        if (!OreDictionary.doesOreNameExist((String)name)) {
            return false;
        }
        return !OreDictionary.getOres((String)name).isEmpty();
    }

    public static boolean isMetalComponent(ItemStack stack, String componentType) {
        return ApiUtils.getMetalComponentType(stack, componentType) != null;
    }

    public static String getMetalComponentType(ItemStack stack, String ... componentTypes) {
        ItemStack comp = ApiUtils.copyStackWithAmount(stack, 1);
        for (String oreName : OreDictionary.getOreNames()) {
            for (int iType = 0; iType < componentTypes.length; ++iType) {
                if (!oreName.startsWith(componentTypes[iType])) continue;
                List s = OreDictionary.getOres((String)oreName);
                for (ItemStack st : s) {
                    if (!ItemStack.func_77989_b((ItemStack)comp, (ItemStack)st)) continue;
                    return componentTypes[iType];
                }
            }
        }
        return null;
    }

    public static String[] getMetalComponentTypeAndMetal(ItemStack stack, String ... componentTypes) {
        ItemStack comp = ApiUtils.copyStackWithAmount(stack, 1);
        for (String oreName : OreDictionary.getOreNames()) {
            for (int iType = 0; iType < componentTypes.length; ++iType) {
                if (!oreName.startsWith(componentTypes[iType])) continue;
                List s = OreDictionary.getOres((String)oreName);
                for (ItemStack st : s) {
                    if (!ItemStack.func_77989_b((ItemStack)comp, (ItemStack)st)) continue;
                    return new String[]{componentTypes[iType], oreName.substring(componentTypes[iType].length())};
                }
            }
        }
        return null;
    }

    public static boolean isIngot(ItemStack stack) {
        return ApiUtils.isMetalComponent(stack, "ingot");
    }

    public static boolean isPlate(ItemStack stack) {
        return ApiUtils.isMetalComponent(stack, "plate");
    }

    public static int getComponentIngotWorth(ItemStack stack) {
        Integer[] relation;
        String[] keys = IEApi.prefixToIngotMap.keySet().toArray(new String[IEApi.prefixToIngotMap.size()]);
        String key = ApiUtils.getMetalComponentType(stack, keys);
        if (key != null && (relation = IEApi.prefixToIngotMap.get(key)) != null && relation.length > 1) {
            double val = (double)relation[0].intValue() / (double)relation[1].intValue();
            return (int)val;
        }
        return 0;
    }

    public static ItemStack breakStackIntoIngots(ItemStack stack) {
        Integer[] relation;
        String[] keys = IEApi.prefixToIngotMap.keySet().toArray(new String[IEApi.prefixToIngotMap.size()]);
        String[] type = ApiUtils.getMetalComponentTypeAndMetal(stack, keys);
        if (type != null && (relation = IEApi.prefixToIngotMap.get(type[0])) != null && relation.length > 1) {
            double val = (double)relation[0].intValue() / (double)relation[1].intValue();
            return ApiUtils.copyStackWithAmount(IEApi.getPreferredOreStack("ingot" + type[1]), (int)val);
        }
        return null;
    }

    public static Object[] breakStackIntoPreciseIngots(ItemStack stack) {
        Integer[] relation;
        String[] keys = IEApi.prefixToIngotMap.keySet().toArray(new String[IEApi.prefixToIngotMap.size()]);
        String[] type = ApiUtils.getMetalComponentTypeAndMetal(stack, keys);
        if (type != null && (relation = IEApi.prefixToIngotMap.get(type[0])) != null && relation.length > 1) {
            double val = (double)relation[0].intValue() / (double)relation[1].intValue();
            return new Object[]{IEApi.getPreferredOreStack("ingot" + type[1]), val};
        }
        return null;
    }

    public static BlockPos toBlockPos(Object object) {
        if (object instanceof BlockPos) {
            return (BlockPos)object;
        }
        if (object instanceof TileEntity) {
            return ((TileEntity)object).func_174877_v();
        }
        if (object instanceof IICProxy) {
            return ((IICProxy)object).getPos();
        }
        return null;
    }

    public static IImmersiveConnectable toIIC(Object object, World world) {
        return ApiUtils.toIIC(object, world, true);
    }

    public static IImmersiveConnectable toIIC(Object object, World world, boolean allowProxies) {
        if (object instanceof IImmersiveConnectable) {
            return (IImmersiveConnectable)object;
        }
        if (object instanceof BlockPos) {
            DimensionBlockPos pos;
            TileEntity te;
            if (world != null && world.func_175667_e((BlockPos)object) && (te = world.func_175625_s((BlockPos)object)) instanceof IImmersiveConnectable) {
                return (IImmersiveConnectable)te;
            }
            if (allowProxies && ImmersiveNetHandler.INSTANCE.proxies.containsKey((Object)(pos = new DimensionBlockPos((BlockPos)object, world)))) {
                return ImmersiveNetHandler.INSTANCE.proxies.get((Object)pos);
            }
        }
        return null;
    }

    public static Vec3 addVectors(Vec3 vec0, Vec3 vec1) {
        return vec0.func_72441_c(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c);
    }

    public static Vec3[] getConnectionCatenary(ImmersiveNetHandler.Connection connection, Vec3 start, Vec3 end) {
        boolean vertical;
        boolean bl = vertical = connection.end.func_177958_n() == connection.start.func_177958_n() && connection.end.func_177952_p() == connection.start.func_177952_p();
        if (vertical) {
            return new Vec3[]{new Vec3(start.field_72450_a, start.field_72448_b, start.field_72449_c), new Vec3(end.field_72450_a, end.field_72448_b, end.field_72449_c)};
        }
        double dx = end.field_72450_a - start.field_72450_a;
        double dy = end.field_72448_b - start.field_72448_b;
        double dz = end.field_72449_c - start.field_72449_c;
        double dw = Math.sqrt(dx * dx + dz * dz);
        double k = Math.sqrt(dx * dx + dy * dy + dz * dz) * connection.cableType.getSlack();
        double l = 0.0;
        for (int limiter = 0; !vertical && limiter < 300; ++limiter) {
            if (!(Math.sinh(l += 0.01) / l >= Math.sqrt(k * k - dy * dy) / dw)) continue;
        }
        double a = dw / 2.0 / l;
        double p = (0.0 + dw - a * Math.log((k + dy) / (k - dy))) * 0.5;
        double q = (dy + 0.0 - k * Math.cosh(l) / Math.sinh(l)) * 0.5;
        Vec3[] vex = new Vec3[17];
        vex[0] = new Vec3(start.field_72450_a, start.field_72448_b, start.field_72449_c);
        for (int i = 1; i < 17; ++i) {
            float n1 = (float)i / 17.0f;
            double x1 = 0.0 + dx * (double)n1;
            double z1 = 0.0 + dz * (double)n1;
            double y1 = a * Math.cosh((Math.sqrt(x1 * x1 + z1 * z1) - p) / a) + q;
            vex[i] = new Vec3(start.field_72450_a + x1, start.field_72448_b + y1, start.field_72449_c + z1);
        }
        vex[16] = new Vec3(end.field_72450_a, end.field_72448_b, end.field_72449_c);
        return vex;
    }

    public static WireType getWireTypeFromNBT(NBTTagCompound tag, String key) {
        if (tag.func_74781_a(key) instanceof NBTTagInt) {
            int i = tag.func_74762_e(key);
            return i == 1 ? WireType.ELECTRUM : (i == 2 ? WireType.STEEL : (i == 3 ? WireType.STRUCTURE_ROPE : (i == 4 ? WireType.STRUCTURE_STEEL : WireType.COPPER)));
        }
        return WireType.getValue(tag.func_74779_i(key));
    }

    public static Object convertToValidRecipeInput(Object input) {
        if (input instanceof ItemStack) {
            return input;
        }
        if (input instanceof Item) {
            return new ItemStack((Item)input);
        }
        if (input instanceof Block) {
            return new ItemStack((Block)input);
        }
        if (input instanceof List) {
            return input;
        }
        if (input instanceof String) {
            if (!ApiUtils.isExistingOreName((String)input)) {
                return null;
            }
            List l = OreDictionary.getOres((String)((String)input));
            if (!l.isEmpty()) {
                return l;
            }
            return null;
        }
        throw new RuntimeException("Recipe Inputs must always be ItemStack, Item, Block or String (OreDictionary name), " + input + " is invalid");
    }

    public static IngredientStack createIngredientStack(Object input, boolean preferWildcard) {
        if (input instanceof ItemStack) {
            return new IngredientStack((ItemStack)input);
        }
        if (input instanceof Item) {
            if (preferWildcard) {
                return new IngredientStack(new ItemStack((Item)input, 1, Short.MAX_VALUE));
            }
            return new IngredientStack(new ItemStack((Item)input));
        }
        if (input instanceof Block) {
            if (preferWildcard) {
                return new IngredientStack(new ItemStack((Block)input, 1, Short.MAX_VALUE));
            }
            return new IngredientStack(new ItemStack((Block)input));
        }
        if (input instanceof List && ((List)input).isEmpty() && ((List)input).get(0) instanceof ItemStack) {
            return new IngredientStack((List)input);
        }
        if (input instanceof String) {
            return new IngredientStack((String)input);
        }
        throw new RuntimeException("Recipe Ingredients must always be ItemStack, Item, Block, List<ItemStack> or String (OreDictionary name); " + input + " is invalid");
    }

    public static IngredientStack createIngredientStack(Object input) {
        return ApiUtils.createIngredientStack(input, false);
    }

    public static ItemStack getItemStackFromObject(Object o) {
        if (o instanceof ItemStack) {
            return (ItemStack)o;
        }
        if (o instanceof Item) {
            return new ItemStack((Item)o);
        }
        if (o instanceof Block) {
            return new ItemStack((Block)o);
        }
        if (o instanceof List) {
            return (ItemStack)((List)o).get(0);
        }
        if (o instanceof String) {
            if (!ApiUtils.isExistingOreName((String)o)) {
                return null;
            }
            List l = OreDictionary.getOres((String)((String)o));
            if (!l.isEmpty()) {
                return (ItemStack)l.get(0);
            }
            return null;
        }
        return null;
    }

    public static Map<String, Integer> sortMap(Map<String, Integer> map, boolean inverse) {
        TreeMap<String, Integer> sortedMap = new TreeMap<String, Integer>(new ValueComparator(map, inverse));
        sortedMap.putAll(map);
        return sortedMap;
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite getRegisterSprite(TextureMap map, String path) {
        TextureAtlasSprite sprite = map.getTextureExtry(path);
        if (sprite == null) {
            map.func_174942_a(new ResourceLocation(path));
            sprite = map.getTextureExtry(path);
        }
        return sprite;
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite getRegisterSprite(TextureMap map, ResourceLocation path) {
        TextureAtlasSprite sprite = map.getTextureExtry(path.toString());
        if (sprite == null) {
            map.func_174942_a(path);
            sprite = map.getTextureExtry(path.toString());
        }
        return sprite;
    }

    static class ValueComparator
    implements Comparator<String> {
        Map<String, Integer> base;
        boolean inverse;

        public ValueComparator(Map<String, Integer> base, boolean inverse) {
            this.base = base;
            this.inverse = inverse;
        }

        @Override
        public int compare(String s0, String s1) {
            if (this.inverse) {
                if (this.base.get(s0) <= this.base.get(s1)) {
                    return -1;
                }
                return 1;
            }
            if (this.base.get(s0) >= this.base.get(s1)) {
                return -1;
            }
            return 1;
        }
    }
}

