/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.CommonProxy;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.crafting.ArcRecyclingThreadHandler;
import blusunrize.immersiveengineering.common.items.ItemRevolver;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.commands.CommandHandler;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import blusunrize.immersiveengineering.common.util.network.MessageGrapplingHook;
import blusunrize.immersiveengineering.common.util.network.MessageMinecartShaderSync;
import blusunrize.immersiveengineering.common.util.network.MessageMineralListSync;
import blusunrize.immersiveengineering.common.util.network.MessageNoSpamChatComponents;
import blusunrize.immersiveengineering.common.util.network.MessageRequestBlockUpdate;
import blusunrize.immersiveengineering.common.util.network.MessageSkyhookSync;
import blusunrize.immersiveengineering.common.util.network.MessageSpeedloaderSync;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import blusunrize.immersiveengineering.common.world.IEWorldGen;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonStreamParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLModIdMappingEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="ImmersiveEngineering", name="Immersive Engineering", version="0.8-32", dependencies="after:Railcraft;after:tconstruct;before:JEI;after:ThermalFoundation;after:Avaritia", acceptedMinecraftVersions="[1.8.9]")
public class ImmersiveEngineering {
    public static final String MODID = "ImmersiveEngineering";
    public static final String MODNAME = "Immersive Engineering";
    public static final String VERSION = "0.8-32";
    public static final double VERSION_D = 0.8;
    @Mod.Instance(value="ImmersiveEngineering")
    public static ImmersiveEngineering instance = new ImmersiveEngineering();
    @SidedProxy(clientSide="blusunrize.immersiveengineering.client.ClientProxy", serverSide="blusunrize.immersiveengineering.common.CommonProxy")
    public static CommonProxy proxy;
    public static final SimpleNetworkWrapper packetHandler;
    public static CreativeTabs creativeTab;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.preInit(event);
        IEContent.preInit();
        proxy.preInit();
        WireType.wireLossRatio = Config.getDoubleArray("wireLossRatio");
        WireType.wireTransferRate = Config.getIntArray("wireTransferRate");
        WireType.wireColouration = Config.getIntArray("wireColouration");
        WireType.wireLength = Config.getIntArray("wireLength");
        for (int b : Config.getIntArray("oreDimBlacklist")) {
            IEWorldGen.oreDimBlacklist.add(b);
        }
        IEApi.modPreference = Arrays.asList(Config.getStringArray("preferredOres"));
        IEApi.prefixToIngotMap.put("ingot", new Integer[]{1, 1});
        IEApi.prefixToIngotMap.put("nugget", new Integer[]{1, 9});
        IEApi.prefixToIngotMap.put("block", new Integer[]{9, 1});
        IEApi.prefixToIngotMap.put("plate", new Integer[]{1, 1});
        IEApi.prefixToIngotMap.put("gear", new Integer[]{4, 1});
        IEApi.prefixToIngotMap.put("rod", new Integer[]{2, 1});
        IEApi.prefixToIngotMap.put("fence", new Integer[]{5, 3});
        IECompatModule.doModulesPreInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        IEContent.init();
        IEWorldGen ieWorldGen = new IEWorldGen();
        GameRegistry.registerWorldGenerator((IWorldGenerator)ieWorldGen, (int)0);
        MinecraftForge.EVENT_BUS.register((Object)ieWorldGen);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        proxy.init();
        IECompatModule.doModulesInit();
        int messageId = 0;
        packetHandler.registerMessage(MessageMineralListSync.Handler.class, MessageMineralListSync.class, messageId++, Side.CLIENT);
        packetHandler.registerMessage(MessageTileSync.HandlerServer.class, MessageTileSync.class, messageId++, Side.SERVER);
        packetHandler.registerMessage(MessageTileSync.HandlerClient.class, MessageTileSync.class, messageId++, Side.CLIENT);
        packetHandler.registerMessage(MessageSpeedloaderSync.Handler.class, MessageSpeedloaderSync.class, messageId++, Side.CLIENT);
        packetHandler.registerMessage(MessageSkyhookSync.Handler.class, MessageSkyhookSync.class, messageId++, Side.CLIENT);
        packetHandler.registerMessage(MessageMinecartShaderSync.HandlerServer.class, MessageMinecartShaderSync.class, messageId++, Side.SERVER);
        packetHandler.registerMessage(MessageMinecartShaderSync.HandlerClient.class, MessageMinecartShaderSync.class, messageId++, Side.CLIENT);
        packetHandler.registerMessage(MessageRequestBlockUpdate.Handler.class, MessageRequestBlockUpdate.class, messageId++, Side.SERVER);
        packetHandler.registerMessage(MessageNoSpamChatComponents.Handler.class, MessageNoSpamChatComponents.class, messageId++, Side.CLIENT);
        packetHandler.registerMessage(MessageGrapplingHook.Handler.class, MessageGrapplingHook.class, messageId++, Side.SERVER);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        IEContent.postInit();
        ExcavatorHandler.recalculateChances(true);
        proxy.postInit();
        new ThreadContributorSpecialsDownloader();
        IECompatModule.doModulesPostInit();
        ShaderRegistry.compileWeight();
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        IECompatModule.doModulesLoadComplete();
    }

    @Mod.EventHandler
    public void modIDMapping(FMLModIdMappingEvent event) {
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        proxy.serverStarting();
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        if (ImmersiveNetHandler.INSTANCE == null) {
            ImmersiveNetHandler.INSTANCE = new ImmersiveNetHandler();
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            World world = MinecraftServer.func_71276_C().func_130014_f_();
            if (!world.field_72995_K) {
                IELogger.info("WorldData loading");
                IESaveData worldData = (IESaveData)world.func_72943_a(IESaveData.class, "ImmersiveEngineering-SaveData");
                if (worldData == null) {
                    IELogger.info("WorldData not found");
                    worldData = new IESaveData("ImmersiveEngineering-SaveData");
                    world.func_72823_a("ImmersiveEngineering-SaveData", (WorldSavedData)worldData);
                } else {
                    IELogger.info("WorldData retrieved");
                }
                IESaveData.setInstance(world.field_73011_w.func_177502_q(), worldData);
            }
        }
        if (Config.getBoolean("arcfurnace_recycle")) {
            ArcRecyclingThreadHandler.doRecipeProfiling();
        }
    }

    static {
        packetHandler = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        creativeTab = new CreativeTabs(MODID){

            public Item func_78016_d() {
                return null;
            }

            public ItemStack func_151244_d() {
                return new ItemStack((Block)IEContent.blockMetalDecoration0, 1, 0);
            }
        };
    }

    public static class ThreadContributorSpecialsDownloader
    extends Thread {
        public static ThreadContributorSpecialsDownloader activeThread;

        public ThreadContributorSpecialsDownloader() {
            this.setName("Immersive Engineering Contributors Thread");
            this.setDaemon(true);
            this.start();
            activeThread = this;
        }

        @Override
        public void run() {
            Gson gson = new Gson();
            try {
                IELogger.info("Attempting to download special revolvers from GitHub");
                URL url = new URL("https://raw.githubusercontent.com/BluSunrize/ImmersiveEngineering/master/contributorRevolvers.json");
                JsonStreamParser parser = new JsonStreamParser((Reader)new InputStreamReader(url.openStream()));
                while (parser.hasNext()) {
                    try {
                        JsonElement je = parser.next();
                        ItemRevolver.SpecialRevolver revolver = (ItemRevolver.SpecialRevolver)gson.fromJson(je, ItemRevolver.SpecialRevolver.class);
                        if (revolver == null) continue;
                        if (revolver.uuid != null) {
                            for (String uuid : revolver.uuid) {
                                ItemRevolver.specialRevolvers.put((Object)uuid, (Object)revolver);
                            }
                        }
                        ItemRevolver.specialRevolversByTag.put(!revolver.tag.isEmpty() ? revolver.tag : revolver.flavour, revolver);
                    }
                    catch (Exception excepParse) {
                        IELogger.warn("Error on parsing a SpecialRevolver");
                    }
                }
            }
            catch (Exception e) {
                IELogger.info("Could not load contributor+special revolver list.");
                e.printStackTrace();
            }
        }
    }
}

