/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest;

import cpw.mods.ironchest.IronChestType;
import cpw.mods.ironchest.ItemChestChanger;
import cpw.mods.ironchest.client.ModelHelper;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;

public enum ChestChangerType {
    IRONGOLD(IronChestType.IRON, IronChestType.GOLD, "ironGoldUpgrade", "Iron to Gold Chest Upgrade", "mmm", "msm", "mmm"),
    GOLDDIAMOND(IronChestType.GOLD, IronChestType.DIAMOND, "goldDiamondUpgrade", "Gold to Diamond Chest Upgrade", "GGG", "msm", "GGG"),
    COPPERSILVER(IronChestType.COPPER, IronChestType.SILVER, "copperSilverUpgrade", "Copper to Silver Chest Upgrade", "mmm", "msm", "mmm"),
    SILVERGOLD(IronChestType.SILVER, IronChestType.GOLD, "silverGoldUpgrade", "Silver to Gold Chest Upgrade", "mGm", "GsG", "mGm"),
    COPPERIRON(IronChestType.COPPER, IronChestType.IRON, "copperIronUpgrade", "Copper to Iron Chest Upgrade", "mGm", "GsG", "mGm"),
    DIAMONDCRYSTAL(IronChestType.DIAMOND, IronChestType.CRYSTAL, "diamondCrystalUpgrade", "Diamond to Crystal Chest Upgrade", "GGG", "GOG", "GGG"),
    WOODIRON(IronChestType.WOOD, IronChestType.IRON, "woodIronUpgrade", "Normal chest to Iron Chest Upgrade", "mmm", "msm", "mmm"),
    WOODCOPPER(IronChestType.WOOD, IronChestType.COPPER, "woodCopperUpgrade", "Normal chest to Copper Chest Upgrade", "mmm", "msm", "mmm"),
    DIAMONDOBSIDIAN(IronChestType.DIAMOND, IronChestType.OBSIDIAN, "diamondObsidianUpgrade", "Diamond to Obsidian Chest Upgrade", "mmm", "mGm", "mmm");

    private IronChestType source;
    private IronChestType target;
    public String itemName;
    public String descriptiveName;
    public ItemChestChanger item;
    private String[] recipe;

    private ChestChangerType(IronChestType source, IronChestType target, String itemName, String descriptiveName, String ... recipe) {
        this.source = source;
        this.target = target;
        this.itemName = itemName;
        this.descriptiveName = descriptiveName;
        this.recipe = recipe;
    }

    public IronChestType getSource() {
        return this.source;
    }

    public boolean canUpgrade(IronChestType from) {
        return from == this.source;
    }

    public int getTarget() {
        return this.target.ordinal();
    }

    public ItemChestChanger buildItem() {
        this.item = new ItemChestChanger(this);
        GameRegistry.registerItem((Item)this.item, (String)this.itemName);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ModelHelper.registerItem(this.item, "ironchest:" + this.itemName);
        }
        return this.item;
    }

    public void addRecipes() {
        for (String sourceMat : this.source.getMatList()) {
            for (String targetMat : this.target.getMatList()) {
                Object targetMaterial = IronChestType.translateOreName(targetMat);
                Object sourceMaterial = IronChestType.translateOreName(sourceMat);
                IronChestType.addRecipe(new ItemStack((Item)this.item), this.recipe, Character.valueOf('m'), targetMaterial, Character.valueOf('s'), sourceMaterial, Character.valueOf('G'), "blockGlass", Character.valueOf('O'), Blocks.field_150343_Z);
            }
        }
    }

    public static void buildItems() {
        for (ChestChangerType type : ChestChangerType.values()) {
            type.buildItem();
        }
    }

    public static void generateRecipes() {
        for (ChestChangerType item : ChestChangerType.values()) {
            item.addRecipes();
        }
    }
}

