/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest;

import com.google.common.collect.Lists;
import cpw.mods.ironchest.IronChest;
import cpw.mods.ironchest.IronChestType;
import cpw.mods.ironchest.TileEntityIronChest;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockIronChest
extends BlockContainer {
    public static final PropertyEnum<IronChestType> VARIANT_PROP = PropertyEnum.func_177709_a((String)"variant", IronChestType.class);
    private static final EnumFacing[] validRotationAxes = new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN};

    public BlockIronChest() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT_PROP, (Comparable)((Object)IronChestType.IRON)));
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
        this.func_149711_c(3.0f);
        this.func_149663_c("IronChest");
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState blockState, EntityPlayer player, EnumFacing direction, float p_180639_6_, float p_180639_7_, float p_180639_8_) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof TileEntityIronChest)) {
            return true;
        }
        if (world.isSideSolid(pos.func_177982_a(0, 1, 0), EnumFacing.DOWN)) {
            return true;
        }
        if (world.field_72995_K) {
            return true;
        }
        player.openGui((Object)IronChest.instance, ((TileEntityIronChest)te).getType().ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return IronChestType.makeEntity(metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (IronChestType type : IronChestType.values()) {
            if (!type.isValidForCreativeMode()) continue;
            list.add(new ItemStack(itemIn, 1, type.ordinal()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT_PROP, (Comparable)((Object)IronChestType.values()[meta]));
    }

    public int func_176201_c(IBlockState blockState) {
        return ((IronChestType)((Object)blockState.func_177229_b(VARIANT_PROP))).ordinal();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{VARIANT_PROP});
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList items = Lists.newArrayList();
        ItemStack stack = new ItemStack((Block)this, 1, this.func_176201_c(state));
        IronChestType.values()[IronChestType.validateMeta(this.func_176201_c(state))].adornItemDrop(stack);
        items.add(stack);
        return items;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState blockState) {
        super.func_176213_c(world, pos, blockState);
        world.func_175689_h(pos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState blockState, EntityLivingBase entityliving, ItemStack itemStack) {
        TileEntity te;
        byte chestFacing = 0;
        int facing = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (facing == 0) {
            chestFacing = 2;
        }
        if (facing == 1) {
            chestFacing = 5;
        }
        if (facing == 2) {
            chestFacing = 3;
        }
        if (facing == 3) {
            chestFacing = 4;
        }
        if ((te = world.func_175625_s(pos)) != null && te instanceof TileEntityIronChest) {
            TileEntityIronChest teic = (TileEntityIronChest)te;
            teic.wasPlaced(entityliving, itemStack);
            teic.setFacing(chestFacing);
            world.func_175689_h(pos);
        }
    }

    public int func_180651_a(IBlockState state) {
        return IronChestType.validateMeta(((IronChestType)((Object)state.func_177229_b(VARIANT_PROP))).ordinal());
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState blockState) {
        TileEntityIronChest tileentitychest = (TileEntityIronChest)world.func_175625_s(pos);
        if (tileentitychest != null) {
            tileentitychest.removeAdornments();
            this.dropContent(0, tileentitychest, world, tileentitychest.func_174877_v());
        }
        super.func_180663_b(world, pos, blockState);
    }

    public void dropContent(int newSize, IInventory chest, World world, BlockPos pos) {
        Random random = world.field_73012_v;
        for (int l = newSize; l < chest.func_70302_i_(); ++l) {
            ItemStack itemstack = chest.func_70301_a(l);
            if (itemstack == null) continue;
            float f = random.nextFloat() * 0.8f + 0.1f;
            float f1 = random.nextFloat() * 0.8f + 0.1f;
            float f2 = random.nextFloat() * 0.8f + 0.1f;
            while (itemstack.field_77994_a > 0) {
                int i1 = random.nextInt(21) + 10;
                if (i1 > itemstack.field_77994_a) {
                    i1 = itemstack.field_77994_a;
                }
                itemstack.field_77994_a -= i1;
                EntityItem entityitem = new EntityItem(world, (double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + (float)(newSize > 0 ? 1 : 0) + f1), (double)((float)pos.func_177952_p() + f2), new ItemStack(itemstack.func_77973_b(), i1, itemstack.func_77960_j()));
                float f3 = 0.05f;
                entityitem.field_70159_w = (float)random.nextGaussian() * f3;
                entityitem.field_70181_x = (float)random.nextGaussian() * f3 + 0.2f;
                entityitem.field_70179_y = (float)random.nextGaussian() * f3;
                if (itemstack.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                }
                world.func_72838_d((Entity)entityitem);
            }
        }
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        TileEntityIronChest teic;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityIronChest && (teic = (TileEntityIronChest)te).getType().isExplosionResistant()) {
            return 10000.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_180641_l(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IInventory) {
            return Container.func_94526_b((IInventory)((IInventory)te));
        }
        return 0;
    }

    public EnumFacing[] getValidRotations(World worldObj, BlockPos pos) {
        return validRotationAxes;
    }

    public boolean rotateBlock(World worldObj, BlockPos pos, EnumFacing axis) {
        if (worldObj.field_72995_K) {
            return false;
        }
        if (axis == EnumFacing.UP || axis == EnumFacing.DOWN) {
            TileEntity tileEntity = worldObj.func_175625_s(pos);
            if (tileEntity instanceof TileEntityIronChest) {
                TileEntityIronChest icte = (TileEntityIronChest)tileEntity;
                icte.rotateAround();
            }
            return true;
        }
        return false;
    }
}

