/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.bit;

import java.util.HashMap;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateReference;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.interfaces.ICacheClearable;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.render.BaseSmartModel;
import mod.chiselsandbits.render.ModelCombined;
import mod.chiselsandbits.render.bit.BitItemBaked;
import mod.chiselsandbits.render.chiseledblock.ChiselLayer;
import mod.chiselsandbits.render.chiseledblock.ChiseledBlockBaked;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.ISmartItemModel;

public class BitItemSmartModel
extends BaseSmartModel
implements ISmartItemModel,
ICacheClearable {
    private static final HashMap<Integer, IFlexibleBakedModel> modelCache = new HashMap();
    private static final HashMap<Integer, IFlexibleBakedModel> largeModelCache = new HashMap();

    private IBakedModel getCachedModel(int stateID, boolean large) {
        HashMap<Integer, IFlexibleBakedModel> target = large ? largeModelCache : modelCache;
        IFlexibleBakedModel out = target.get(stateID);
        if (out == null) {
            if (large) {
                VoxelBlob blob = new VoxelBlob();
                blob.fill(stateID);
                VoxelBlobStateReference ref = new VoxelBlobStateReference(blob, 0L);
                ChiseledBlockBaked a = new ChiseledBlockBaked(stateID, ChiselLayer.SOLID, ref, null, DefaultVertexFormats.field_176599_b);
                ChiseledBlockBaked b = new ChiseledBlockBaked(stateID, ChiselLayer.SOLID_FLUID, ref, null, DefaultVertexFormats.field_176599_b);
                ChiseledBlockBaked c = new ChiseledBlockBaked(stateID, ChiselLayer.CUTOUT_MIPPED, ref, null, DefaultVertexFormats.field_176599_b);
                ChiseledBlockBaked d = new ChiseledBlockBaked(stateID, ChiselLayer.CUTOUT, ref, null, DefaultVertexFormats.field_176599_b);
                ChiseledBlockBaked e = new ChiseledBlockBaked(stateID, ChiselLayer.TRANSLUCENT, ref, null, DefaultVertexFormats.field_176599_b);
                out = new ModelCombined(a, b, c, d, e);
            } else {
                out = new BitItemBaked(stateID);
            }
            target.put(stateID, out);
        }
        return out;
    }

    public IBakedModel handleItemState(ItemStack stack) {
        return this.getCachedModel(ItemChiseledBit.getStackState(stack), ClientSide.instance.holdingShift());
    }

    @Override
    public void clearCache() {
        modelCache.clear();
        largeModelCache.clear();
    }
}

