/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.helpers;

import mod.chiselsandbits.core.ChiselMode;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ReflectionWrapper;
import mod.chiselsandbits.helpers.ChiselToolType;
import mod.chiselsandbits.interfaces.IChiselModeItem;
import mod.chiselsandbits.network.NetworkRouter;
import mod.chiselsandbits.network.packets.PacketSetChiselMode;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class ChiselModeManager {
    private static ChiselMode clientChiselMode = ChiselMode.SINGLE;
    private static ChiselMode clientBitMode = ChiselMode.SINGLE;

    public static void changeChiselMode(ChiselToolType tool, ChiselMode originalMode, ChiselMode newClientChiselMode) {
        boolean chatNotification = ChiselsAndBits.getConfig().chatModeNotification;
        boolean itemNameModeDisplay = ChiselsAndBits.getConfig().itemNameModeDisplay;
        if (ChiselsAndBits.getConfig().perChiselMode && tool == ChiselToolType.CHISEL) {
            PacketSetChiselMode packet = new PacketSetChiselMode();
            packet.mode = newClientChiselMode;
            packet.chatNotification = chatNotification;
            if (!itemNameModeDisplay) {
                newClientChiselMode.setMode(Minecraft.func_71410_x().field_71439_g.func_71045_bC());
            }
            NetworkRouter.instance.sendToServer(packet);
        } else {
            if (tool == ChiselToolType.CHISEL) {
                clientChiselMode = newClientChiselMode;
            } else {
                clientBitMode = newClientChiselMode;
            }
            if (originalMode != newClientChiselMode && chatNotification) {
                Minecraft.func_71410_x().field_71439_g.func_146105_b((IChatComponent)new ChatComponentTranslation(newClientChiselMode.string.toString(), new Object[0]));
            }
            ReflectionWrapper.instance.clearHighlightedStack();
        }
        if (!itemNameModeDisplay) {
            ReflectionWrapper.instance.endHighlightedStack();
        }
    }

    public static void scrollOption(ChiselToolType tool, ChiselMode originalMode, ChiselMode currentMode, int dwheel) {
        int offset = currentMode.ordinal() + (dwheel < 0 ? -1 : 1);
        if (offset >= ChiselMode.values().length) {
            offset = 0;
        }
        if (offset < 0) {
            offset = ChiselMode.values().length - 1;
        }
        currentMode = ChiselMode.values()[offset];
        if (currentMode.isDisabled) {
            ChiselModeManager.scrollOption(tool, originalMode, currentMode, dwheel);
        } else {
            ChiselModeManager.changeChiselMode(tool, originalMode, currentMode);
        }
    }

    public static ChiselMode getChiselMode(EntityPlayer player, ChiselToolType setting) {
        if (setting == ChiselToolType.CHISEL) {
            ItemStack ei;
            if (ChiselsAndBits.getConfig().perChiselMode && (ei = player.func_71045_bC()) != null && ei.func_77973_b() instanceof IChiselModeItem) {
                return ChiselMode.getMode(ei);
            }
            return clientChiselMode;
        }
        if (setting == ChiselToolType.BIT) {
            return clientBitMode;
        }
        return ChiselMode.SINGLE;
    }
}

