/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.core.api;

import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IBitBag;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.IBitLocation;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import mod.chiselsandbits.api.ItemType;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.ItemBlockChiseled;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.BitLocation;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.client.UndoTracker;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.api.BitAccess;
import mod.chiselsandbits.core.api.BitBrush;
import mod.chiselsandbits.helpers.ChiselToolType;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.integration.mcmultipart.MCMultipartProxy;
import mod.chiselsandbits.items.ItemBitBag;
import mod.chiselsandbits.items.ItemChisel;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.items.ItemMirrorPrint;
import mod.chiselsandbits.items.ItemNegativePrint;
import mod.chiselsandbits.items.ItemPositivePrint;
import mod.chiselsandbits.items.ItemWrench;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;

public class ChiselAndBitsAPI
implements IChiselAndBitsAPI {
    @Override
    public boolean canBeChiseled(World world, BlockPos pos) {
        if (world == null || pos == null) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == Blocks.field_150350_a || BlockBitInfo.supportsBlock(state) || ModUtil.getChiseledTileEntity(world, pos, false) != null;
    }

    @Override
    public boolean isBlockChiseled(World world, BlockPos pos) {
        if (world == null || pos == null) {
            return false;
        }
        return ModUtil.getChiseledTileEntity(world, pos, false) != null;
    }

    @Override
    public IBitAccess getBitAccess(World world, BlockPos pos) throws APIExceptions.CannotBeChiseled {
        if (world == null || pos == null) {
            throw new APIExceptions.CannotBeChiseled();
        }
        IBlockState state = world.func_180495_p(pos);
        if (BlockBitInfo.supportsBlock(state)) {
            VoxelBlob blob = new VoxelBlob();
            blob.fill(Block.func_176210_f((IBlockState)state));
            return new BitAccess(world, pos, blob, VoxelBlob.NULL_BLOB);
        }
        if (world.func_175623_d(pos)) {
            VoxelBlob blob = new VoxelBlob();
            return new BitAccess(world, pos, blob, VoxelBlob.NULL_BLOB);
        }
        TileEntityBlockChiseled te = ModUtil.getChiseledTileEntity(world, pos, true);
        if (te != null) {
            VoxelBlob mask = new VoxelBlob();
            MCMultipartProxy.proxyMCMultiPart.addFiller(world, pos, mask);
            return new BitAccess(world, pos, te.getBlob(), mask);
        }
        throw new APIExceptions.CannotBeChiseled();
    }

    @Override
    public IBitBrush createBrush(ItemStack bitItem) throws APIExceptions.InvalidBitItem {
        int stateID;
        IBlockState state;
        if (bitItem == null) {
            return new BitBrush(0);
        }
        if ((bitItem.func_77973_b() == null || this.getItemType(bitItem) == ItemType.CHISLED_BIT) && (state = Block.func_176220_d((int)(stateID = ItemChiseledBit.getStackState(bitItem)))) != null && BlockBitInfo.supportsBlock(state)) {
            return new BitBrush(stateID);
        }
        throw new APIExceptions.InvalidBitItem();
    }

    @Override
    public IBitLocation getBitPos(float hitX, float hitY, float hitZ, EnumFacing side, BlockPos pos, boolean placement) {
        if (side == null || pos == null) {
            return null;
        }
        MovingObjectPosition mop = new MovingObjectPosition(MovingObjectPosition.MovingObjectType.BLOCK, new Vec3((double)hitX, (double)hitY, (double)hitZ), side, pos);
        return new BitLocation(mop, false, placement ? ChiselToolType.BIT : ChiselToolType.CHISEL);
    }

    @Override
    public ItemType getItemType(ItemStack item) {
        if (item != null && item.func_77973_b() instanceof ItemChiseledBit) {
            return ItemType.CHISLED_BIT;
        }
        if (item != null && item.func_77973_b() instanceof ItemBitBag) {
            return ItemType.BIT_BAG;
        }
        if (item != null && item.func_77973_b() instanceof ItemChisel) {
            return ItemType.CHISEL;
        }
        if (item != null && item.func_77973_b() instanceof ItemBlockChiseled) {
            return ItemType.CHISLED_BLOCK;
        }
        if (item != null && item.func_77973_b() instanceof ItemMirrorPrint) {
            return ItemType.MIRROR_DESIGN;
        }
        if (item != null && item.func_77973_b() instanceof ItemPositivePrint) {
            return ItemType.POSITIVE_DESIGN;
        }
        if (item != null && item.func_77973_b() instanceof ItemNegativePrint) {
            return ItemType.NEGATIVE_DESIGN;
        }
        if (item != null && item.func_77973_b() instanceof ItemWrench) {
            return ItemType.WRENCH;
        }
        return null;
    }

    @Override
    public IBitAccess createBitItem(ItemStack bitItemStack) {
        ItemBlock blkItem;
        IBlockState state;
        if (bitItemStack == null) {
            return new BitAccess(null, null, new VoxelBlob(), VoxelBlob.NULL_BLOB);
        }
        ItemType type = this.getItemType(bitItemStack);
        if (type != null && type.isBitAccess) {
            VoxelBlob blob = ModUtil.getBlobFromStack(bitItemStack, null);
            return new BitAccess(null, null, blob, VoxelBlob.NULL_BLOB);
        }
        if (bitItemStack != null && bitItemStack.func_77973_b() instanceof ItemBlock && BlockBitInfo.supportsBlock(state = (blkItem = (ItemBlock)bitItemStack.func_77973_b()).func_179223_d().func_176203_a(blkItem.getMetadata(bitItemStack)))) {
            VoxelBlob blob = new VoxelBlob();
            blob.fill(Block.func_176210_f((IBlockState)state));
            return new BitAccess(null, null, blob, VoxelBlob.NULL_BLOB);
        }
        return null;
    }

    @Override
    public IBitBrush createBrushFromState(IBlockState state) throws APIExceptions.InvalidBitItem {
        if (state == null || state.func_177230_c() == Blocks.field_150350_a) {
            return new BitBrush(0);
        }
        if (!BlockBitInfo.supportsBlock(state)) {
            throw new APIExceptions.InvalidBitItem();
        }
        return new BitBrush(Block.func_176210_f((IBlockState)state));
    }

    @Override
    public ItemStack getBitItem(IBlockState state) throws APIExceptions.InvalidBitItem {
        if (!BlockBitInfo.supportsBlock(state)) {
            throw new APIExceptions.InvalidBitItem();
        }
        return ItemChiseledBit.createStack(Block.func_176210_f((IBlockState)state), 1, true);
    }

    @Override
    public void giveBitToPlayer(EntityPlayer player, ItemStack is, Vec3 spawnPos) {
        if (is != null) {
            if (spawnPos == null) {
                spawnPos = new Vec3(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            }
            EntityItem ei = new EntityItem(player.func_130014_f_(), spawnPos.field_72450_a, spawnPos.field_72448_b, spawnPos.field_72449_c, is);
            if (is.func_77973_b() == ChiselsAndBits.getItems().itemBlockBit) {
                if (player.func_130014_f_().field_72995_K) {
                    return;
                }
                ModUtil.feedPlayer(player.func_130014_f_(), player, ei);
                return;
            }
            if (!player.field_71071_by.func_70441_a(is)) {
                ei.func_92058_a(is);
                player.func_130014_f_().func_72838_d((Entity)ei);
            }
        }
    }

    @Override
    public IBitBag getBitbag(ItemStack itemstack) {
        Object o;
        if (itemstack != null && (o = itemstack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) instanceof IBitBag) {
            return (IBitBag)o;
        }
        return null;
    }

    @Override
    public void beginUndoGroup(EntityPlayer player) {
        UndoTracker.getInstance().beginGroup(player);
    }

    @Override
    public void endUndoGroup(EntityPlayer player) {
        UndoTracker.getInstance().endGroup(player);
    }
}

