/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.core;

import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.helpers.LocalStrings;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;

public enum ChiselMode {
    SINGLE(LocalStrings.ChiselModeSingle),
    SNAP2(LocalStrings.ChiselModeSnap2),
    SNAP4(LocalStrings.ChiselModeSnap4),
    SNAP8(LocalStrings.ChiselModeSnap8),
    LINE(LocalStrings.ChiselModeLine),
    PLANE(LocalStrings.ChiselModePlane),
    CONNECTED_PLANE(LocalStrings.ChiselModeConnectedPlane),
    CUBE_SMALL(LocalStrings.ChiselModeCubeSmall),
    CUBE_MEDIUM(LocalStrings.ChiselModeCubeMedium),
    CUBE_LARGE(LocalStrings.ChiselModeCubeLarge),
    DRAWN_REGION(LocalStrings.ChiselModeDrawnRegion);

    public final LocalStrings string;
    public boolean isDisabled = false;
    public Object binding;

    private ChiselMode(LocalStrings str) {
        this.string = str;
    }

    public static ChiselMode getMode(ItemStack stack) {
        if (stack != null) {
            try {
                NBTTagCompound nbt = stack.func_77978_p();
                if (nbt != null && nbt.func_74764_b("mode")) {
                    return ChiselMode.valueOf(nbt.func_74779_i("mode"));
                }
            }
            catch (Exception e) {
                Log.logError("Unable to determine mode.", e);
            }
        }
        return SINGLE;
    }

    public void setMode(ItemStack stack) {
        if (stack != null) {
            stack.func_77983_a("mode", (NBTBase)new NBTTagString(this.name()));
        }
    }

    public static ChiselMode getMode(int offset) {
        return ChiselMode.values()[offset % ChiselMode.values().length];
    }
}

