/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.ItemType;
import mod.chiselsandbits.chiseledblock.NBTBlobConverter;
import mod.chiselsandbits.client.ClipboardStorage;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.interfaces.ICacheClearable;
import mod.chiselsandbits.registry.ModItems;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CreativeClipboardTab
extends CreativeTabs
implements ICacheClearable {
    static boolean renewMappings = true;
    private static List<ItemStack> myWorldItems = new ArrayList<ItemStack>();
    private static List<ItemStack> myCrossItems = new ArrayList<ItemStack>();
    private static ClipboardStorage clipStorage = null;

    public static void load(File file) {
        clipStorage = new ClipboardStorage(file);
        myCrossItems = clipStorage.read();
    }

    public static void addItem(ItemStack iss) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            IBitAccess bitData = ChiselsAndBits.getApi().createBitItem(iss);
            if (bitData == null) {
                return;
            }
            ItemStack is = bitData.getBitsAsItem(null, ItemType.CHISLED_BLOCK, true);
            if (is == null) {
                return;
            }
            for (ItemStack isa : myCrossItems) {
                if (!ItemStack.func_77970_a((ItemStack)is, (ItemStack)isa)) continue;
                myCrossItems.remove(isa);
                break;
            }
            myCrossItems.add(0, is);
            while (myCrossItems.size() > ChiselsAndBits.getConfig().creativeClipboardSize && !myCrossItems.isEmpty()) {
                myCrossItems.remove(myCrossItems.size() - 1);
            }
            clipStorage.write(myCrossItems);
            myWorldItems.clear();
            renewMappings = true;
        }
    }

    public CreativeClipboardTab() {
        super("chiselsandbits.Clipboard");
        ChiselsAndBits.getInstance().addClearable(this);
    }

    public Item func_78016_d() {
        ModItems cbitems = ChiselsAndBits.getItems();
        return ModUtil.firstNonNull(new Item[]{cbitems.itemPositiveprint, cbitems.itemNegativeprint, cbitems.itemBitBag, cbitems.itemChiselDiamond, cbitems.itemChiselGold, cbitems.itemChiselIron, cbitems.itemChiselStone, cbitems.itemWrench});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_78018_a(List<ItemStack> itemList) {
        if (renewMappings) {
            myWorldItems.clear();
            renewMappings = false;
            for (ItemStack is : myCrossItems) {
                NBTBlobConverter c = new NBTBlobConverter();
                c.readChisleData(is.func_179543_a("BlockEntityTag", true));
                c.updateFromBlob();
                ItemStack worldItem = c.getItemStack(false);
                if (worldItem == null) continue;
                myWorldItems.add(worldItem);
            }
        }
        itemList.addAll(myWorldItems);
    }

    @Override
    public void clearCache() {
        renewMappings = true;
    }
}

