/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client;

import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mod.chiselsandbits.core.ChiselsAndBits;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ClipboardStorage
extends Configuration {
    public ClipboardStorage(File file) {
        super(file);
    }

    public void write(List<ItemStack> myitems) {
        if (!ChiselsAndBits.getConfig().persistCreativeClipboard) {
            return;
        }
        for (String name : this.getCategoryNames()) {
            this.removeCategory(this.getCategory(name));
        }
        int idx = 0;
        for (ItemStack i : myitems) {
            if (!i.func_77942_o()) continue;
            NBTTagCompound nbt = i.func_77978_p();
            PacketBuffer b = new PacketBuffer(Unpooled.buffer());
            b.func_180714_a(((ResourceLocation)Item.field_150901_e.func_177774_c((Object)i.func_77973_b())).toString());
            b.func_150786_a(nbt);
            int[] o = new int[b.writerIndex()];
            for (int x = 0; x < b.writerIndex(); ++x) {
                o[x] = b.getByte(x);
            }
            this.get("clipboard", "" + idx++, o).set(o);
        }
        this.save();
    }

    public List<ItemStack> read() {
        ArrayList<ItemStack> myItems = new ArrayList<ItemStack>();
        if (!ChiselsAndBits.getConfig().persistCreativeClipboard) {
            return myItems;
        }
        for (Property p : this.getCategory("clipboard").values()) {
            int[] bytes = p.getIntList();
            byte[] o = new byte[bytes.length];
            for (int x = 0; x < bytes.length; ++x) {
                o[x] = (byte)bytes[x];
            }
            try {
                PacketBuffer b = new PacketBuffer(Unpooled.wrappedBuffer((byte[])o));
                String item = b.func_150789_c(127);
                NBTTagCompound c = b.func_150793_b();
                ItemStack stack = new ItemStack(Item.func_111206_d((String)item));
                stack.func_77982_d(c);
                myItems.add(stack);
            }
            catch (IOException iOException) {}
        }
        return myItems;
    }
}

