/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock.serialization;

import java.util.HashMap;
import java.util.Map;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.serialization.BitStream;
import net.minecraft.network.PacketBuffer;

public class BlobSerializer {
    private final int types;
    private final Map<Integer, Integer> index;
    private final int[] palette;
    private final int bitsPerInt;
    private final int bitsPerIntMinus1;
    int lastState = -1;
    int lastIndex = -1;

    public BlobSerializer(VoxelBlob toDeflate) {
        Map<Integer, Integer> entries = toDeflate.getBlockSums();
        this.types = entries.size();
        this.index = new HashMap<Integer, Integer>(this.types);
        this.palette = new int[this.types];
        int offset = 0;
        for (Map.Entry<Integer, Integer> o : entries.entrySet()) {
            int stateID;
            this.palette[offset] = stateID = o.getKey().intValue();
            this.index.put(stateID, offset++);
        }
        this.bitsPerInt = this.bitsPerBit();
        this.bitsPerIntMinus1 = this.bitsPerInt - 1;
    }

    public BlobSerializer(PacketBuffer toInflate) {
        this.types = toInflate.func_150792_a();
        this.palette = new int[this.types];
        this.index = null;
        for (int x = 0; x < this.types; ++x) {
            this.palette[x] = this.readStateID(toInflate);
        }
        this.bitsPerInt = this.bitsPerBit();
        this.bitsPerIntMinus1 = this.bitsPerInt - 1;
    }

    public void write(PacketBuffer to) {
        to.func_150787_b(this.palette.length);
        for (int x = 0; x < this.palette.length; ++x) {
            this.writeStateID(to, this.palette[x]);
        }
    }

    protected int readStateID(PacketBuffer buffer) {
        return buffer.func_150792_a();
    }

    protected void writeStateID(PacketBuffer buffer, int key) {
        buffer.func_150787_b(key);
    }

    private int bitsPerBit() {
        int bits = 32 - Integer.numberOfLeadingZeros(this.types - 1);
        return Math.max(bits, 1);
    }

    private int getIndex(int stateID) {
        if (this.lastState == stateID) {
            return this.lastIndex;
        }
        this.lastState = stateID;
        this.lastIndex = this.index.get(stateID);
        return this.lastIndex;
    }

    private int getStateID(int indexID) {
        return this.palette[indexID];
    }

    public int getVersion() {
        return VoxelBlob.VERSION_COMPACT;
    }

    public int readVoxelStateID(BitStream bits) {
        int index = 0;
        for (int x = this.bitsPerIntMinus1; x >= 0; --x) {
            index |= bits.get() ? 1 << x : 0;
        }
        return this.getStateID(index);
    }

    public void writeVoxelState(int stateID, BitStream stream) {
        int index = this.getIndex(stateID);
        switch (this.bitsPerInt) {
            default: {
                throw new RuntimeException("bitsPerInt is not valid, " + this.bitsPerInt);
            }
            case 16: {
                stream.add((index & 0x8000) != 0);
            }
            case 15: {
                stream.add((index & 0x4000) != 0);
            }
            case 14: {
                stream.add((index & 0x2000) != 0);
            }
            case 13: {
                stream.add((index & 0x1000) != 0);
            }
            case 12: {
                stream.add((index & 0x800) != 0);
            }
            case 11: {
                stream.add((index & 0x400) != 0);
            }
            case 10: {
                stream.add((index & 0x200) != 0);
            }
            case 9: {
                stream.add((index & 0x100) != 0);
            }
            case 8: {
                stream.add((index & 0x80) != 0);
            }
            case 7: {
                stream.add((index & 0x40) != 0);
            }
            case 6: {
                stream.add((index & 0x20) != 0);
            }
            case 5: {
                stream.add((index & 0x10) != 0);
            }
            case 4: {
                stream.add((index & 8) != 0);
            }
            case 3: {
                stream.add((index & 4) != 0);
            }
            case 2: {
                stream.add((index & 2) != 0);
            }
            case 1: 
        }
        stream.add((index & 1) != 0);
    }
}

