/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.NBTBlobConverter;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.BitLocation;
import mod.chiselsandbits.chiseledblock.data.IntegerBox;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.helpers.ChiselToolType;
import mod.chiselsandbits.helpers.ExceptionNoTileEntity;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.interfaces.IItemScrollWheel;
import mod.chiselsandbits.interfaces.IVoxelBlobItem;
import mod.chiselsandbits.network.NetworkRouter;
import mod.chiselsandbits.network.packets.PacketRotateVoxelBlob;
import mod.chiselsandbits.render.helpers.SimpleInstanceCache;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockChiseled
extends ItemBlock
implements IVoxelBlobItem,
IItemScrollWheel {
    public static final String NBT_CHISELED_DATA = "BlockEntityTag";
    public static final String NBT_SIDE = "side";
    SimpleInstanceCache<ItemStack, List<String>> tooltipCache = new SimpleInstanceCache(null, new ArrayList());

    public ItemBlockChiseled(Block block) {
        super(block);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        ChiselsAndBits.getConfig().helpText(LocalStrings.HelpChiseledBlock, tooltip, new String[0]);
        if (stack.func_77942_o()) {
            if (ClientSide.instance.holdingShift()) {
                if (this.tooltipCache.needsUpdate(stack)) {
                    VoxelBlob blob = ModUtil.getBlobFromStack(stack, null);
                    this.tooltipCache.updateCachedValue(blob.listContents(new ArrayList<String>()));
                }
                tooltip.addAll((Collection<String>)this.tooltipCache.getCached());
            } else {
                tooltip.add(LocalStrings.ShiftDetails.getLocal());
            }
        }
    }

    public int func_82790_a(ItemStack stack, int tint) {
        Block blk = Block.func_176220_d((int)tint).func_177230_c();
        Item i = Item.func_150898_a((Block)blk);
        if (i != null) {
            return i.func_82790_a(stack, 0);
        }
        return super.func_82790_a(stack, tint);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_179222_a(World worldIn, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        return this.canPlaceBlockHere(worldIn, pos, side, player, stack);
    }

    public boolean vanillaStylePlacementTest(World worldIn, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_150431_aC) {
            side = EnumFacing.UP;
        } else if (!block.func_176200_f(worldIn, pos)) {
            pos = pos.func_177972_a(side);
        }
        return worldIn.func_175716_a(this.field_150939_a, pos, false, side, (Entity)null, stack);
    }

    public boolean canPlaceBlockHere(World worldIn, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        if (this.vanillaStylePlacementTest(worldIn, pos, side, player, stack)) {
            return true;
        }
        if (player.func_70093_af()) {
            return true;
        }
        if (ItemBlockChiseled.tryPlaceBlockAt(this.field_150939_a, stack, (EntityLivingBase)player, worldIn, pos, side, null, false)) {
            return true;
        }
        return ItemBlockChiseled.tryPlaceBlockAt(this.field_150939_a, stack, (EntityLivingBase)player, worldIn, pos.func_177972_a(side), side, null, false);
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150431_aC && (Integer)state.func_177229_b((IProperty)BlockSnow.field_176315_a) < 1) {
            side = EnumFacing.UP;
        } else {
            TileEntityBlockChiseled tebc;
            boolean canMerge = false;
            if (stack.func_77942_o() && (tebc = ModUtil.getChiseledTileEntity(worldIn, pos, true)) != null) {
                VoxelBlob blob = ModUtil.getBlobFromStack(stack, (EntityLivingBase)playerIn);
                canMerge = tebc.canMerge(blob);
            }
            if (!(canMerge || playerIn.func_70093_af() || block.func_176200_f(worldIn, pos))) {
                pos = pos.func_177972_a(side);
            }
        }
        if (stack.field_77994_a == 0) {
            return false;
        }
        if (!playerIn.func_175151_a(pos, side, stack)) {
            return false;
        }
        if (pos.func_177956_o() == 255 && this.field_150939_a.func_149688_o().func_76220_a()) {
            return false;
        }
        if (this.canPlaceBlockHere(worldIn, pos, side, playerIn, stack)) {
            int i = this.func_77647_b(stack.func_77960_j());
            IBlockState iblockstate1 = this.field_150939_a.func_180642_a(worldIn, pos, side, hitX, hitY, hitZ, i, (EntityLivingBase)playerIn);
            if (this.placeBlockAt(stack, playerIn, worldIn, pos, side, hitX, hitY, hitZ, iblockstate1)) {
                worldIn.func_72908_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), this.field_150939_a.field_149762_H.func_150496_b(), (this.field_150939_a.field_149762_H.func_150497_c() + 1.0f) / 2.0f, this.field_150939_a.field_149762_H.func_150494_d() * 0.8f);
                --stack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (player.func_70093_af()) {
            BitLocation bl = new BitLocation(new MovingObjectPosition(MovingObjectPosition.MovingObjectType.BLOCK, new Vec3((double)hitX, (double)hitY, (double)hitZ), side, pos), false, ChiselToolType.BIT);
            return ItemBlockChiseled.tryPlaceBlockAt(this.field_150939_a, stack, (EntityLivingBase)player, world, bl.blockPos, side, new BlockPos(bl.bitX, bl.bitY, bl.bitZ), true);
        }
        return ItemBlockChiseled.tryPlaceBlockAt(this.field_150939_a, stack, (EntityLivingBase)player, world, pos, side, null, true);
    }

    public static boolean tryPlaceBlockAt(Block block, ItemStack stack, EntityLivingBase player, World world, BlockPos pos, EnumFacing side, BlockPos partial, boolean modulateWorld) {
        try {
            int z;
            int y;
            int x;
            VoxelBlob[][][] blobs = new VoxelBlob[2][2][2];
            if (!stack.func_77942_o()) {
                return false;
            }
            VoxelBlob source = ModUtil.getBlobFromStack(stack, player);
            IntegerBox modelBounds = source.getBounds();
            BlockPos offset = partial == null ? new BlockPos(0, 0, 0) : ModUtil.getPartialOffset(side, partial, modelBounds);
            BlockChiseled myBlock = (BlockChiseled)block;
            if (offset.func_177958_n() < 0) {
                pos = pos.func_177982_a(-1, 0, 0);
                offset = offset.func_177982_a(16, 0, 0);
            }
            if (offset.func_177956_o() < 0) {
                pos = pos.func_177982_a(0, -1, 0);
                offset = offset.func_177982_a(0, 16, 0);
            }
            if (offset.func_177952_p() < 0) {
                pos = pos.func_177982_a(0, 0, -1);
                offset = offset.func_177982_a(0, 0, 16);
            }
            for (x = 0; x < 2; ++x) {
                for (y = 0; y < 2; ++y) {
                    for (z = 0; z < 2; ++z) {
                        BlockPos bp;
                        blobs[x][y][z] = source.offset(offset.func_177958_n() - source.detail * x, offset.func_177956_o() - source.detail * y, offset.func_177952_p() - source.detail * z);
                        int solids = blobs[x][y][z].filled();
                        if (solids <= 0 || world.func_175623_d(bp = pos.func_177982_a(x, y, z)) || world.func_180495_p(bp).func_177230_c().func_176200_f(world, bp)) continue;
                        TileEntityBlockChiseled target = ModUtil.getChiseledTileEntity(world, bp, true);
                        if (target != null) {
                            if (!target.canMerge(blobs[x][y][z])) {
                                return false;
                            }
                            blobs[x][y][z] = blobs[x][y][z].merge(target.getBlob());
                            continue;
                        }
                        return false;
                    }
                }
            }
            if (modulateWorld) {
                for (x = 0; x < 2; ++x) {
                    for (y = 0; y < 2; ++y) {
                        for (z = 0; z < 2; ++z) {
                            if (blobs[x][y][z].filled() <= 0) continue;
                            BlockPos bp = pos.func_177982_a(x, y, z);
                            IBlockState state = world.func_180495_p(bp);
                            if (world.func_180495_p(bp).func_177230_c().func_176200_f(world, bp)) {
                                world.func_175698_g(bp);
                            }
                            if (world.func_175623_d(bp)) {
                                int commonBlock = blobs[x][y][z].getVoxelStats().mostCommonState;
                                if (!BlockChiseled.replaceWithChisled(world, bp, state, commonBlock, true)) continue;
                                TileEntityBlockChiseled target = myBlock.getTileEntity((IBlockAccess)world, bp);
                                target.setBlob(blobs[x][y][z]);
                                continue;
                            }
                            TileEntityBlockChiseled target = ModUtil.getChiseledTileEntity(world, bp, true);
                            if (target != null) {
                                target.setBlob(blobs[x][y][z]);
                                continue;
                            }
                            return false;
                        }
                    }
                }
            }
            return true;
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return false;
        }
    }

    public String func_77653_i(ItemStack stack) {
        NBTTagCompound BlockEntityTag;
        NBTTagCompound comp = stack.func_77978_p();
        if (comp != null && (BlockEntityTag = comp.func_74775_l(NBT_CHISELED_DATA)) != null) {
            NBTBlobConverter c = new NBTBlobConverter();
            c.readChisleData(BlockEntityTag);
            IBlockState state = c.getPrimaryBlockState();
            Block blk = state.func_177230_c();
            ItemStack target = new ItemStack(blk, 1, blk.func_176201_c(state));
            if (target.func_77973_b() != null) {
                return super.func_77653_i(stack) + " - " + target.func_82833_r();
            }
        }
        return super.func_77653_i(stack);
    }

    @Override
    public void scroll(EntityPlayer player, ItemStack stack, int dwheel) {
        PacketRotateVoxelBlob p = new PacketRotateVoxelBlob();
        p.rotationDirection = dwheel;
        NetworkRouter.instance.sendToServer(p);
    }

    @Override
    public void rotate(ItemStack stack, int rotationDirection) {
        NBTTagCompound blueprintTag = stack.func_77978_p();
        EnumFacing side = EnumFacing.field_82609_l[blueprintTag.func_74771_c(NBT_SIDE)];
        if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
            side = EnumFacing.NORTH;
        }
        side = rotationDirection > 0 ? side.func_176746_e() : side.func_176735_f();
        blueprintTag.func_74768_a(NBT_SIDE, side.ordinal());
    }
}

