/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import slimeknights.mantle.client.gui.GuiElement;
import slimeknights.mantle.client.gui.GuiElementScalable;
import slimeknights.mantle.client.gui.GuiModule;
import slimeknights.mantle.client.gui.GuiMultiModule;
import slimeknights.mantle.client.gui.GuiWidgetSlider;
import slimeknights.tconstruct.tools.client.module.GuiGeneric;

public class GuiDynInventory
extends GuiModule {
    protected static final GuiElementScalable slot = GuiGeneric.slot;
    protected static final GuiElementScalable slotEmpty = GuiGeneric.slotEmpty;
    protected static final GuiElement sliderNormal = GuiGeneric.sliderNormal;
    protected static final GuiElement sliderLow = GuiGeneric.sliderLow;
    protected static final GuiElement sliderHigh = GuiGeneric.sliderHigh;
    protected static final GuiElement sliderTop = GuiGeneric.sliderTop;
    protected static final GuiElement sliderBottom = GuiGeneric.sliderBottom;
    protected static final GuiElementScalable sliderBackground = GuiGeneric.sliderBackground;
    protected GuiWidgetSlider slider = new GuiWidgetSlider(sliderNormal, sliderHigh, sliderLow, sliderTop, sliderBottom, sliderBackground);
    protected int columns;
    protected int rows;
    protected int slotCount;
    protected boolean sliderActive;
    protected int firstSlotId;
    protected int lastSlotId;
    protected final Container container;

    public GuiDynInventory(GuiMultiModule parent, Container container) {
        super(parent, container, false, false);
        this.container = container;
        this.xOffset = 7;
        this.yOffset = 17;
        this.field_146999_f = 162;
        this.field_147000_g = 54;
        this.slotCount = container.field_75151_b.size();
        this.firstSlotId = 0;
        this.lastSlotId = this.slotCount;
    }

    public void updatePosition(int parentX, int parentY, int parentSizeX, int parentSizeY) {
        this.field_147003_i = parentX + this.xOffset;
        this.field_147009_r = parentY + this.yOffset;
        this.columns = this.field_146999_f / GuiDynInventory.slot.w;
        this.rows = this.field_147000_g / GuiDynInventory.slot.h;
        this.sliderActive = this.slotCount > this.columns * this.rows;
        this.updateSlider();
        if (this.sliderActive) {
            this.columns = (this.field_146999_f - this.slider.width) / GuiDynInventory.slot.w;
            this.updateSlider();
        }
        this.updateSlots();
    }

    protected void updateSlider() {
        int max = 0;
        if (this.sliderActive) {
            this.slider.show();
            max = this.slotCount / this.columns - this.rows + 1;
        } else {
            this.slider.hide();
        }
        this.slider.setPosition(this.field_147003_i + this.field_146999_f - this.slider.width, this.field_147009_r);
        this.slider.setSize(this.field_147000_g);
        this.slider.setSliderParameters(0, max, 1);
    }

    public void update(int mouseX, int mouseY) {
        if (!this.sliderActive) {
            return;
        }
        this.slider.update(mouseX, mouseY, !this.isMouseOverFullSlot(mouseX, mouseY) && this.isMouseInModule(mouseX, mouseY));
        this.updateSlots();
    }

    public boolean shouldDrawSlot(Slot slot) {
        if (!this.slider.isEnabled()) {
            return true;
        }
        int index = slot.getSlotIndex();
        return this.firstSlotId <= index && this.lastSlotId > index;
    }

    public void updateSlots() {
        this.firstSlotId = this.slider.getValue() * this.columns;
        this.lastSlotId = Math.min(this.slotCount, this.firstSlotId + this.rows * this.columns);
        for (Slot slot : this.container.field_75151_b) {
            if (this.shouldDrawSlot(slot)) {
                int offset = slot.getSlotIndex() - this.firstSlotId;
                int x = offset % this.columns * GuiDynInventory.slot.w;
                int y = offset / this.columns * GuiDynInventory.slot.h;
                slot.field_75223_e = this.xOffset + x + 1;
                slot.field_75221_f = this.yOffset + y + 1;
                continue;
            }
            slot.field_75223_e = 0;
            slot.field_75221_f = 0;
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int y;
        this.field_146297_k.func_110434_K().func_110577_a(GuiGeneric.LOCATION);
        if (!this.slider.isHidden()) {
            this.slider.draw();
            this.updateSlots();
        }
        int fullRows = (this.lastSlotId - this.firstSlotId) / this.columns;
        int w = this.columns * GuiDynInventory.slot.w;
        for (y = 0; y < fullRows * GuiDynInventory.slot.h && y < this.field_147000_g; y += GuiDynInventory.slot.h) {
            slot.drawScaledX(this.field_147003_i, this.field_147009_r + y, w);
        }
        int slotsLeft = (this.lastSlotId - this.firstSlotId) % this.columns;
        if (slotsLeft > 0) {
            slot.drawScaledX(this.field_147003_i, this.field_147009_r + y, slotsLeft * GuiDynInventory.slot.w);
            slotEmpty.drawScaledX(this.field_147003_i + slotsLeft * GuiDynInventory.slot.w, this.field_147009_r + y, w - slotsLeft * GuiDynInventory.slot.w);
        }
    }
}

