/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave;

import crazypants.util.NullHelper;
import info.loenwind.autosave.Registry;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.engine.StorableEngine;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class Writer {
    public static <T> void write(@Nonnull Registry registry, @Nonnull Set<Store.StoreFor> phase, @Nonnull NBTTagCompound tag, @Nonnull T object) {
        try {
            StorableEngine.store(registry, phase, tag, object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (NoHandlerFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void write(@Nullable Set<Store.StoreFor> phase, @Nullable NBTTagCompound tag, @Nonnull T object) {
        Writer.write(Registry.GLOBAL_REGISTRY, NullHelper.notnull(phase, "Missing phase"), NullHelper.notnull(tag, "Missing NBT"), object);
    }

    public static <T> void write(@Nonnull Registry registry, @Nonnull Store.StoreFor phase, @Nullable NBTTagCompound tag, @Nonnull T object) {
        Writer.write(registry, (Set<Store.StoreFor>)NullHelper.notnullJ(EnumSet.of(phase), "EnumSet.of()"), NullHelper.notnull(tag, "Missing NBT"), object);
    }

    public static <T> void write(@Nonnull Store.StoreFor phase, @Nullable NBTTagCompound tag, @Nonnull T object) {
        Writer.write(Registry.GLOBAL_REGISTRY, (Set<Store.StoreFor>)NullHelper.notnullJ(EnumSet.of(phase), "EnumSet.of()"), NullHelper.notnull(tag, "Missing NBT"), object);
    }

    public static <T> void write(@Nonnull Registry registry, @Nullable NBTTagCompound tag, @Nonnull T object) {
        Writer.write(registry, (Set<Store.StoreFor>)NullHelper.notnullJ(EnumSet.allOf(Store.StoreFor.class), "EnumSet.allOf()"), NullHelper.notnull(tag, "Missing NBT"), object);
    }

    public static <T> void write(@Nullable NBTTagCompound tag, @Nonnull T object) {
        Writer.write(Registry.GLOBAL_REGISTRY, (Set<Store.StoreFor>)NullHelper.notnullJ(EnumSet.allOf(Store.StoreFor.class), "EnumSet.allOf()"), NullHelper.notnull(tag, "Missing NBT"), object);
    }

    public static <T> void writeField(@Nullable NBTTagCompound tag, @Nullable Class<T> fieldClass, @Nullable String fieldName, @Nullable T object) {
        try {
            StorableEngine.setSingleField(Registry.GLOBAL_REGISTRY, (Set<Store.StoreFor>)NullHelper.notnullJ(EnumSet.allOf(Store.StoreFor.class), "EnumSet.allOf()"), NullHelper.notnull(tag, "Missing NBT"), NullHelper.notnull(fieldName, "Missing field name"), NullHelper.notnull(fieldClass, "Missing field class"), object);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (NoHandlerFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

