/*
 * Decompiled with CFR 0.152.
 */
package crazypants.util;

import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Profiler {
    public static final Profiler client;
    public static final Profiler server;
    private ConcurrentHashMap<String, Long> profiler = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long> profilerC = new ConcurrentHashMap();
    private long lastProfiled = 0L;
    private boolean on = false;

    public long start() {
        this.on = EnderIO.proxy.getTickCount() > 600L;
        return this.on ? System.nanoTime() : Long.MAX_VALUE;
    }

    public long start_always() {
        this.on = true;
        return System.nanoTime();
    }

    public long pause(long start) {
        return this.on ? System.nanoTime() - start : Long.MAX_VALUE;
    }

    public long resume(long start) {
        return this.on ? System.nanoTime() - start : Long.MAX_VALUE;
    }

    public void stop(long start, String source) {
        long elapsed;
        long l = elapsed = this.on ? System.nanoTime() - start : -1L;
        if (elapsed >= 0L) {
            try {
                this.profiler.putIfAbsent(source, 0L);
                this.profilerC.putIfAbsent(source, 0L);
                this.profiler.put(source, this.profiler.get(source) + elapsed);
                this.profilerC.put(source, this.profilerC.get(source) + 1L);
                if (EnderIO.proxy.getTickCount() > this.lastProfiled) {
                    this.lastProfiled = EnderIO.proxy.getTickCount() + 200L;
                    for (Map.Entry<String, Long> e : this.profiler.entrySet()) {
                        long avg = e.getValue() / this.profilerC.get(e.getKey());
                        Log.info(e.getKey() + ": " + avg + " ns avg over " + this.profilerC.get(e.getKey()) + " calls");
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static {
        server = client = new Profiler();
    }
}

