/*
 * Decompiled with CFR 0.152.
 */
package crazypants.util;

import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.util.EntityUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockWall;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class CapturedMob {
    public static final String ENTITY_KEY = "entity";
    public static final String ENTITY_ID_KEY = "entityId";
    public static final String CUSTOM_NAME_KEY = "customName";
    public static final String IS_STUB_KEY = "isStub";
    public static final String IS_VARIANT_KEY = "isVariant";
    private static final List<String> blacklist = new ArrayList<String>();
    private final NBTTagCompound entityNbt;
    private final String entityId;
    private final String customName;
    private final boolean isStub;
    private final boolean isVariant;

    private CapturedMob(@Nonnull EntityLivingBase entity) {
        EntityLiving entLiv;
        this.entityId = EntityList.func_75621_b((Entity)entity);
        this.entityNbt = entity.serializeNBT();
        String name = null;
        if (entity instanceof EntityLiving && (entLiv = (EntityLiving)entity).func_145818_k_()) {
            name = entLiv.func_95999_t();
        }
        this.customName = name != null && name.length() > 0 ? name : null;
        this.isVariant = entity instanceof EntitySkeleton ? ((EntitySkeleton)entity).func_82202_m() == 1 : false;
        this.isStub = false;
    }

    private CapturedMob(NBTTagCompound nbt) {
        this.entityNbt = nbt.func_74764_b(ENTITY_KEY) ? (NBTTagCompound)nbt.func_74775_l(ENTITY_KEY).func_74737_b() : null;
        this.entityId = nbt.func_74764_b(ENTITY_ID_KEY) ? nbt.func_74779_i(ENTITY_ID_KEY) : null;
        this.customName = nbt.func_74764_b(CUSTOM_NAME_KEY) ? nbt.func_74779_i(CUSTOM_NAME_KEY) : null;
        this.isStub = nbt.func_74767_n(IS_STUB_KEY);
        this.isVariant = nbt.func_74767_n(IS_VARIANT_KEY);
    }

    private CapturedMob(String entityId, boolean isVariant) {
        this.entityNbt = null;
        this.entityId = entityId;
        this.customName = null;
        this.isStub = true;
        this.isVariant = isVariant;
    }

    @Nullable
    public static CapturedMob create(@Nullable Entity entity) {
        if (!(entity instanceof EntityLivingBase) || entity.field_70170_p == null || entity.field_70170_p.field_72995_K || entity instanceof EntityPlayer || CapturedMob.isBlacklisted(entity)) {
            return null;
        }
        return new CapturedMob((EntityLivingBase)entity);
    }

    @Nullable
    public static CapturedMob create(@Nullable String entityId, boolean isVariant) {
        if (entityId == null || !EntityList.func_180125_b((String)entityId)) {
            return null;
        }
        return new CapturedMob(entityId, isVariant);
    }

    @Nonnull
    public ItemStack toStack(Item item, int meta, int amount) {
        ItemStack stack = new ItemStack(item, amount, meta);
        stack.func_77982_d(this.toNbt(null));
        if (item == EnderIO.itemSoulVessel && this.customName == null && "Pig".equals(this.entityId) && Math.random() < 0.01) {
            stack.func_77978_p().func_74778_a(CUSTOM_NAME_KEY, EnderIO.lang.localize("easteregg.piginabottle"));
        }
        return stack;
    }

    @Nonnull
    public NBTTagCompound toNbt(@Nullable NBTTagCompound nbt) {
        NBTTagCompound data;
        NBTTagCompound nBTTagCompound = data = nbt != null ? nbt : new NBTTagCompound();
        if (this.entityNbt != null) {
            data.func_74782_a(ENTITY_KEY, this.entityNbt.func_74737_b());
        }
        if (this.entityId != null) {
            data.func_74778_a(ENTITY_ID_KEY, this.entityId);
        }
        if (this.customName != null) {
            data.func_74778_a(CUSTOM_NAME_KEY, this.customName);
        }
        if (this.isStub) {
            data.func_74757_a(IS_STUB_KEY, this.isStub);
        }
        if (this.isVariant) {
            data.func_74757_a(IS_VARIANT_KEY, this.isVariant);
        }
        return data;
    }

    public static boolean containsSoul(@Nullable NBTTagCompound nbt) {
        return nbt != null && (nbt.func_74764_b(ENTITY_KEY) || nbt.func_74764_b(ENTITY_ID_KEY) && nbt.func_74764_b(IS_STUB_KEY));
    }

    public static boolean containsSoul(@Nullable ItemStack stack) {
        return stack != null && stack.func_77942_o() && CapturedMob.containsSoul(stack.func_77978_p());
    }

    @Nullable
    public static CapturedMob create(@Nullable ItemStack stack) {
        if (CapturedMob.containsSoul(stack)) {
            return new CapturedMob(stack.func_77978_p());
        }
        return null;
    }

    @Nullable
    public static CapturedMob create(@Nullable NBTTagCompound nbt) {
        if (CapturedMob.containsSoul(nbt)) {
            return new CapturedMob(nbt);
        }
        return null;
    }

    public static boolean isBlacklisted(@Nonnull Entity entity) {
        String entityId = EntityList.func_75621_b((Entity)entity);
        if (entityId == null || entityId.trim().isEmpty() || !Config.soulVesselCapturesBosses && entity instanceof IBossDisplayData) {
            return true;
        }
        return Config.soulVesselBlackList.contains(entityId) || blacklist.contains(entityId);
    }

    public boolean spawn(@Nullable World world, @Nullable BlockPos pos, @Nullable EnumFacing side, boolean clone) {
        if (world == null || pos == null) {
            return false;
        }
        EnumFacing theSide = side != null ? side : EnumFacing.UP;
        Entity entity = this.getEntity(world, clone);
        if (entity == null) {
            return false;
        }
        Block blk = world.func_180495_p(pos).func_177230_c();
        double spawnX = (double)(pos.func_177958_n() + theSide.func_82601_c()) + 0.5;
        double spawnY = pos.func_177956_o() + theSide.func_96559_d();
        double spawnZ = (double)(pos.func_177952_p() + theSide.func_82599_e()) + 0.5;
        if (theSide == EnumFacing.UP && (blk instanceof BlockFence || blk instanceof BlockWall || blk instanceof BlockFenceGate)) {
            spawnY += 0.5;
        }
        entity.func_70012_b(spawnX, spawnY, spawnZ, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        if (!world.func_72855_b(entity.func_174813_aQ()) || !world.func_72945_a(entity, entity.func_174813_aQ()).isEmpty()) {
            return false;
        }
        if (this.customName != null && entity instanceof EntityLiving) {
            ((EntityLiving)entity).func_96094_a(this.customName);
        }
        if (!world.func_72838_d(entity)) {
            return false;
        }
        if (entity instanceof EntityLiving) {
            ((EntityLiving)entity).func_70642_aH();
        }
        Entity riddenByEntity = entity.field_70153_n;
        while (riddenByEntity != null) {
            riddenByEntity.func_70012_b(spawnX, spawnY, spawnZ, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (world.func_72838_d(riddenByEntity)) {
                if (riddenByEntity instanceof EntityLiving) {
                    ((EntityLiving)riddenByEntity).func_70642_aH();
                }
                riddenByEntity = riddenByEntity.field_70153_n;
                continue;
            }
            riddenByEntity = null;
        }
        return true;
    }

    @Nullable
    public Entity getEntity(@Nullable World world, boolean clone) {
        Entity entity = null;
        if (world != null) {
            if ((this.isStub || !clone) && this.entityId != null) {
                entity = EntityList.func_75620_a((String)this.entityId, (World)world);
            } else if (this.entityNbt != null) {
                entity = clone ? EntityList.func_75615_a((NBTTagCompound)this.entityNbt, (World)world) : EntityList.func_75620_a((String)this.entityNbt.func_74779_i("id"), (World)world);
            }
        }
        if (this.isVariant && entity instanceof EntitySkeleton) {
            EntitySkeleton skel = (EntitySkeleton)entity;
            skel.func_82201_a(1);
            skel.func_70062_b(0, new ItemStack(Items.field_151052_q));
            skel.func_70062_b(1, null);
            skel.func_70062_b(2, null);
            skel.func_70062_b(3, null);
            skel.func_70062_b(4, null);
            skel.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
            skel.func_85036_m();
            Calendar calendar = world.func_83015_S();
            if (calendar.get(2) + 1 == 10 && calendar.get(5) == 31 && Math.random() < 0.25) {
                skel.func_70062_b(4, new ItemStack(Math.random() < 0.1 ? Blocks.field_150428_aP : Blocks.field_150423_aK));
                skel.func_96120_a(4, 0.0f);
            } else if (calendar.get(2) + 1 == 12 && calendar.get(5) == 6 && Math.random() < 0.25) {
                skel.func_70062_b(0, new ItemStack((Item)(Math.random() < 0.25 ? Items.field_151021_T : Items.field_151055_y)));
            } else if (Math.random() < 0.1) {
                skel.func_70062_b(0, new ItemStack((Item)DarkSteelItems.itemDarkSteelSword));
                skel.func_96120_a(0, 1.0E-5f);
            }
        }
        return entity;
    }

    @Nonnull
    public String getDisplayName() {
        String baseName = null;
        if (this.isVariant && "Skeleton".equals(this.entityId)) {
            baseName = StatCollector.func_74838_a((String)"entity.witherSkeleton.name");
        } else if (this.entityId != null) {
            baseName = EntityUtil.getDisplayNameForEntity((String)this.entityId);
        } else if (this.entityNbt != null) {
            baseName = EntityUtil.getDisplayNameForEntity((String)this.entityNbt.func_74779_i("id"));
        }
        if (baseName == null || baseName.trim().isEmpty()) {
            if (this.customName != null) {
                return this.customName;
            }
            return "???";
        }
        if (this.customName != null) {
            return this.customName + " (" + baseName + ")";
        }
        return baseName;
    }

    public float getHealth() {
        if (this.entityNbt != null && this.entityNbt.func_74764_b("HealF")) {
            return this.entityNbt.func_74760_g("HealF");
        }
        return Float.NaN;
    }

    public float getMaxHealth() {
        NBTTagCompound maxHealthAttrib = this.getAttribute("generic.maxHealth");
        if (maxHealthAttrib != null && maxHealthAttrib.func_74764_b("Base")) {
            return maxHealthAttrib.func_74760_g("Base");
        }
        return Float.NaN;
    }

    @Nullable
    public NBTTagCompound getAttribute(@Nullable String name) {
        NBTBase tag;
        if (name != null && this.entityNbt != null && this.entityNbt.func_74764_b("Attributes") && (tag = this.entityNbt.func_74781_a("Attributes")) instanceof NBTTagList) {
            NBTTagList attributes = (NBTTagList)tag;
            for (int i = 0; i < attributes.func_74745_c(); ++i) {
                NBTTagCompound attrib = attributes.func_150305_b(i);
                if (!attrib.func_74764_b("Name") || !name.equals(attrib.func_74779_i("Name"))) continue;
                return attrib;
            }
        }
        return null;
    }

    @Nullable
    public DyeColor getColor() {
        int colorIdx;
        if (this.entityNbt != null && this.entityNbt.func_74764_b("Color") && (colorIdx = this.entityNbt.func_74762_e("Color")) >= 0 && colorIdx <= 15) {
            return DyeColor.values()[15 - colorIdx];
        }
        return null;
    }

    @Nullable
    public String getFluidName() {
        if (this.entityNbt != null && this.entityNbt.func_74764_b("FluidName")) {
            return this.entityNbt.func_74779_i("FluidName");
        }
        return null;
    }

    public static void addToBlackList(String entityName) {
        blacklist.add(entityName);
    }

    @Nullable
    public String getEntityName() {
        return this.entityId != null ? this.entityId : (this.entityNbt != null ? this.entityNbt.func_74779_i("id") : null);
    }

    public boolean isSameType(Entity entity) {
        return entity != null && EntityList.func_75621_b((Entity)entity) != null && EntityList.func_75621_b((Entity)entity).equals(this.getEntityName()) && (!(entity instanceof EntitySkeleton) || ((EntitySkeleton)entity).func_82202_m() == (this.isVariant ? 1 : 0));
    }

    public String toString() {
        return "CapturedMob [" + (this.entityId != null ? "entityId=" + this.entityId + ", " : "") + (this.customName != null ? "customName=" + this.customName + ", " : "") + "isStub=" + this.isStub + ", isVariant=" + this.isVariant + ", " + (this.entityNbt != null ? "entityNbt=" + this.entityNbt + ", " : "") + "getDisplayName()=" + this.getDisplayName() + ", getHealth()=" + this.getHealth() + ", getMaxHealth()=" + this.getMaxHealth() + ", " + (this.getColor() != null ? "getColor()=" + this.getColor() + ", " : "") + (this.getFluidName() != null ? "getFluidName()=" + this.getFluidName() : "") + "]";
    }
}

