/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.teleport.ITelePad;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.capacitor.CapacitorKeyType;
import crazypants.enderio.capacitor.DefaultCapacitorData;
import crazypants.enderio.capacitor.DefaultCapacitorKey;
import crazypants.enderio.capacitor.ICapacitorData;
import crazypants.enderio.capacitor.ICapacitorKey;
import crazypants.enderio.capacitor.Scaler;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.MachineSound;
import crazypants.enderio.machine.PacketPowerStorage;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.IInternalPowerReceiver;
import crazypants.enderio.rail.TeleporterEIO;
import crazypants.enderio.teleport.TravelController;
import crazypants.enderio.teleport.anchor.TileTravelAnchor;
import crazypants.enderio.teleport.packet.PacketTravelEvent;
import crazypants.enderio.teleport.telepad.BlockTelePad;
import crazypants.enderio.teleport.telepad.PacketTeleport;
import crazypants.enderio.teleport.telepad.PacketUpdateCoords;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Queue;
import net.minecraft.block.Block;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Storable
public class TileTelePad
extends TileTravelAnchor
implements IInternalPowerReceiver,
ITelePad,
IProgressTile {
    private boolean inNetwork;
    private boolean isMaster;
    private ICapacitorData capacitorData = DefaultCapacitorData.BASIC_CAPACITOR;
    private final ICapacitorKey maxEnergyRecieved = new DefaultCapacitorKey(ModObject.blockTelePad, CapacitorKeyType.ENERGY_INTAKE, Scaler.Factory.POWER, 1000);
    private final ICapacitorKey maxEnergyStored = new DefaultCapacitorKey(ModObject.blockTelePad, CapacitorKeyType.ENERGY_BUFFER, Scaler.Factory.POWER, 100000);
    private final ICapacitorKey maxEnergyUsed = new DefaultCapacitorKey(ModObject.blockTelePad, CapacitorKeyType.ENERGY_USE, Scaler.Factory.POWER, 1000);
    @Store
    private int storedEnergyRF;
    private TileTelePad master = null;
    private boolean autoUpdate = false;
    private boolean coordsChanged = false;
    @Store
    private BlockCoord target = new BlockCoord();
    @Store
    private int targetDim = Integer.MIN_VALUE;
    private int lastSyncPowerStored;
    private Queue<Entity> toTeleport = Queues.newArrayDeque();
    private int powerUsed;
    private int maxPower;
    private static final ResourceLocation activeRes = AbstractMachineEntity.getSoundFor("telepad.active");
    @SideOnly(value=Side.CLIENT)
    private MachineSound activeSound;
    @Store
    private boolean redstoneActivePrev;
    public static final String TELEPORTING_KEY = "eio:teleporting";
    public static final String PROGRESS_KEY = "teleportprogress";
    boolean wasBlocked = false;
    public float[] bladeRots = new float[3];
    public float spinSpeed = 0.0f;
    public float speedMult = 2.5f;

    public void doUpdate() {
        boolean powerChanged;
        super.doUpdate();
        if (this.master != null && (this.master.func_145837_r() || this.master.master != this.master)) {
            TileTelePad master1 = this.master.master;
            TileTelePad master0 = this.master;
            this.breakNetwork();
            if (master0 != this) {
                master0.breakNetwork();
            }
            if (master1 != null && master1 != master0 && master1 != this) {
                master1.breakNetwork();
            }
        }
        if (this.autoUpdate) {
            this.updateConnectedState(true);
            this.autoUpdate = false;
        }
        if (!this.isMaster()) {
            return;
        }
        if (this.targetDim == Integer.MIN_VALUE) {
            this.targetDim = this.field_145850_b.field_73011_w.func_177502_q();
        }
        if (this.field_145850_b.field_72995_K) {
            this.updateEntityClient();
            return;
        }
        if (this.active()) {
            if (this.powerUsed >= this.maxPower) {
                this.teleport(this.toTeleport.poll());
                this.powerUsed = 0;
            } else {
                int usable = Math.min(Math.min(this.getUsage(), this.maxPower), this.getEnergyStored());
                this.setEnergyStored(this.getEnergyStored() - usable);
                this.powerUsed += usable;
            }
            if (this.shouldDoWorkThisTick(5)) {
                this.updateQueuedEntities();
            }
        }
        boolean bl = powerChanged = this.lastSyncPowerStored != this.getEnergyStored() && this.shouldDoWorkThisTick(5);
        if (powerChanged) {
            this.lastSyncPowerStored = this.getEnergyStored();
            PacketHandler.sendToAllAround(new PacketPowerStorage(this), (TileEntity)this);
        }
        if (this.coordsChanged && this.inNetwork() && this.master != null && this.isMaster()) {
            this.coordsChanged = false;
            PacketHandler.sendToAllAround((IMessage)new PacketUpdateCoords(this.master, this.master.getX(), this.master.getY(), this.master.getZ(), this.master.getTargetDim()), (TileEntity)this.master);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateEntityClient() {
        this.updateRotations();
        if (this.activeSound != null) {
            this.activeSound.setPitch(MathHelper.func_76131_a((float)(0.5f + this.spinSpeed / 1.5f), (float)0.5f, (float)2.0f));
        }
        if (this.active()) {
            if (this.activeSound == null) {
                BlockPos p = this.func_174877_v();
                this.activeSound = new MachineSound(activeRes, p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), 0.3f, 1.0f);
                this.playSound();
            }
            this.updateQueuedEntities();
        } else if (!this.active() && this.activeSound != null && this.activeSound.func_147655_f() <= 0.5f) {
            this.activeSound.endPlaying();
            this.activeSound = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playSound() {
        FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.activeSound);
    }

    private void updateQueuedEntities() {
        if (this.field_145850_b.field_72995_K && this.active()) {
            this.getCurrentTarget().getEntityData().func_74776_a(PROGRESS_KEY, this.getProgress());
        }
        ArrayList toRemove = Lists.newArrayList();
        for (Entity e : this.toTeleport) {
            if (this.isEntityInRange(e) && !e.field_70128_L) continue;
            toRemove.add(e);
        }
        for (Entity e : toRemove) {
            this.dequeueTeleport(e, true);
        }
    }

    public void updateConnectedState(boolean fromBlock) {
        if (!this.func_145830_o()) {
            return;
        }
        EnumSet<EnumFacing> connections = EnumSet.noneOf(EnumFacing.class);
        for (BlockCoord bc : this.getSurroundingCoords()) {
            if (this.field_145850_b.func_175667_e(bc.getBlockPos())) {
                TileEntity te = bc.getTileEntity((IBlockAccess)this.field_145850_b);
                EnumFacing con = Util.getDirFromOffset((int)(bc.x - this.func_174877_v().func_177958_n()), (int)0, (int)(bc.z - this.func_174877_v().func_177952_p()));
                if (te instanceof TileTelePad && te.func_145830_o() && this.isPainted() == ((TileTelePad)te).isPainted()) {
                    if (fromBlock) {
                        ((TileTelePad)te).updateConnectedState(false);
                        if (((TileTelePad)te).inNetwork() && !this.inNetwork) {
                            return;
                        }
                    }
                    if (con != null && !((TileTelePad)te).inNetwork()) {
                        connections.add(con);
                    }
                } else {
                    connections.remove(con);
                    if (this.master == this) {
                        this.breakNetwork();
                        this.updateBlock();
                    } else if (con != null && this.inNetwork() && this.master != null && fromBlock) {
                        this.master.updateConnectedState(false);
                    }
                }
            }
            if (connections.size() != 4 || this.inNetwork()) continue;
            this.inNetwork = this.formNetwork();
            this.updateBlock();
            if (!this.inNetwork() || !this.target.equals((Object)new BlockCoord())) continue;
            this.target = new BlockCoord((TileEntity)this);
        }
    }

    public void updateRedstoneState() {
        if (!this.inNetwork()) {
            return;
        }
        boolean redstone = this.isPoweredRedstone();
        if (!this.master.redstoneActivePrev && redstone) {
            this.teleportAll();
        }
        this.master.redstoneActivePrev = redstone;
    }

    public boolean isPainted() {
        return this.sourceBlock != null;
    }

    private boolean formNetwork() {
        ArrayList temp = Lists.newArrayList();
        for (BlockCoord c : this.getSurroundingCoords()) {
            TileEntity te = c.getTileEntity((IBlockAccess)this.field_145850_b);
            if (!(te instanceof TileTelePad) || ((TileTelePad)te).inNetwork() || this.isPainted() != ((TileTelePad)te).isPainted()) {
                return false;
            }
            temp.add((TileTelePad)te);
        }
        for (TileTelePad te : temp) {
            te.master = this;
            te.inNetwork = true;
            te.updateBlock();
            te.updateNeighborTEs();
        }
        this.master = this;
        this.isMaster = true;
        return true;
    }

    private void breakNetwork() {
        this.master = null;
        this.inNetwork = false;
        this.isMaster = false;
        for (BlockCoord c : this.getSurroundingCoords()) {
            TileEntity te = c.getTileEntity((IBlockAccess)this.field_145850_b);
            if (!(te instanceof TileTelePad)) continue;
            TileTelePad telepad = (TileTelePad)te;
            telepad.master = null;
            telepad.inNetwork = false;
            telepad.updateBlock();
            telepad.updateNeighborTEs();
        }
    }

    private List<BlockCoord> getSurroundingCoords() {
        ArrayList ret = Lists.newArrayList();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0) continue;
                ret.add(new BlockCoord(this.func_174877_v().func_177958_n() + x, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + z));
            }
        }
        return ret;
    }

    private void updateNeighborTEs() {
        BlockCoord bc = new BlockCoord((TileEntity)this);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockCoord neighbor = bc.getLocation(dir);
            Block block = neighbor.getBlock((IBlockAccess)this.field_145850_b);
            if (block instanceof BlockTelePad) continue;
            block.onNeighborChange((IBlockAccess)this.field_145850_b, neighbor.getBlockPos(), this.func_174877_v());
        }
    }

    @Override
    protected void readCustomNBT(NBTTagCompound root) {
        super.readCustomNBT(root);
        this.autoUpdate = true;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.stopPlayingSound();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.field_145850_b.field_72995_K) {
            this.stopPlayingSound();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void stopPlayingSound() {
        if (this.activeSound != null) {
            this.activeSound.endPlaying();
            this.activeSound = null;
        }
    }

    public int getPowerScaled(int scale) {
        return (int)((float)this.getEnergyStored() / (float)this.getMaxEnergyStored() * (float)scale);
    }

    private int calculateTeleportPower() {
        if (this.field_145850_b.field_73011_w.func_177502_q() == this.targetDim) {
            int distance = new BlockCoord((TileEntity)this).getDist(this.target);
            double base = Math.log(0.005 * (double)distance + 1.0);
            this.maxPower = (int)(base * (double)Config.telepadPowerCoefficient);
            if (this.maxPower <= 0) {
                this.maxPower = 1;
            }
        } else {
            this.maxPower = Config.telepadPowerInterdimensional;
        }
        return this.maxPower;
    }

    public boolean active() {
        return !this.toTeleport.isEmpty();
    }

    public Entity getCurrentTarget() {
        return this.toTeleport.peek();
    }

    public AxisAlignedBB getBoundingBox() {
        BlockPos p = this.func_174877_v();
        if (!this.inNetwork()) {
            return new AxisAlignedBB(p, p.func_177972_a(EnumFacing.UP).func_177972_a(EnumFacing.SOUTH).func_177972_a(EnumFacing.EAST));
        }
        p = this.getMaster().func_174877_v();
        return new AxisAlignedBB((double)(p.func_177958_n() - 1), (double)p.func_177956_o(), (double)(p.func_177952_p() - 1), (double)(p.func_177958_n() + 2), (double)(p.func_177956_o() + 1), (double)(p.func_177952_p() + 2));
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.getBoundingBox();
    }

    public void updateRotations() {
        this.spinSpeed = this.active() ? this.getProgress() * 2.0f : Math.max(0.0f, this.spinSpeed - 0.025f);
        int i = 0;
        while (i < this.bladeRots.length) {
            int n = i;
            this.bladeRots[n] = this.bladeRots[n] + this.spinSpeed * (float)(i * 2 + 20);
            int n2 = i++;
            this.bladeRots[n2] = this.bladeRots[n2] % 360.0f;
        }
    }

    public float getProgress() {
        return (float)this.powerUsed / (float)this.maxPower;
    }

    protected int getProgressUpdateFreq() {
        return 1;
    }

    public void setProgress(float progress) {
        this.powerUsed = progress < 0.0f ? 0 : (int)((float)this.maxPower * progress);
    }

    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public boolean isMaster() {
        return this.isMaster;
    }

    @Override
    public TileTelePad getMaster() {
        return this.master;
    }

    @Override
    public boolean inNetwork() {
        return this.inNetwork;
    }

    @Override
    public int getX() {
        if (this.inNetwork()) {
            return this.master.target.x;
        }
        return this.target.x;
    }

    @Override
    public int getY() {
        if (this.inNetwork()) {
            return this.master.target.y;
        }
        return this.target.y;
    }

    @Override
    public int getZ() {
        if (this.inNetwork()) {
            return this.master.target.z;
        }
        return this.target.z;
    }

    @Override
    public int getTargetDim() {
        if (this.inNetwork()) {
            return this.master.targetDim;
        }
        return this.targetDim;
    }

    @Override
    public ITelePad setX(int x) {
        return Config.telepadLockCoords ? null : this.setX_internal(x);
    }

    @Override
    public ITelePad setY(int y) {
        return Config.telepadLockCoords ? null : this.setY_internal(y);
    }

    @Override
    public ITelePad setZ(int z) {
        return Config.telepadLockCoords ? null : this.setZ_internal(z);
    }

    @Override
    public ITelePad setTargetDim(int dimID) {
        return Config.telepadLockDimension ? null : this.setTargetDim_internal(dimID);
    }

    @Override
    public void setCoords(BlockCoord coords) {
        if (!Config.telepadLockCoords) {
            this.setCoords_internal(coords);
        }
    }

    ITelePad setX_internal(int x) {
        if (this.inNetwork()) {
            this.setCoords(new BlockCoord(x, this.target.y, this.target.z));
            return this.master;
        }
        return null;
    }

    ITelePad setY_internal(int y) {
        if (this.inNetwork()) {
            this.setCoords(new BlockCoord(this.target.x, y, this.target.z));
            return this.master;
        }
        return null;
    }

    ITelePad setZ_internal(int z) {
        if (this.inNetwork()) {
            this.setCoords(new BlockCoord(this.target.x, this.target.y, z));
            return this.master;
        }
        return null;
    }

    ITelePad setTargetDim_internal(int dimID) {
        if (this.inNetwork()) {
            this.master.targetDim = dimID;
            this.coordsChanged = true;
            return this.master;
        }
        return null;
    }

    void setCoords_internal(BlockCoord coords) {
        if (this.inNetwork()) {
            if (this.isMaster()) {
                this.target = coords;
                this.coordsChanged = true;
            } else {
                this.master.setCoords_internal(coords);
            }
        }
    }

    @Override
    public void teleportSpecific(Entity entity) {
        if (!this.inNetwork()) {
            return;
        }
        if (this.isMaster()) {
            if (this.isEntityInRange(entity)) {
                this.enqueueTeleport(entity, true);
            }
        } else {
            this.master.teleportSpecific(entity);
        }
    }

    @Override
    public void teleportAll() {
        if (!this.inNetwork()) {
            return;
        }
        if (this.isMaster()) {
            for (Entity e : this.getEntitiesInRange()) {
                this.enqueueTeleport(e, true);
            }
        } else {
            this.master.teleportAll();
        }
    }

    private List<Entity> getEntitiesInRange() {
        return this.field_145850_b.func_72872_a(Entity.class, this.getRange());
    }

    private boolean isEntityInRange(Entity entity) {
        return this.getRange().func_72318_a(new Vec3(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
    }

    private AxisAlignedBB getRange() {
        BlockPos p = this.func_174877_v();
        return new AxisAlignedBB((double)(p.func_177958_n() - 1), (double)p.func_177956_o(), (double)(p.func_177952_p() - 1), (double)(p.func_177958_n() + 2), (double)(p.func_177956_o() + 3), (double)(p.func_177952_p() + 2));
    }

    void enqueueTeleport(Entity entity, boolean sendUpdate) {
        if (entity == null || this.toTeleport.contains(entity)) {
            return;
        }
        this.calculateTeleportPower();
        entity.getEntityData().func_74757_a(TELEPORTING_KEY, true);
        this.toTeleport.add(entity);
        if (sendUpdate) {
            if (entity.field_70170_p.field_72995_K) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketTeleport(PacketTeleport.Type.BEGIN, this, entity.func_145782_y()));
            } else {
                PacketHandler.INSTANCE.sendToAll((IMessage)new PacketTeleport(PacketTeleport.Type.BEGIN, this, entity.func_145782_y()));
            }
        }
    }

    void dequeueTeleport(Entity entity, boolean sendUpdate) {
        if (entity == null) {
            return;
        }
        this.toTeleport.remove(entity);
        entity.getEntityData().func_74757_a(TELEPORTING_KEY, false);
        if (sendUpdate) {
            if (this.field_145850_b.field_72995_K) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketTeleport(PacketTeleport.Type.END, this, entity.func_145782_y()));
            } else {
                PacketHandler.INSTANCE.sendToAll((IMessage)new PacketTeleport(PacketTeleport.Type.END, this, entity.func_145782_y()));
            }
        }
        if (!this.active()) {
            this.powerUsed = 0;
        }
    }

    private boolean teleport(Entity entity) {
        if (this.maxPower > 0) {
            entity.getEntityData().func_74757_a(TELEPORTING_KEY, false);
            this.wasBlocked = !(!entity.field_70170_p.field_72995_K ? this.serverTeleport(entity) : this.clientTeleport(entity));
            PacketHandler.INSTANCE.sendToAll((IMessage)new PacketTeleport(PacketTeleport.Type.TELEPORT, this, this.wasBlocked));
            return !this.wasBlocked;
        }
        return false;
    }

    private boolean clientTeleport(Entity entity) {
        if (entity.field_70170_p.field_73011_w.func_177502_q() == this.targetDim) {
            return TravelController.instance.doClientTeleport(entity, this.target, TravelSource.TELEPAD, 0, false);
        }
        return true;
    }

    private boolean serverTeleport(Entity entity) {
        this.dequeueTeleport(entity, true);
        int from = entity.field_71093_bK;
        if (from != this.targetDim) {
            MinecraftServer server = MinecraftServer.func_71276_C();
            WorldServer fromDim = server.func_71218_a(from);
            WorldServer toDim = server.func_71218_a(this.targetDim);
            TeleporterEIO teleporter = new TeleporterEIO(toDim);
            server.func_71218_a(entity.field_71093_bK).func_72908_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, TravelSource.TELEPAD.sound, 1.0f, 1.0f);
            if (entity instanceof EntityPlayer) {
                EntityPlayerMP player = (EntityPlayerMP)entity;
                server.func_71203_ab().transferPlayerToDimension(player, this.targetDim, (Teleporter)teleporter);
                if (from == 1 && entity.func_70089_S()) {
                    toDim.func_72838_d(entity);
                    toDim.func_72866_a(entity, false);
                }
            } else {
                NBTTagCompound tagCompound = new NBTTagCompound();
                float rotationYaw = entity.field_70177_z;
                float rotationPitch = entity.field_70125_A;
                entity.func_70109_d(tagCompound);
                Class<?> entityClass = entity.getClass();
                fromDim.func_72900_e(entity);
                try {
                    Entity newEntity = (Entity)entityClass.getConstructor(World.class).newInstance(toDim);
                    newEntity.func_70020_e(tagCompound);
                    newEntity.func_70012_b((double)this.target.x, (double)this.target.y, (double)this.target.z, rotationYaw, rotationPitch);
                    newEntity.field_98038_p = true;
                    toDim.func_72838_d(newEntity);
                    newEntity.field_98038_p = false;
                }
                catch (Exception e) {
                    Throwables.propagate((Throwable)e);
                }
            }
        }
        return PacketTravelEvent.doServerTeleport(entity, this.target.x, this.target.y, this.target.z, 0, false, TravelSource.TELEPAD);
    }

    @Override
    public boolean canSeeBlock(EntityPlayer playerName) {
        return this.isMaster() && this.inNetwork();
    }

    @Override
    public int getMaxEnergyRecieved(EnumFacing dir) {
        return this.inNetwork() && this.master != null ? (this.master == this ? this.maxEnergyRecieved.get(this.capacitorData) : this.master.getMaxEnergyRecieved(dir)) : 0;
    }

    @Override
    public int getMaxEnergyStored() {
        return this.inNetwork() && this.master != null ? (this.master == this ? this.maxEnergyStored.get(this.capacitorData) : this.master.getMaxEnergyStored()) : 0;
    }

    @Override
    public boolean displayPower() {
        return this.inNetwork() && this.master != null;
    }

    @Override
    public int getEnergyStored() {
        return this.inNetwork() && this.master != null ? (this.master == this ? this.storedEnergyRF : this.master.getEnergyStored()) : 0;
    }

    @Override
    public void setEnergyStored(int storedEnergy) {
        if (this.inNetwork() && this.master != null) {
            if (this.master == this) {
                this.storedEnergyRF = Math.min(this.getMaxEnergyStored(), storedEnergy);
            } else {
                this.master.setEnergyStored(storedEnergy);
            }
        }
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return this.inNetwork() && this.master != null;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (!this.inNetwork()) {
            return 0;
        }
        int max = Math.max(0, Math.min(Math.min(this.getMaxEnergyRecieved(from), maxReceive), this.getMaxEnergyStored() - this.getEnergyStored()));
        if (!simulate) {
            this.setEnergyStored(this.getEnergyStored() + max);
        }
        return max;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.getMaxEnergyStored();
    }

    public int getUsage() {
        return this.maxEnergyUsed.get(this.capacitorData);
    }
}

