/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.teleport.ITravelAccessable;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.render.EnumRenderMode;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.teleport.ContainerTravelAccessable;
import crazypants.enderio.teleport.ContainerTravelAuth;
import crazypants.enderio.teleport.GuiTravelAuth;
import crazypants.enderio.teleport.anchor.BlockTravelAnchor;
import crazypants.enderio.teleport.telepad.ContainerTelePad;
import crazypants.enderio.teleport.telepad.GuiAugmentedTravelAccessible;
import crazypants.enderio.teleport.telepad.GuiTelePad;
import crazypants.enderio.teleport.telepad.PacketOpenServerGui;
import crazypants.enderio.teleport.telepad.PacketTeleport;
import crazypants.enderio.teleport.telepad.PacketUpdateCoords;
import crazypants.enderio.teleport.telepad.TelepadRenderMapper;
import crazypants.enderio.teleport.telepad.TileTelePad;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTelePad
extends BlockTravelAnchor<TileTelePad>
implements IPaintable.ISolidBlockPaintableBlock {
    @SideOnly(value=Side.CLIENT)
    private static IRenderMapper RENDER_MAPPER;

    public static BlockTelePad createTelepad() {
        PacketHandler.INSTANCE.registerMessage(PacketOpenServerGui.class, PacketOpenServerGui.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketUpdateCoords.class, PacketUpdateCoords.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketUpdateCoords.class, PacketUpdateCoords.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketTeleport.class, PacketTeleport.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketTeleport.class, PacketTeleport.class, PacketHandler.nextID(), Side.CLIENT);
        BlockTelePad ret = new BlockTelePad();
        ret.init();
        return ret;
    }

    protected BlockTelePad() {
        super(ModObject.blockTelePad.getUnlocalisedName(), TileTelePad.class);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.AUTO)));
        this.func_149713_g(255);
        this.field_149783_u = true;
    }

    @Override
    protected void registerGuiHandlers() {
        EnderIO.guiHandler.registerGuiHandler(102, this);
        EnderIO.guiHandler.registerGuiHandler(103, this);
    }

    @Override
    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{EnumRenderMode.RENDER});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.func_176223_P();
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileTelePad tileEntity) {
        blockStateWrapper.addCacheKey(tileEntity.inNetwork()).addCacheKey(tileEntity.isMaster());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(EnumWorldBlockLayer layer) {
        return true;
    }

    public boolean func_149686_d() {
        return false;
    }

    public AxisAlignedBB func_180646_a(World world, BlockPos pos) {
        AxisAlignedBB bb = super.func_180646_a(world, pos);
        TileTelePad te = (TileTelePad)world.func_175625_s(pos);
        if (!te.inNetwork()) {
            return bb;
        }
        return te.getBoundingBox();
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block changedTo) {
        super.func_176204_a(world, pos, state, changedTo);
        ((TileTelePad)this.getTileEntity((IBlockAccess)world, pos)).updateRedstoneState();
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, null, null);
        ((TileTelePad)world.func_175625_s(pos)).updateConnectedState(true);
    }

    @Override
    protected boolean openGui(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileTelePad) {
            TileTelePad tp = (TileTelePad)te;
            if (tp.inNetwork()) {
                if (!tp.isMaster()) {
                    TileTelePad master = tp.getMaster();
                    return this.openGui(world, master.func_174877_v(), entityPlayer, side);
                }
            } else {
                return false;
            }
            if (tp.canBlockBeAccessed(entityPlayer)) {
                entityPlayer.openGui((Object)EnderIO.instance, 102, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else {
                BlockTelePad.sendPrivateChatMessage(entityPlayer, tp.getOwner());
            }
        }
        return true;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        ((TileTelePad)world.func_175625_s(pos)).updateConnectedState(true);
    }

    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof TileTelePad) {
            switch (ID) {
                case 102: {
                    return new ContainerTelePad(player.field_71071_by);
                }
                case 103: {
                    return new ContainerTravelAccessable(player.field_71071_by, (TileTelePad)te, world);
                }
            }
            return new ContainerTravelAuth(player.field_71071_by);
        }
        return null;
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof TileTelePad) {
            switch (ID) {
                case 102: {
                    return new GuiTelePad(player.field_71071_by, (TileTelePad)te, world);
                }
                case 103: {
                    return new GuiAugmentedTravelAccessible(player.field_71071_by, (TileTelePad)te, world);
                }
            }
            return new GuiTravelAuth(player, (ITravelAccessable)te, world);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return TelepadRenderMapper.instance;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return TelepadRenderMapper.instance;
    }
}

