/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.render.pipeline;

import crazypants.enderio.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.render.pipeline.CollectedQuadBakedBlockModel;
import crazypants.enderio.render.pipeline.EnderItemOverrideList;
import crazypants.util.Profiler;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.client.model.ISmartItemModel;
import org.apache.commons.lang3.tuple.Pair;

public class RelayingBakedModel
implements ISmartBlockModel,
ISmartItemModel,
IPerspectiveAwareModel {
    private IBakedModel defaults;

    private IBakedModel getDefaults() {
        if (this.defaults == null) {
            try {
                this.defaults = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.defaults;
    }

    public RelayingBakedModel(IBakedModel defaults) {
        this.defaults = defaults;
    }

    public List<BakedQuad> func_177551_a(EnumFacing p_177551_1_) {
        return this.getDefaults().func_177551_a(p_177551_1_);
    }

    public List<BakedQuad> func_177550_a() {
        return this.getDefaults().func_177550_a();
    }

    public boolean func_177555_b() {
        return this.getDefaults().func_177555_b();
    }

    public boolean func_177556_c() {
        return this.getDefaults().func_177556_c();
    }

    public boolean func_177553_d() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.getDefaults().func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public IBakedModel handleBlockState(IBlockState stateIn) {
        long start = Profiler.client.start();
        if (stateIn instanceof BlockStateWrapperBase) {
            BlockStateWrapperBase state = (BlockStateWrapperBase)stateIn;
            IBakedModel model = state.getModel();
            if (model instanceof CollectedQuadBakedBlockModel) {
                ((CollectedQuadBakedBlockModel)model).setParticleTexture(this.func_177554_e());
            }
            if (model != null) {
                Profiler.client.stop(start, state.func_177230_c().func_149732_F() + " (relayed)");
                return model;
            }
        }
        return this;
    }

    public IBakedModel handleItemState(ItemStack stack) {
        return EnderItemOverrideList.handleItemState(this.getDefaults(), stack, null, null);
    }

    public VertexFormat getFormat() {
        return Attributes.DEFAULT_BAKED_FORMAT;
    }

    public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        if (this.getDefaults() instanceof IPerspectiveAwareModel) {
            Pair perspective = ((IPerspectiveAwareModel)this.getDefaults()).handlePerspective(cameraTransformType);
            return Pair.of((Object)this, (Object)perspective.getRight());
        }
        return Pair.of((Object)this, null);
    }
}

