/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.render.pipeline;

import crazypants.enderio.Log;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.render.PaintedBlockAccessWrapper;
import crazypants.enderio.render.pipeline.QuadCollector;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.WeightedBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ISmartBlockModel;

public class PaintWrangler {
    private static final ConcurrentHashMap<Block, Memory> cache = new ConcurrentHashMap();

    public static boolean wrangleBakedModel(IBlockAccess blockAccess, BlockPos pos, IBlockState rawPaintSource, IBlockState paint, QuadCollector quads) {
        List<String> errors;
        Block block = paint.func_177230_c();
        Memory memory = cache.get(block);
        if (memory == null) {
            memory = new Memory();
            cache.put(block, memory);
        }
        if (!memory.doPaint) {
            return false;
        }
        IBakedModel paintModel = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(rawPaintSource);
        if (Minecraft.func_71410_x().field_71474_y.field_178880_u && paintModel instanceof WeightedBakedModel) {
            paintModel = ((WeightedBakedModel)paintModel).func_177564_a(MathHelper.func_180186_a((Vec3i)pos));
        }
        if (memory.dohandleBlockState && paintModel instanceof ISmartBlockModel) {
            try {
                paintModel = ((ISmartBlockModel)paintModel).handleBlockState(paint);
            }
            catch (Throwable t) {
                Log.error("Failed to invoke block " + paint.func_177230_c() + "'s ISmartBlockModel for painting. Error: " + t);
                memory.dohandleBlockState = false;
            }
        }
        if ((errors = quads.addUnfriendlybakedModel(MinecraftForgeClient.getRenderLayer(), paintModel, paint, MathHelper.func_180186_a((Vec3i)pos))) != null) {
            memory.doPaint = false;
            Log.error("Failed to use block " + paint.func_177230_c() + " as paint. Error(s) while rendering: " + errors);
            return false;
        }
        return true;
    }

    public static IBlockState getDynamicBlockState(IBlockAccess blockAccess, BlockPos pos, IBlockState paint) {
        if (paint == null) {
            return null;
        }
        Block block = paint.func_177230_c();
        Memory memory = cache.get(block);
        if (memory == null) {
            memory = new Memory();
            cache.put(block, memory);
        }
        if (memory.doPaint) {
            if (memory.doActualStateWithTe) {
                try {
                    paint = block.func_176221_a(paint, (IBlockAccess)new PaintedBlockAccessWrapper(blockAccess, true), pos);
                }
                catch (Throwable t) {
                    memory.doActualStateWithTe = false;
                    memory.doActualStateWithOutTe = true;
                }
            }
            if (memory.doActualStateWithOutTe) {
                try {
                    paint = block.func_176221_a(paint, (IBlockAccess)new PaintedBlockAccessWrapper(blockAccess, false), pos);
                }
                catch (Throwable t) {
                    memory.doActualStateWithOutTe = false;
                }
            }
            if (memory.doExtendedStateWithTe) {
                try {
                    paint = block.getExtendedState(paint, (IBlockAccess)new PaintedBlockAccessWrapper(blockAccess, true), pos);
                }
                catch (Throwable t) {
                    memory.doExtendedStateWithTe = false;
                    memory.doExtendedStateWithOutTe = true;
                }
            }
            if (memory.doExtendedStateWithOutTe) {
                try {
                    paint = block.getExtendedState(paint, (IBlockAccess)new PaintedBlockAccessWrapper(blockAccess, false), pos);
                }
                catch (Throwable t) {
                    memory.doExtendedStateWithOutTe = false;
                }
            }
        }
        return paint;
    }

    public static IBakedModel handlePaint(ItemStack stack, IPaintable.IBlockPaintableBlock block) {
        IBlockState paintSource = block.getPaintSource((Block)block, stack);
        if (paintSource != null) {
            int damage = paintSource.func_177230_c().func_180651_a(paintSource);
            ItemStack paint = new ItemStack(paintSource.func_177230_c(), 1, damage);
            return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(paint);
        }
        return null;
    }

    private static class Memory {
        boolean doActualStateWithTe = true;
        boolean doActualStateWithOutTe = false;
        boolean doExtendedStateWithTe = true;
        boolean doExtendedStateWithOutTe = false;
        boolean dohandleBlockState = true;
        boolean doPaint = true;

        private Memory() {
        }

        public String toString() {
            return "Memory [doActualStateWithTe=" + this.doActualStateWithTe + ", doActualStateWithOutTe=" + this.doActualStateWithOutTe + ", doExtendedStateWithTe=" + this.doExtendedStateWithTe + ", doExtendedStateWithOutTe=" + this.doExtendedStateWithOutTe + ", dohandleBlockState=" + this.dohandleBlockState + "]";
        }
    }
}

