/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material;

import com.enderio.core.common.util.OreDictionaryHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public enum PowderIngot {
    POWDER_COAL("powderCoal", null, "dustCoal"),
    POWDER_IRON("powderIron", null, "dustIron"),
    POWDER_GOLD("powderGold", null, "dustGold"),
    POWDER_COPPER("powderCopper", "ingotCopper", "dustCopper"),
    POWDER_TIN("powderTin", "ingotTin", "dustTin"),
    POWDER_ENDER("powderEnder", "dustEnderPearl", "dustEnderPearl", true),
    INGOT_ENDERIUM_BASE("ingotEnderiumBase", "ingotEnderium", "ingotEnderiumBase"),
    POWDER_OBSIDIAN("powderObsidian", null, "dustObsidian"),
    FLOUR("dustWheat", null);

    public final String baseName;
    public final String unlocalisedName;
    public final String oreDictName;
    public final String iconKey;
    public final String oreDictDependancy;
    public final boolean reverseDependency;
    public boolean ignoreRuntimeDependencyCheck = false;

    public static List<ResourceLocation> resources() {
        ArrayList<ResourceLocation> res = new ArrayList<ResourceLocation>(PowderIngot.values().length);
        for (PowderIngot c : PowderIngot.values()) {
            res.add(new ResourceLocation(c.iconKey));
        }
        return res;
    }

    private PowderIngot(String baseName, String oreDictDependancy, String oreDictName, boolean reverseDependency) {
        this.baseName = baseName;
        this.unlocalisedName = "enderio." + baseName;
        this.iconKey = "enderio:" + baseName;
        this.oreDictName = oreDictName;
        this.oreDictDependancy = oreDictDependancy;
        this.reverseDependency = reverseDependency;
    }

    private PowderIngot(String unlocalisedName, String oreDictDependancy, boolean reverseDependency) {
        this(unlocalisedName, oreDictDependancy, unlocalisedName, reverseDependency);
    }

    private PowderIngot(String unlocalisedName, String oreDictDependancy, String oreDictName) {
        this(unlocalisedName, oreDictDependancy, oreDictName, false);
    }

    private PowderIngot(String unlocalisedName, String oreDictDependancy) {
        this(unlocalisedName, oreDictDependancy, unlocalisedName, false);
    }

    public boolean isDependancyMet() {
        if (this.oreDictDependancy == null || this.ignoreRuntimeDependencyCheck) {
            return true;
        }
        return OreDictionaryHelper.isRegistered((String)this.oreDictDependancy) == !this.reverseDependency;
    }

    public boolean hasDependancy() {
        return this.oreDictDependancy != null;
    }

    public void setRegistered() {
        this.ignoreRuntimeDependencyCheck = true;
    }
}

