/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.wireless;

import crazypants.enderio.machine.wireless.BlockWirelessCharger;
import crazypants.enderio.machine.wireless.TileWirelessCharger;
import crazypants.enderio.render.EnumRenderMode;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.ICacheKey;
import crazypants.enderio.render.IOMode;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.pipeline.ItemQuadCollector;
import crazypants.enderio.render.pipeline.QuadCollector;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class WirelessRenderMapper
implements IRenderMapper.IBlockRenderMapper,
IRenderMapper.IItemRenderMapper.IItemStateMapper {
    public static final WirelessRenderMapper instance = new WirelessRenderMapper();

    private WirelessRenderMapper() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBlockState> mapBlockRender(IBlockStateWrapper state, IBlockAccess world, BlockPos pos, EnumWorldBlockLayer blockLayer, QuadCollector quadCollector) {
        TileEntity tileEntity = state.getTileEntity();
        Block block = state.func_177230_c();
        if (tileEntity instanceof TileWirelessCharger && block instanceof BlockWirelessCharger) {
            return this.render(state.getState(), world, pos, blockLayer, (TileWirelessCharger)tileEntity, (BlockWirelessCharger)block);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    protected List<IBlockState> render(IBlockState state, IBlockAccess world, BlockPos pos, EnumWorldBlockLayer blockLayer, TileWirelessCharger tileEntity, BlockWirelessCharger block) {
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        boolean active = tileEntity.isActive();
        if (active) {
            states.add(state.func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.FRONT_ON)));
        } else {
            states.add(state.func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.FRONT)));
        }
        return states;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<Pair<IBlockState, ItemStack>> mapItemRender(Block block, ItemStack stack, ItemQuadCollector itemQuadCollector) {
        ArrayList<Pair<IBlockState, ItemStack>> states = new ArrayList<Pair<IBlockState, ItemStack>>();
        states.add(Pair.of((Object)block.func_176203_a(stack.func_77960_j()).func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.FRONT_ON)), (Object)stack));
        return states;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumMap<EnumFacing, IOMode.EnumIOMode> mapOverlayLayer(IBlockStateWrapper state, IBlockAccess world, BlockPos pos, boolean isPainted) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ICacheKey getCacheKey(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull ICacheKey cacheKey) {
        return cacheKey;
    }
}

