/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.wireless;

import cofh.api.energy.IEnergyContainerItem;
import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.machine.wireless.IWirelessCharger;
import crazypants.enderio.machine.wireless.PacketStoredEnergy;
import crazypants.enderio.machine.wireless.WirelessChargerController;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.YetaUtil;
import crazypants.enderio.power.IInternalPowerReceiver;
import crazypants.enderio.power.PowerHandlerUtil;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

@Storable
public class TileWirelessCharger
extends TileEntityEio
implements IInternalPowerReceiver,
IWirelessCharger,
IPaintable.IPaintableTileEntity {
    public static final int MAX_ENERGY_STORED = 200000;
    public static final int MAX_ENERGY_IN = 10000;
    public static final int MAX_ENERGY_OUT = 10000;
    @Store
    int storedEnergyRF;
    private double lastPowerUpdate = -1.0;
    private boolean registered = false;
    @Store(value={Store.StoreFor.CLIENT, Store.StoreFor.SAVE})
    protected IBlockState sourceBlock;

    public void func_145843_s() {
        super.func_145843_s();
        WirelessChargerController.instance.deregisterCharger(this);
        this.registered = false;
    }

    public void doUpdate() {
        if (this.field_145850_b.field_72995_K) {
            YetaUtil.refresh((TileEntity)this);
            return;
        }
        if (!this.registered) {
            WirelessChargerController.instance.registerCharger(this);
            this.registered = true;
        }
        if (this.lastPowerUpdate == -1.0 || this.lastPowerUpdate == 0.0 && this.storedEnergyRF > 0 || this.lastPowerUpdate > 0.0 && this.storedEnergyRF == 0 || this.lastPowerUpdate != (double)this.storedEnergyRF && this.shouldDoWorkThisTick(20)) {
            this.lastPowerUpdate = this.storedEnergyRF;
            PacketHandler.sendToAllAround(new PacketStoredEnergy(this), (TileEntity)this);
        }
    }

    @Override
    public boolean chargeItems(ItemStack[] items) {
        boolean chargedItem = false;
        int available = Math.min(10000, this.storedEnergyRF);
        int end = items.length;
        for (int i = 0; i < end && available > 0; ++i) {
            int used;
            ItemStack item = items[i];
            if (item == null || !(item.func_77973_b() instanceof IEnergyContainerItem) || item.field_77994_a != 1) continue;
            IEnergyContainerItem chargable = (IEnergyContainerItem)item.func_77973_b();
            int max = chargable.getMaxEnergyStored(item);
            int cur = chargable.getEnergyStored(item);
            int canUse = Math.min(available, max - cur);
            if (cur >= max || (used = chargable.receiveEnergy(item, canUse, false)) <= 0) continue;
            this.storedEnergyRF -= used;
            chargedItem = true;
            available -= used;
        }
        return chargedItem;
    }

    @Override
    public int getMaxEnergyRecieved(EnumFacing dir) {
        return 10000;
    }

    @Override
    public int getEnergyStored() {
        return this.storedEnergyRF;
    }

    @Override
    public int getMaxEnergyStored() {
        return 200000;
    }

    @Override
    public void setEnergyStored(int stored) {
        this.storedEnergyRF = stored;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return PowerHandlerUtil.recieveInternal(this, maxReceive, from, simulate);
    }

    @Override
    public int takeEnergy(int max) {
        if (this.isActive()) {
            int prev = this.storedEnergyRF;
            this.storedEnergyRF = Math.max(0, this.storedEnergyRF - max);
            return prev - this.storedEnergyRF;
        }
        return 0;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storedEnergyRF;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return 200000;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public World getWorldObj() {
        return this.func_145831_w();
    }

    @Override
    public boolean displayPower() {
        return true;
    }

    @Override
    public boolean isActive() {
        return this.getEnergyStored() > 0 && !this.isPoweredRedstone();
    }

    @Override
    public BlockCoord getLocation() {
        return new BlockCoord(this.field_174879_c);
    }

    @Override
    protected void onAfterDataPacket() {
        this.updateBlock();
    }

    @Override
    public IBlockState getPaintSource() {
        return this.sourceBlock;
    }

    @Override
    public void setPaintSource(IBlockState sourceBlock) {
        this.sourceBlock = sourceBlock;
        this.func_70296_d();
        this.updateBlock();
    }
}

