/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver;

import com.enderio.core.common.util.Util;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.RenderMappers;
import crazypants.enderio.machine.transceiver.Channel;
import crazypants.enderio.machine.transceiver.ChannelType;
import crazypants.enderio.machine.transceiver.ConnectionHandler;
import crazypants.enderio.machine.transceiver.PacketAddRemoveChannel;
import crazypants.enderio.machine.transceiver.PacketChannelList;
import crazypants.enderio.machine.transceiver.PacketItemFilter;
import crazypants.enderio.machine.transceiver.PacketSendRecieveChannel;
import crazypants.enderio.machine.transceiver.PacketSendRecieveChannelList;
import crazypants.enderio.machine.transceiver.TileTransceiver;
import crazypants.enderio.machine.transceiver.gui.ContainerTransceiver;
import crazypants.enderio.machine.transceiver.gui.GuiTransceiver;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.IOMode;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.TextureRegistry;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTransceiver
extends AbstractMachineBlock<TileTransceiver>
implements IPaintable.INonSolidBlockPaintableBlock,
IPaintable.IWrenchHideablePaint {
    private TextureRegistry.TextureSupplier portalIcon = TextureRegistry.registerTexture("blocks/ender_still");

    public static BlockTransceiver create() {
        PacketHandler.INSTANCE.registerMessage(PacketSendRecieveChannel.class, PacketSendRecieveChannel.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketAddRemoveChannel.class, PacketAddRemoveChannel.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketAddRemoveChannel.class, PacketAddRemoveChannel.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketChannelList.class, PacketChannelList.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketSendRecieveChannelList.class, PacketSendRecieveChannelList.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketItemFilter.class, PacketItemFilter.class, PacketHandler.nextID(), Side.SERVER);
        ConnectionHandler ch = new ConnectionHandler();
        MinecraftForge.EVENT_BUS.register((Object)ch);
        BlockTransceiver res = new BlockTransceiver();
        res.init();
        return res;
    }

    private BlockTransceiver() {
        super(ModObject.blockTransceiver, TileTransceiver.class);
        if (!Config.transceiverEnabled) {
            this.func_149647_a(null);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getPortalIcon() {
        return this.portalIcon.get(TextureAtlasSprite.class);
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof TileTransceiver) {
            ((TileTransceiver)te).getRailController().dropNonSpawnedCarts();
        }
        return super.removedByPlayer(world, pos, player, willHarvest);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof TileTransceiver) {
            return new ContainerTransceiver(player.field_71071_by, (TileTransceiver)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        return new GuiTransceiver(player.field_71071_by, (TileTransceiver)te);
    }

    @Override
    protected int getGuiId() {
        return 97;
    }

    public boolean func_149662_c() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World world, BlockPos pos, IBlockState state, Random rand) {
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof TileTransceiver && player.func_70093_af()) {
            TileTransceiver trans = (TileTransceiver)te;
            for (ChannelType type : ChannelType.VALUES) {
                Set<Channel> recieving = trans.getRecieveChannels(type);
                Set<Channel> sending = trans.getSendChannels(type);
                String recieve = "[" + this.buildString(recieving) + "]";
                String send = "[" + this.buildString(sending) + "]";
                if (this.isEmpty(recieve) && this.isEmpty(send)) continue;
                tooltip.add(EnumChatFormatting.WHITE + EnderIO.lang.localize("trans." + type.name().toLowerCase(Locale.US)));
                if (!this.isEmpty(recieve)) {
                    tooltip.add(String.format("%s%s " + Util.TAB + ": %s%s", Util.TAB, EnderIO.lang.localize("trans.receiving"), Util.TAB + Util.ALIGNRIGHT + EnumChatFormatting.WHITE, recieve));
                }
                if (this.isEmpty(send)) continue;
                tooltip.add(String.format("%s%s " + Util.TAB + ": %s%s", Util.TAB, EnderIO.lang.localize("trans.sending"), Util.TAB + Util.ALIGNRIGHT + EnumChatFormatting.WHITE, send));
            }
        }
    }

    private boolean isEmpty(String str) {
        return "[]".equals(str);
    }

    private String buildString(Set<Channel> recieving) {
        StringBuilder sb = new StringBuilder();
        Iterator<Channel> iter = recieving.iterator();
        while (iter.hasNext()) {
            Channel c = iter.next();
            sb.append(c.getName());
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return RenderMappers.FRONT_MAPPER;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return RenderMappers.FRONT_MAPPER;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IOMode.EnumIOMode mapIOMode(IoMode mode, EnumFacing side) {
        switch (mode) {
            case NONE: {
                return IOMode.EnumIOMode.NONE;
            }
            case PULL: {
                return IOMode.EnumIOMode.TRANSCIEVERPULL;
            }
            case PUSH: {
                return IOMode.EnumIOMode.TRANSCIEVERPUSH;
            }
            case PUSH_PULL: {
                return IOMode.EnumIOMode.TRANSCIEVERPUSHPULL;
            }
            case DISABLED: {
                return IOMode.EnumIOMode.TRANSCIEVERDISABLED;
            }
        }
        throw new RuntimeException("Hey, leave our enums alone!");
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileTransceiver tileEntity) {
        blockStateWrapper.addCacheKey(0);
    }
}

