/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.spawner;

import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.PoweredTask;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.spawner.DummyRecipe;
import crazypants.enderio.machine.spawner.PoweredSpawnerConfig;
import crazypants.enderio.paint.IPaintable;
import crazypants.util.CapturedMob;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;

@Storable
public class TilePoweredSpawner
extends AbstractPoweredTaskEntity
implements IPaintable.IPaintableTileEntity {
    @Store(value={Store.StoreFor.CLIENT, Store.StoreFor.SAVE})
    private CapturedMob capturedMob = null;
    @Store
    private boolean isSpawnMode = true;
    private int remainingSpawnTries;

    public TilePoweredSpawner() {
        super(new SlotDefinition(1, 1, 1), CapacitorKey.SPAWNER_POWER_INTAKE, CapacitorKey.SPAWNER_POWER_BUFFER, CapacitorKey.SPAWNER_POWER_USE);
    }

    public boolean isSpawnMode() {
        return this.isSpawnMode;
    }

    public void setSpawnMode(boolean isSpawnMode) {
        if (isSpawnMode != this.isSpawnMode) {
            this.currentTask = null;
        }
        this.isSpawnMode = isSpawnMode;
    }

    @Override
    protected void taskComplete() {
        super.taskComplete();
        if (this.hasEntity()) {
            if (this.isSpawnMode) {
                this.remainingSpawnTries = Config.poweredSpawnerSpawnCount + Config.poweredSpawnerMaxSpawnTries;
                for (int i = 0; i < Config.poweredSpawnerSpawnCount && this.remainingSpawnTries > 0 && this.trySpawnEntity(); ++i) {
                }
            } else {
                if (this.func_70301_a(0) == null || this.func_70301_a(1) != null || !this.hasEntity()) {
                    return;
                }
                ItemStack res = this.capturedMob.toStack(EnderIO.itemSoulVessel, 1, 1);
                this.func_70298_a(0, 1);
                this.func_70299_a(1, res);
            }
        } else {
            this.field_145850_b.func_175655_b(this.func_174877_v(), true);
        }
    }

    @Override
    public int getPowerUsePerTick() {
        return (int)((double)super.getPowerUsePerTick() * PoweredSpawnerConfig.getInstance().getCostMultiplierFor(this.getEntityName()));
    }

    @Override
    public int getMaxEnergyRecieved(EnumFacing dir) {
        return (int)((double)super.getMaxEnergyRecieved(dir) * PoweredSpawnerConfig.getInstance().getCostMultiplierFor(this.getEntityName()));
    }

    @Override
    public String getMachineName() {
        return ModObject.blockPoweredSpawner.getUnlocalisedName();
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        if (itemstack == null || this.isSpawnMode) {
            return false;
        }
        if (this.slotDefinition.isInputSlot(i)) {
            return itemstack.func_77973_b() == EnderIO.itemSoulVessel && !CapturedMob.containsSoul(itemstack);
        }
        return false;
    }

    @Override
    protected IMachineRecipe canStartNextTask(float chance) {
        BlockPos p;
        if (!this.hasEntity()) {
            return null;
        }
        if (this.isSpawnMode ? Config.poweredSpawnerMaxPlayerDistance > 0 && this.field_145850_b.func_72977_a((double)(p = this.func_174877_v()).func_177958_n() + 0.5, (double)p.func_177958_n() + 0.5, (double)p.func_177958_n() + 0.5, (double)Config.poweredSpawnerMaxPlayerDistance) == null : this.func_70301_a(0) == null || this.func_70301_a(1) != null) {
            return null;
        }
        return new DummyRecipe();
    }

    @Override
    protected boolean startNextTask(IMachineRecipe nextRecipe, float chance) {
        return super.startNextTask(nextRecipe, chance);
    }

    @Override
    protected boolean hasInputStacks() {
        return true;
    }

    @Override
    protected boolean canInsertResult(float chance, IMachineRecipe nextRecipe) {
        return true;
    }

    @Override
    public void writeToItemStack(ItemStack stack) {
        super.writeToItemStack(stack);
        if (this.hasEntity() && stack != null) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            this.capturedMob.toNbt(stack.func_77978_p());
        }
    }

    @Override
    protected void updateEntityClient() {
        if (this.isActive()) {
            double x = (float)this.func_174877_v().func_177958_n() + this.field_145850_b.field_73012_v.nextFloat();
            double y = (float)this.func_174877_v().func_177956_o() + this.field_145850_b.field_73012_v.nextFloat();
            double z = (float)this.func_174877_v().func_177952_p() + this.field_145850_b.field_73012_v.nextFloat();
            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }
        super.updateEntityClient();
    }

    @Override
    protected IPoweredTask createTask(IMachineRecipe nextRecipe, float chance) {
        PoweredTask res = new PoweredTask(nextRecipe, chance, this.getRecipeInputs());
        int ticksDelay = this.isSpawnMode ? Config.poweredSpawnerMinDelayTicks + (int)Math.round((double)(Config.poweredSpawnerMaxDelayTicks - Config.poweredSpawnerMinDelayTicks) * Math.random()) : Config.poweredSpawnerMaxDelayTicks - (Config.poweredSpawnerMaxDelayTicks - Config.poweredSpawnerMinDelayTicks) / 2;
        int powerPerTick = this.getPowerUsePerTick();
        res.setRequiredEnergy(powerPerTick * (ticksDelay /= CapacitorKey.SPAWNER_SPEEDUP.get(this.getCapacitorData())));
        return res;
    }

    protected boolean canSpawnEntity(EntityLiving entityliving) {
        boolean spaceClear;
        boolean bl = spaceClear = this.field_145850_b.func_72855_b(entityliving.func_174813_aQ()) && this.field_145850_b.func_72945_a((Entity)entityliving, entityliving.func_174813_aQ()).isEmpty() && (!this.field_145850_b.func_72953_d(entityliving.func_174813_aQ()) || entityliving.isCreatureType(EnumCreatureType.WATER_CREATURE, false));
        if (spaceClear && Config.poweredSpawnerUseVanillaSpawChecks) {
            spaceClear = entityliving.func_70601_bi();
        }
        return spaceClear;
    }

    Entity createEntity(boolean forceAlive) {
        Entity ent = this.capturedMob.getEntity(this.field_145850_b, false);
        if (forceAlive && Config.poweredSpawnerMaxPlayerDistance <= 0 && Config.poweredSpawnerDespawnTimeSeconds > 0 && ent instanceof EntityLiving) {
            ent.getEntityData().func_74772_a("spawnedByPoweredSpawner", this.field_145850_b.func_82737_E());
            ((EntityLiving)ent).func_110163_bv();
        }
        return ent;
    }

    protected boolean trySpawnEntity() {
        int nearbyEntities;
        Entity entity = this.createEntity(true);
        if (!(entity instanceof EntityLiving)) {
            return false;
        }
        EntityLiving entityliving = (EntityLiving)entity;
        int spawnRange = Config.poweredSpawnerSpawnRange;
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        if (Config.poweredSpawnerMaxNearbyEntities > 0 && (nearbyEntities = this.field_145850_b.func_72872_a(entity.getClass(), new AxisAlignedBB((double)(xCoord - spawnRange * 2), (double)(yCoord - 4), (double)(zCoord - spawnRange * 2), (double)(xCoord + spawnRange * 2), (double)(yCoord + 4), (double)(zCoord + spawnRange * 2))).size()) >= Config.poweredSpawnerMaxNearbyEntities) {
            return false;
        }
        while (this.remainingSpawnTries-- > 0) {
            double x = (double)xCoord + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * (double)spawnRange;
            double y = yCoord + this.field_145850_b.field_73012_v.nextInt(3) - 1;
            double z = (double)zCoord + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * (double)spawnRange;
            entity.func_70012_b(x, y, z, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (!this.canSpawnEntity(entityliving)) continue;
            entityliving.func_180482_a(this.field_145850_b.func_175649_E(new BlockPos(x, y, z)), null);
            this.field_145850_b.func_72838_d((Entity)entityliving);
            this.field_145850_b.func_175718_b(2004, this.func_174877_v(), 0);
            entityliving.func_70656_aK();
            return true;
        }
        return false;
    }

    public String getEntityName() {
        return this.capturedMob != null ? this.capturedMob.getEntityName() : null;
    }

    public CapturedMob getEntity() {
        return this.capturedMob;
    }

    public boolean hasEntity() {
        return this.capturedMob != null;
    }

    @Override
    public void readFromItemStack(ItemStack stack) {
        super.readFromItemStack(stack);
        this.capturedMob = CapturedMob.create(stack);
    }
}

