/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.reservoir;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.FluidUtil;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.config.Config;
import crazypants.enderio.tool.SmartTank;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.HashSet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@Storable
public class TileReservoir
extends TileEntityEio
implements IFluidHandler,
ITankAccess {
    @Store
    SmartTank tank = new SmartTank(FluidRegistry.WATER, 1000);
    private boolean canRefill = false;
    @Store
    boolean autoEject = false;
    private boolean tankDirty = false;
    private static int IO_MB_TICK = 100;

    private boolean hasEnoughLiquid() {
        HashSet<TileReservoir> seen = new HashSet<TileReservoir>();
        seen.add(this);
        int got = this.tank.getFluidAmount();
        for (EnumFacing neighbor : EnumFacing.field_82609_l) {
            BlockPos pos1 = this.func_174877_v().func_177972_a(neighbor);
            TileEntity tileEntity = this.field_145850_b.func_175625_s(pos1);
            if (!(tileEntity instanceof TileReservoir) || ((TileReservoir)tileEntity).tank == null || seen.contains(tileEntity)) continue;
            seen.add((TileReservoir)tileEntity);
            if ((got += ((TileReservoir)tileEntity).tank.getFluidAmount()) >= 2000) {
                return true;
            }
            for (EnumFacing neighbor2 : EnumFacing.field_82609_l) {
                BlockPos pos2 = pos1.func_177972_a(neighbor2);
                TileEntity tileEntity2 = this.field_145850_b.func_175625_s(pos2);
                if (!(tileEntity2 instanceof TileReservoir) || ((TileReservoir)tileEntity2).tank == null || seen.contains(tileEntity2)) continue;
                seen.add((TileReservoir)tileEntity2);
                if ((got += ((TileReservoir)tileEntity2).tank.getFluidAmount()) < 2000) continue;
                return true;
            }
        }
        return false;
    }

    protected void doPush() {
        if (this.tank.getFluidAmount() > 0) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                BlockPos loc = this.func_174877_v().func_177972_a(dir);
                IFluidHandler target = FluidUtil.getFluidHandler((IBlockAccess)this.field_145850_b, (int)loc.func_177958_n(), (int)loc.func_177956_o(), (int)loc.func_177952_p());
                if (target == null || target instanceof TileReservoir || !target.canFill(dir.func_176734_d(), this.tank.getFluid().getFluid())) continue;
                FluidStack push = this.tank.getFluid().copy();
                push.amount = Math.min(push.amount, IO_MB_TICK);
                int filled = target.fill(dir.func_176734_d(), push, true);
                if (filled <= 0) continue;
                this.tank.drain(filled, true);
                this.tankDirty = true;
                if (this.tank.getFluidAmount() != 0) continue;
                return;
            }
        }
    }

    protected void doLeak() {
        BlockPos down = this.func_174877_v().func_177977_b();
        int max = Math.min(this.tank.getFluidAmount() / 3, IO_MB_TICK);
        if (max <= 0) {
            max = 2;
        }
        this.doLeak(down, max);
        for (EnumFacing dir : EnumFacing.Plane.HORIZONTAL) {
            BlockPos pos1 = down.func_177972_a(dir);
            this.doLeak(pos1, max / 2);
        }
    }

    protected void doLeak(BlockPos pos1, int maxAmount) {
        FluidStack canDrain;
        TileEntity tileEntity = this.field_145850_b.func_175625_s(pos1);
        if (tileEntity instanceof TileReservoir && !((TileReservoir)tileEntity).tank.isFull() && (canDrain = this.tank.drain(maxAmount, false)) != null && canDrain.amount > 0) {
            int fill = ((TileReservoir)tileEntity).tank.fill(canDrain, true);
            this.tank.drain(fill, true);
            this.tankDirty = true;
            ((TileReservoir)tileEntity).tankDirty = true;
        }
    }

    protected void doEqualize() {
        for (EnumFacing dir : EnumFacing.Plane.HORIZONTAL) {
            FluidStack canDrain;
            BlockPos pos1 = this.func_174877_v().func_177972_a(dir);
            TileEntity tileEntity = this.field_145850_b.func_175625_s(pos1);
            if (!(tileEntity instanceof TileReservoir)) continue;
            TileReservoir other = (TileReservoir)tileEntity;
            int toMove = (this.tank.getFluidAmount() - other.tank.getFluidAmount()) / 2;
            if (toMove <= 0 || (canDrain = this.tank.drain(Math.min(toMove, IO_MB_TICK / 4), false)) == null || canDrain.amount <= 0) continue;
            int fill = ((TileReservoir)tileEntity).tank.fill(canDrain, true);
            this.tank.drain(fill, true);
            this.tankDirty = true;
            ((TileReservoir)tileEntity).tankDirty = true;
        }
    }

    public void doUpdate() {
        if (this.field_145850_b.field_72995_K || this.tank == null) {
            return;
        }
        if (this.shouldDoWorkThisTick(10)) {
            this.canRefill = this.tank.isFull() ? this.canRefill || this.hasEnoughLiquid() : this.hasEnoughLiquid();
        } else if (Config.reservoirEnabled && this.shouldDoWorkThisTick(10, -1) && this.canRefill) {
            this.tank.addFluidAmount(500);
            this.tankDirty = true;
        }
        if (this.shouldDoWorkThisTick(15, 1) && this.tank.getFluidAmount() > 0) {
            this.doLeak();
            if (this.tank.getFluidAmount() > 0) {
                this.doEqualize();
            }
        }
        if (this.autoEject && this.canRefill) {
            this.doPush();
        }
        if (this.tankDirty && this.shouldDoWorkThisTick(2)) {
            this.field_145850_b.func_175689_h(this.func_174877_v());
            this.tankDirty = false;
        }
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        int ret = this.tank.fill(resource, doFill);
        this.tankDirty |= doFill && ret != 0;
        return ret;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (this.canRefill) {
            FluidStack ret = this.tank.drain(maxDrain, doDrain);
            this.tankDirty |= doDrain && ret != null && ret.amount != 0;
            return ret;
        }
        return null;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return fluid == FluidRegistry.WATER;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return fluid == FluidRegistry.WATER;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public void setAutoEject(boolean autoEject) {
        this.autoEject = autoEject;
    }

    public boolean isAutoEject() {
        return this.autoEject;
    }

    float getFilledRatio() {
        return this.tank.getFilledRatio();
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        if (forFluidType != null && forFluidType.getFluid() == FluidRegistry.WATER) {
            return this.tank;
        }
        return null;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.tank};
    }

    public void setTanksDirty() {
        this.tankDirty = true;
    }
}

