/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter.blocks;

import crazypants.enderio.ModObject;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.painter.blocks.BlockItemPaintedBlock;
import crazypants.enderio.machine.painter.blocks.TileEntityPaintedBlock;
import crazypants.enderio.machine.painter.recipe.BasicPainterTemplate;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.enderio.paint.render.PaintRegistry;
import crazypants.enderio.render.EnumRenderPart;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.ICacheKey;
import crazypants.enderio.render.IOMode;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.ISmartRenderAwareBlock;
import crazypants.enderio.render.SmartModelAttacher;
import crazypants.enderio.render.dummy.BlockMachineBase;
import crazypants.enderio.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.render.pipeline.QuadCollector;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPaintedStairs
extends BlockStairs
implements ITileEntityProvider,
IPaintable.ITexturePaintableBlock,
ISmartRenderAwareBlock,
IRenderMapper.IBlockRenderMapper.IRenderLayerAware,
IRenderMapper.IItemRenderMapper.IItemModelMapper {
    private final String name;

    public static BlockPaintedStairs create() {
        BlockPaintedStairs woodStairs = new BlockPaintedStairs(Blocks.field_150476_ad, ModObject.blockPaintedStair.getUnlocalisedName());
        woodStairs.init();
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.getUnlocalisedName(), new BasicPainterTemplate<BlockPaintedStairs>(woodStairs, Blocks.field_150476_ad, Blocks.field_150400_ck, Blocks.field_150485_bF, Blocks.field_150487_bG, Blocks.field_150481_bH, Blocks.field_150401_cl));
        BlockPaintedStairs stoneStairs = new BlockPaintedStairs(Blocks.field_150446_ar, ModObject.blockPaintedStoneStair.getUnlocalisedName());
        stoneStairs.init();
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.getUnlocalisedName(), new BasicPainterTemplate<BlockPaintedStairs>(stoneStairs, Blocks.field_150446_ar, Blocks.field_150389_bf, Blocks.field_150390_bg, Blocks.field_150387_bl, Blocks.field_150372_bz, Blocks.field_150370_cb, Blocks.field_180396_cN));
        return woodStairs;
    }

    public BlockPaintedStairs(Block model, String name) {
        super(model.func_176223_P());
        if (!(model instanceof BlockStairs)) {
            throw new RuntimeException();
        }
        this.func_149647_a(null);
        this.name = name;
        this.func_149663_c(name);
    }

    private void init() {
        GameRegistry.registerBlock((Block)this, null, (String)this.name);
        GameRegistry.registerItem((Item)new BlockItemPaintedBlock((Block)this), (String)this.name);
        SmartModelAttacher.registerNoProps((Block)this);
        PaintRegistry.registerModel("stairs", new ResourceLocation("minecraft", "block/oak_stairs"), PaintRegistry.PaintMode.ALL_TEXTURES);
        PaintRegistry.registerModel("outer_stairs", new ResourceLocation("minecraft", "block/oak_outer_stairs"), PaintRegistry.PaintMode.ALL_TEXTURES);
        PaintRegistry.registerModel("inner_stairs", new ResourceLocation("minecraft", "block/oak_inner_stairs"), PaintRegistry.PaintMode.ALL_TEXTURES);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityPaintedBlock();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        this.setPaintSource(state, (IBlockAccess)world, pos, PainterUtil2.getSourceBlock(stack));
        if (!world.field_72995_K) {
            world.func_175689_h(pos);
        }
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(world, pos, player, willHarvest);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te) {
        super.func_180657_a(worldIn, player, pos, state, te);
        super.removedByPlayer(worldIn, pos, player, true);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List drops = super.getDrops(world, pos, state, fortune);
        for (ItemStack drop : drops) {
            PainterUtil2.setSourceBlock(drop, this.getPaintSource(state, world, pos));
        }
        return drops;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack pickBlock = super.getPickBlock(target, world, pos, player);
        PainterUtil2.setSourceBlock(pickBlock, this.getPaintSource(null, (IBlockAccess)world, pos));
        return pickBlock;
    }

    @Override
    public void setPaintSource(IBlockState state, IBlockAccess world, BlockPos pos, IBlockState paintSource) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            ((IPaintable.IPaintableTileEntity)te).setPaintSource(paintSource);
        }
    }

    @Override
    public void setPaintSource(Block block, ItemStack stack, IBlockState paintSource) {
        PainterUtil2.setSourceBlock(stack, paintSource);
    }

    @Override
    public IBlockState getPaintSource(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            return ((IPaintable.IPaintableTileEntity)te).getPaintSource();
        }
        return null;
    }

    @Override
    public IBlockState getPaintSource(Block block, ItemStack stack) {
        return PainterUtil2.getSourceBlock(stack);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state != null && world != null && pos != null) {
            BlockStateWrapperBase blockStateWrapper = new BlockStateWrapperBase(state, world, pos, this);
            blockStateWrapper.addCacheKey(this.getPaintSource(state, world, pos)).addCacheKey(state.func_177229_b((IProperty)field_176308_b)).addCacheKey(state.func_177229_b((IProperty)field_176309_a)).addCacheKey(state.func_177229_b((IProperty)field_176310_M));
            blockStateWrapper.bakeModel();
            return blockStateWrapper;
        }
        return state;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    private IBakedModel mapRender(IBlockState state, @Nullable IBlockState paint) {
        String model;
        int yRot;
        boolean top = state.func_177229_b((IProperty)field_176308_b) == BlockStairs.EnumHalf.TOP;
        int xRot = top ? 180 : 0;
        switch ((EnumFacing)state.func_177229_b((IProperty)field_176309_a)) {
            case EAST: {
                yRot = 0;
                break;
            }
            case NORTH: {
                yRot = 270;
                break;
            }
            case SOUTH: {
                yRot = 90;
                break;
            }
            case WEST: {
                yRot = 180;
                break;
            }
            default: {
                return null;
            }
        }
        switch ((BlockStairs.EnumShape)state.func_177229_b((IProperty)field_176310_M)) {
            case INNER_LEFT: {
                model = "inner_stairs";
                yRot += top ? 90 : -90;
                break;
            }
            case INNER_RIGHT: {
                model = "inner_stairs";
                break;
            }
            case OUTER_LEFT: {
                model = "outer_stairs";
                yRot += top ? 90 : -90;
                break;
            }
            case OUTER_RIGHT: {
                model = "outer_stairs";
                break;
            }
            case STRAIGHT: {
                model = "stairs";
                break;
            }
            default: {
                return null;
            }
        }
        return PaintRegistry.getModel(IBakedModel.class, model, paint, (IModelState)new ModelLoader.UVLock((IModelState)ModelRotation.func_177524_a((int)xRot, (int)yRot)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ICacheKey getCacheKey(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull ICacheKey cacheKey) {
        return cacheKey.addCacheKey(this.getPaintSource(block, stack));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBakedModel> mapItemRender(Block block, ItemStack stack) {
        IBlockState paintSource = this.getPaintSource(block, stack);
        IBlockState stdOverlay = BlockMachineBase.block.func_176223_P().func_177226_a(EnumRenderPart.SUB, (Comparable)((Object)EnumRenderPart.PAINT_OVERLAY));
        IBakedModel model1 = PaintRegistry.getModel(IBakedModel.class, "stairs", paintSource, (IModelState)new ModelLoader.UVLock(null));
        IBakedModel model2 = PaintRegistry.getModel(IBakedModel.class, "stairs", stdOverlay, PaintRegistry.OVERLAY_TRANSFORMATION4);
        ArrayList<IBakedModel> list = new ArrayList<IBakedModel>();
        list.add(model1);
        list.add(model2);
        return list;
    }

    public boolean canRenderInLayer(EnumWorldBlockLayer layer) {
        return true;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.func_149688_o() == Material.field_151575_d ? 20 : super.getFlammability(world, pos, face);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.func_149688_o() == Material.field_151575_d ? 5 : super.getFireSpreadSpeed(world, pos, face);
    }

    public boolean doesSideBlockRendering(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public boolean func_176225_a(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        if (worldIn.func_180495_p(pos).func_177230_c() instanceof BlockPaintedStairs && this.getPaintSource(null, worldIn, pos) == this.getPaintSource(null, worldIn, pos.func_177972_a(side.func_176734_d()))) {
            return false;
        }
        return super.func_176225_a(worldIn, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        if (tab != null) {
            super.func_149666_a(itemIn, tab, list);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBlockState> mapBlockRender(IBlockStateWrapper state, IBlockAccess world, BlockPos pos, EnumWorldBlockLayer blockLayer, QuadCollector quadCollector) {
        IBlockState paintSource = this.getPaintSource(state, world, pos);
        if (PainterUtil2.canRenderInLayer(paintSource, blockLayer)) {
            quadCollector.addFriendlybakedModel(blockLayer, this.mapRender(state, paintSource), paintSource, MathHelper.func_180186_a((Vec3i)pos));
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumMap<EnumFacing, IOMode.EnumIOMode> mapOverlayLayer(IBlockStateWrapper state, IBlockAccess world, BlockPos pos, boolean isPainted) {
        return null;
    }
}

