/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter.blocks;

import crazypants.enderio.ModObject;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.painter.blocks.BlockItemPaintedBlock;
import crazypants.enderio.machine.painter.blocks.TileEntityPaintedBlock;
import crazypants.enderio.machine.painter.recipe.BasicPainterTemplate;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.enderio.paint.render.PaintRegistry;
import crazypants.enderio.render.SmartModelAttacher;
import crazypants.enderio.render.pipeline.BlockStateWrapperBase;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlowstone;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockPaintedGlowstone
extends BlockGlowstone
implements ITileEntityProvider,
IPaintable.IBlockPaintableBlock {
    private final String name;

    public static BlockPaintedGlowstone create() {
        BlockPaintedGlowstoneSolid result = new BlockPaintedGlowstoneSolid(ModObject.blockPaintedGlowstoneSolid.getUnlocalisedName());
        super.init();
        BlockPaintedGlowstoneNonSolid result2 = new BlockPaintedGlowstoneNonSolid(ModObject.blockPaintedGlowstone.getUnlocalisedName());
        super.init();
        return result;
    }

    protected BlockPaintedGlowstone(String name) {
        super(Material.field_151592_s);
        this.name = name;
        this.func_149711_c(0.3f);
        this.func_149672_a(field_149778_k);
        this.func_149715_a(1.0f);
        this.func_149647_a(null);
        this.func_149663_c(name);
    }

    private void init() {
        GameRegistry.registerBlock((Block)this, null, (String)this.name);
        GameRegistry.registerItem((Item)new BlockItemPaintedBlock((Block)this), (String)this.name);
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.getUnlocalisedName(), new BasicPainterTemplate<BlockPaintedGlowstone>(this, Blocks.field_150426_aN));
        SmartModelAttacher.registerNoProps((Block)this);
        PaintRegistry.registerModel("cube_all", new ResourceLocation("minecraft", "block/cube_all"), PaintRegistry.PaintMode.ALL_TEXTURES);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityPaintedBlock();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        this.setPaintSource(state, (IBlockAccess)world, pos, PainterUtil2.getSourceBlock(stack));
        if (!world.field_72995_K) {
            world.func_175689_h(pos);
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack pickBlock = super.getPickBlock(target, world, pos, player);
        PainterUtil2.setSourceBlock(pickBlock, this.getPaintSource(null, (IBlockAccess)world, pos));
        return pickBlock;
    }

    @Override
    public void setPaintSource(IBlockState state, IBlockAccess world, BlockPos pos, IBlockState paintSource) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            ((IPaintable.IPaintableTileEntity)te).setPaintSource(paintSource);
        }
    }

    @Override
    public void setPaintSource(Block block, ItemStack stack, IBlockState paintSource) {
        PainterUtil2.setSourceBlock(stack, paintSource);
    }

    @Override
    public IBlockState getPaintSource(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            return ((IPaintable.IPaintableTileEntity)te).getPaintSource();
        }
        return null;
    }

    @Override
    public IBlockState getPaintSource(Block block, ItemStack stack) {
        return PainterUtil2.getSourceBlock(stack);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state != null && world != null && pos != null) {
            BlockStateWrapperBase blockStateWrapper = new BlockStateWrapperBase(state, world, pos, null);
            blockStateWrapper.addCacheKey(0);
            blockStateWrapper.bakeModel();
            return blockStateWrapper;
        }
        return state;
    }

    @Override
    public IBlockState getFacade(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.getPaintSource(this.func_176223_P(), world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int renderPass) {
        IBlockState paintSource = this.getPaintSource(null, worldIn, pos);
        if (paintSource != null) {
            try {
                return paintSource.func_177230_c().func_180662_a(worldIn, pos, renderPass);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.func_180662_a(worldIn, pos, renderPass);
    }

    public boolean canRenderInLayer(EnumWorldBlockLayer layer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        if (tab != null) {
            super.func_149666_a(itemIn, tab, list);
        }
    }

    public static class BlockPaintedGlowstoneNonSolid
    extends BlockPaintedGlowstone
    implements IPaintable.INonSolidBlockPaintableBlock {
        protected BlockPaintedGlowstoneNonSolid(String name) {
            super(name);
            this.field_149783_u = true;
            this.func_149713_g(0);
        }

        @SideOnly(value=Side.CLIENT)
        public float func_149685_I() {
            return 1.0f;
        }

        public boolean doesSideBlockRendering(IBlockAccess world, BlockPos pos, EnumFacing face) {
            return false;
        }
    }

    public static class BlockPaintedGlowstoneSolid
    extends BlockPaintedGlowstone
    implements IPaintable.ISolidBlockPaintableBlock {
        protected BlockPaintedGlowstoneSolid(String name) {
            super(name);
        }
    }
}

