/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.render;

import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.obelisk.BlockObeliskAbstract;
import crazypants.enderio.machine.obelisk.attractor.TileAttractor;
import crazypants.enderio.machine.obelisk.aversion.AversionObeliskRenderer;
import crazypants.enderio.machine.obelisk.aversion.TileAversionObelisk;
import crazypants.enderio.machine.obelisk.inhibitor.TileInhibitorObelisk;
import crazypants.enderio.machine.obelisk.render.ObeliskBakedModel;
import crazypants.enderio.machine.obelisk.render.ObeliskModelQuads;
import crazypants.enderio.machine.obelisk.render.ObeliskSpecialRenderer;
import crazypants.enderio.machine.obelisk.weather.TileWeatherObelisk;
import crazypants.enderio.machine.obelisk.weather.WeatherObeliskSpecialRenderer;
import crazypants.enderio.machine.obelisk.xp.TileExperienceObelisk;
import crazypants.enderio.material.Material;
import crazypants.enderio.render.TextureRegistry;
import crazypants.util.ClientUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ObeliskRenderManager {
    public static final ObeliskRenderManager INSTANCE = new ObeliskRenderManager();
    public static ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation("enderio:obelisk");
    private TextureRegistry.TextureSupplier[] textures;
    private TextureRegistry.TextureSupplier[] activeTextures;

    private ObeliskRenderManager() {
    }

    public void registerRenderers() {
        ObeliskSpecialRenderer eor;
        this.textures = new TextureRegistry.TextureSupplier[]{TextureRegistry.registerTexture("blocks/obeliskBottom"), TextureRegistry.registerTexture("blocks/blockSoulMachineTop"), TextureRegistry.registerTexture("blocks/blockAttractorSide"), TextureRegistry.registerTexture("blocks/blockAttractorSide"), TextureRegistry.registerTexture("blocks/blockAttractorSide"), TextureRegistry.registerTexture("blocks/blockAttractorSide")};
        this.activeTextures = new TextureRegistry.TextureSupplier[]{TextureRegistry.registerTexture("blocks/obeliskBottom"), TextureRegistry.registerTexture("blocks/blockSoulMachineTop"), TextureRegistry.registerTexture("blocks/blockAttractorSideOn"), TextureRegistry.registerTexture("blocks/blockAttractorSideOn"), TextureRegistry.registerTexture("blocks/blockAttractorSideOn"), TextureRegistry.registerTexture("blocks/blockAttractorSideOn")};
        StateMapperBase ignoreState = new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState iBlockState) {
                return MODEL_LOCATION;
            }
        };
        BlockObeliskAbstract block = EnderIO.blockExperianceOblisk;
        if (block != null) {
            eor = new ObeliskSpecialRenderer((Block)block, new ItemStack((Item)EnderIO.itemXpTransfer));
            this.registerRenderer(block, TileExperienceObelisk.class, eor, (IStateMapper)ignoreState);
        }
        if ((block = EnderIO.blockAttractor) != null) {
            eor = new ObeliskSpecialRenderer((Block)block, new ItemStack((Item)EnderIO.itemMaterial, 1, Material.ATTRACTOR_CRYSTAL.ordinal()));
            this.registerRenderer(block, TileAttractor.class, eor, (IStateMapper)ignoreState);
        }
        if ((block = EnderIO.blockSpawnGuard) != null) {
            eor = new AversionObeliskRenderer();
            this.registerRenderer(block, TileAversionObelisk.class, eor, (IStateMapper)ignoreState);
        }
        if ((block = EnderIO.blockWeatherObelisk) != null) {
            eor = new WeatherObeliskSpecialRenderer(new ItemStack(Items.field_151152_bP));
            this.registerRenderer(block, TileWeatherObelisk.class, eor, (IStateMapper)ignoreState);
        }
        if ((block = EnderIO.blockInhibitorObelisk) != null) {
            eor = new ObeliskSpecialRenderer((Block)block, new ItemStack(Items.field_151079_bi));
            this.registerRenderer(block, TileInhibitorObelisk.class, eor, (IStateMapper)ignoreState);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private <T extends AbstractMachineEntity> void registerRenderer(BlockObeliskAbstract<? extends AbstractMachineEntity> block, Class<T> tileClass, TileEntitySpecialRenderer<? super T> specialRenderer, IStateMapper ignoreState) {
        ClientRegistry.bindTileEntitySpecialRenderer(tileClass, specialRenderer);
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a(block), (int)0, tileClass);
        ClientUtil.registerRenderer(Item.func_150898_a(block), block.getName());
        ModelLoader.setCustomStateMapper(block, (IStateMapper)ignoreState);
    }

    public TextureRegistry.TextureSupplier[] getTextures() {
        return this.textures;
    }

    public TextureRegistry.TextureSupplier[] getActiveTextures() {
        return this.activeTextures;
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        IBakedModel defaultBakedModel = (IBakedModel)event.modelRegistry.func_82594_a((Object)MODEL_LOCATION);
        ObeliskBakedModel model = new ObeliskBakedModel(defaultBakedModel);
        event.modelRegistry.func_82595_a((Object)MODEL_LOCATION, (Object)model);
    }

    @SubscribeEvent
    public void onIconLoad(TextureStitchEvent.Pre event) {
        ObeliskModelQuads.INSTANCE.invalidate();
        ObeliskModelQuads.INSTANCE_ACTIVE.invalidate();
    }
}

