/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.machine.invpanel.TileInventoryPanel;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGuiSettings
extends MessageTileEntity<TileInventoryPanel>
implements IMessageHandler<PacketGuiSettings, IMessage> {
    private int sortMode;
    private String filterString;
    private boolean sync;

    public PacketGuiSettings() {
        this.filterString = "";
    }

    public PacketGuiSettings(TileInventoryPanel tile, int sortMode, String filterString, boolean sync) {
        super((TileEntity)tile);
        this.sortMode = sortMode;
        this.filterString = filterString;
        this.sync = sync;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.sortMode = buf.readInt();
        this.filterString = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.sync = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.sortMode);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.filterString);
        buf.writeBoolean(this.sync);
    }

    public IMessage onMessage(PacketGuiSettings message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        TileEntity te = player.field_70170_p.func_175625_s(new BlockPos(message.x, message.y, message.z));
        if (te instanceof TileInventoryPanel) {
            TileInventoryPanel teInvPanel = (TileInventoryPanel)te;
            teInvPanel.setGuiParameter(message.sortMode, message.filterString, message.sync);
        }
        return null;
    }
}

