/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.combustion;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.FluidUtil;
import crazypants.enderio.ModObject;
import crazypants.enderio.fluid.FluidFuelRegister;
import crazypants.enderio.fluid.IFluidCoolant;
import crazypants.enderio.fluid.IFluidFuel;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.generator.AbstractGeneratorEntity;
import crazypants.enderio.machine.generator.combustion.PacketCombustionTank;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.power.PowerDistributor;
import crazypants.enderio.tool.SmartTank;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Storable
public class TileCombustionGenerator
extends AbstractGeneratorEntity
implements IFluidHandler,
ITankAccess,
IPaintable.IPaintableTileEntity {
    @Store
    private final SmartTank coolantTank = new SmartTank(5000);
    @Store
    private final SmartTank fuelTank = new SmartTank(5000);
    private boolean tanksDirty;
    @Store(value={Store.StoreFor.ITEM, Store.StoreFor.SAVE})
    private int ticksRemaingFuel;
    @Store(value={Store.StoreFor.ITEM, Store.StoreFor.SAVE})
    private int ticksRemaingCoolant;
    @Store(value={Store.StoreFor.CLIENT})
    private boolean active;
    private PowerDistributor powerDis;
    @Store(value={Store.StoreFor.CLIENT})
    private int generated;
    private boolean inPause = false;
    private boolean generatedDirty = false;
    private int maxOutputTick = 1280;
    private static int IO_MB_TICK = 250;
    private IFluidFuel curFuel;
    private IFluidCoolant curCoolant;
    public static float HEAT_PER_RF = 2.3E-4f;

    public TileCombustionGenerator() {
        super(new SlotDefinition(-1, -1, -1, -1, -1, -1), ModObject.blockCombustionGenerator);
    }

    @Override
    protected boolean doPull(EnumFacing dir) {
        FluidTankInfo[] infos;
        boolean res = super.doPull(dir);
        BlockCoord loc = this.getLocation().getLocation(dir);
        IFluidHandler target = FluidUtil.getFluidHandler((IBlockAccess)this.field_145850_b, (BlockCoord)loc);
        if (target != null && (infos = target.getTankInfo(dir.func_176734_d())) != null) {
            for (FluidTankInfo info : infos) {
                int filled;
                if (info.fluid == null || info.fluid.amount <= 0 || !this.canFill(dir, info.fluid.getFluid())) continue;
                FluidStack canPull = info.fluid.copy();
                canPull.amount = Math.min(IO_MB_TICK, canPull.amount);
                FluidStack drained = target.drain(dir.func_176734_d(), canPull, false);
                if (drained == null || drained.amount <= 0 || (filled = this.fill(dir, drained, false)) <= 0) continue;
                drained = target.drain(dir.func_176734_d(), filled, true);
                this.fill(dir, drained, true);
                return res;
            }
        }
        return res;
    }

    @Override
    public boolean supportsMode(EnumFacing faceHit, IoMode mode) {
        return mode != IoMode.PUSH && mode != IoMode.PUSH_PULL;
    }

    @Override
    public String getMachineName() {
        return ModObject.blockCombustionGenerator.getUnlocalisedName();
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() == null || !this.canFill(from, resource.getFluid())) {
            return 0;
        }
        int res = 0;
        IFluidCoolant cool = FluidFuelRegister.instance.getCoolant(resource.getFluid());
        if (cool != null) {
            res = this.getCoolantTank().fill(resource, doFill);
        } else {
            IFluidFuel f = FluidFuelRegister.instance.getFuel(resource.getFluid());
            if (f != null) {
                res = this.getFuelTank().fill(resource, doFill);
            }
        }
        if (res > 0) {
            this.tanksDirty = true;
        }
        return res;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public void onNeighborBlockChange(Block blockId) {
        super.onNeighborBlockChange(blockId);
        if (this.powerDis != null) {
            this.powerDis.neighboursChanged();
        }
    }

    @Override
    protected boolean processTasks(boolean redstoneChecksPassed) {
        boolean res = false;
        if (!redstoneChecksPassed) {
            if (this.active) {
                this.active = false;
                res = true;
            }
            return res;
        }
        int lastGenerated = this.generated;
        boolean isActive = this.generateEnergy();
        if (isActive != this.active) {
            this.active = isActive;
            res = true;
        }
        if (lastGenerated != this.generated) {
            this.generatedDirty = true;
        }
        if (this.getEnergyStored() >= this.getMaxEnergyStored()) {
            this.inPause = true;
        }
        this.transmitEnergy();
        if (this.tanksDirty && this.shouldDoWorkThisTick(10)) {
            PacketHandler.sendToAllAround((IMessage)new PacketCombustionTank(this), (TileEntity)this);
            this.tanksDirty = false;
        }
        if (this.generatedDirty && this.shouldDoWorkThisTick(10)) {
            this.generatedDirty = false;
            res = true;
        }
        return res;
    }

    private boolean transmitEnergy() {
        if (this.getEnergyStored() <= 0) {
            return false;
        }
        if (this.powerDis == null) {
            this.powerDis = new PowerDistributor(new BlockCoord((TileEntity)this));
        }
        int transmitted = this.powerDis.transmitEnergy(this.field_145850_b, Math.min(this.maxOutputTick, this.getEnergyStored()));
        this.setEnergyStored(this.getEnergyStored() - transmitted);
        return transmitted > 0;
    }

    private boolean generateEnergy() {
        this.generated = 0;
        if (this.ticksRemaingCoolant <= 0 && this.getCoolantTank().getFluidAmount() <= 0 || this.ticksRemaingFuel <= 0 && this.getFuelTank().getFluidAmount() <= 0 || this.getEnergyStored() >= this.getMaxEnergyStored()) {
            return false;
        }
        if (this.inPause) {
            int powerPerCycle = this.getPowerPerCycle();
            if (this.getEnergyStored() >= this.getMaxEnergyStored() - powerPerCycle * 200) {
                return false;
            }
        }
        this.inPause = false;
        --this.ticksRemaingFuel;
        if (this.ticksRemaingFuel <= 0) {
            this.curFuel = FluidFuelRegister.instance.getFuel(this.getFuelTank().getFluid());
            if (this.curFuel == null) {
                return false;
            }
            FluidStack drained = this.getFuelTank().drain(100, true);
            if (drained == null) {
                return false;
            }
            this.ticksRemaingFuel = TileCombustionGenerator.getNumTicksPerMbFuel(this.curFuel) * drained.amount;
            this.tanksDirty = true;
        } else if (this.curFuel == null) {
            this.curFuel = FluidFuelRegister.instance.getFuel(this.getFuelTank().getFluid());
            if (this.curFuel == null) {
                return false;
            }
        }
        --this.ticksRemaingCoolant;
        if (this.ticksRemaingCoolant <= 0) {
            this.updateCoolantFromTank();
            if (this.curCoolant == null) {
                return false;
            }
            FluidStack drained = this.getCoolantTank().drain(100, true);
            if (drained == null) {
                return false;
            }
            this.ticksRemaingCoolant = TileCombustionGenerator.getNumTicksPerMbCoolant(this.curCoolant, this.curFuel) * drained.amount;
        } else if (this.curCoolant == null) {
            this.updateCoolantFromTank();
            if (this.curCoolant == null) {
                return false;
            }
        }
        this.generated = this.getPowerPerCycle();
        this.setEnergyStored(this.getEnergyStored() + this.generated);
        return this.getFuelTank().getFluidAmount() > 0 && this.getCoolantTank().getFluidAmount() > 0;
    }

    protected void updateCoolantFromTank() {
        this.curCoolant = FluidFuelRegister.instance.getCoolant(this.getCoolantTank().getFluid());
    }

    private int getPowerPerCycle() {
        return this.curFuel == null ? 0 : this.curFuel.getPowerPerCycle();
    }

    public int getNumTicksPerMbFuel() {
        if (this.getFuelTank().getFluidAmount() <= 0) {
            return 0;
        }
        return TileCombustionGenerator.getNumTicksPerMbFuel(FluidFuelRegister.instance.getFuel(this.getFuelTank().getFluid().getFluid()));
    }

    public int getNumTicksPerMbCoolant() {
        if (this.getFuelTank().getFluidAmount() <= 0) {
            return 0;
        }
        if (this.field_145850_b.field_72995_K) {
            this.curFuel = FluidFuelRegister.instance.getFuel(this.getFuelTank().getFluid());
            this.updateCoolantFromTank();
        }
        return TileCombustionGenerator.getNumTicksPerMbCoolant(this.curCoolant, this.curFuel);
    }

    static int getNumTicksPerMbFuel(IFluidFuel fuel) {
        if (fuel == null) {
            return 0;
        }
        return fuel.getTotalBurningTime() / 1000;
    }

    static int getNumTicksPerMbCoolant(IFluidCoolant coolant, IFluidFuel fuel) {
        if (coolant == null || fuel == null) {
            return 0;
        }
        float power = fuel.getPowerPerCycle();
        float cooling = coolant.getDegreesCoolingPerMB(100.0f);
        double toCool = 1.0 / (double)(HEAT_PER_RF * power);
        int numTicks = (int)Math.round(toCool / (double)(cooling * 1000.0f));
        return numTicks;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (this.isSideDisabled(from) || fluid == null) {
            return false;
        }
        return FluidFuelRegister.instance.getCoolant(fluid) != null || FluidFuelRegister.instance.getFuel(fluid) != null;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (this.isSideDisabled(from)) {
            return new FluidTankInfo[0];
        }
        return new FluidTankInfo[]{this.getCoolantTank().getInfo(), this.getFuelTank().getInfo()};
    }

    public int getGeneratedLastTick() {
        if (!this.active) {
            return 0;
        }
        return this.generated;
    }

    @Override
    public int getPowerUsePerTick() {
        if (this.getFuelTank().getFluidAmount() <= 0) {
            return 0;
        }
        IFluidFuel fuel = FluidFuelRegister.instance.getFuel(this.getFuelTank().getFluid());
        if (fuel == null) {
            return 0;
        }
        return fuel.getPowerPerCycle();
    }

    public FluidTank getCoolantTank() {
        return this.coolantTank;
    }

    public FluidTank getFuelTank() {
        return this.fuelTank;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        if (forFluidType != null) {
            if (FluidFuelRegister.instance.getCoolant(forFluidType.getFluid()) != null) {
                return this.coolantTank;
            }
            if (FluidFuelRegister.instance.getFuel(forFluidType.getFluid()) != null) {
                return this.fuelTank;
            }
        }
        return null;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[0];
    }

    public void setTanksDirty() {
        this.tanksDirty = true;
    }
}

