/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.gauge;

import cofh.api.energy.IEnergyHandler;
import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import crazypants.enderio.BlockEio;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.gauge.RenderMapperGauge;
import crazypants.enderio.machine.gauge.TileGauge;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.ISmartRenderAwareBlock;
import crazypants.enderio.render.SmartModelAttacher;
import crazypants.enderio.render.TextureRegistry;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGauge
extends BlockEio<TileGauge>
implements IResourceTooltipProvider,
ISmartRenderAwareBlock {
    public static final TextureRegistry.TextureSupplier gaugeIcon = TextureRegistry.registerTexture("blocks/blockGaugeOverlay");
    private static final double px = 0.0625;

    public static BlockGauge create() {
        BlockGauge result = new BlockGauge();
        result.init();
        return result;
    }

    private BlockGauge() {
        super(ModObject.blockGauge.getUnlocalisedName(), TileGauge.class, Material.field_151592_s);
        this.func_149713_g(255);
        this.field_149783_u = true;
    }

    protected void init() {
        super.init();
        SmartModelAttacher.registerItemOnly((Block)this);
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        if (tab != null) {
            super.func_149666_a(itemIn, tab, list);
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public void func_180654_a(IBlockAccess world, BlockPos pos) {
        this.field_149760_C = 0.125;
        this.field_149756_F = 0.875;
        Map<EnumFacing, IEnergyHandler> sides = BlockGauge.getDisplays(world, pos);
        if (sides.isEmpty()) {
            this.field_149759_B = 0.0;
            this.field_149755_E = 1.0;
            this.field_149754_D = 0.0;
            this.field_149757_G = 1.0;
            return;
        }
        this.field_149759_B = 1.0;
        this.field_149755_E = 0.0;
        this.field_149754_D = 1.0;
        this.field_149757_G = 0.0;
        if (sides.containsKey(EnumFacing.NORTH) || sides.containsKey(EnumFacing.SOUTH)) {
            this.field_149759_B = Math.min(this.field_149759_B, 0.375);
            this.field_149755_E = Math.max(this.field_149755_E, 0.625);
            if (sides.containsKey(EnumFacing.NORTH)) {
                this.field_149754_D = Math.min(this.field_149754_D, 0.0);
                this.field_149757_G = Math.max(this.field_149757_G, 0.03125);
            }
            if (sides.containsKey(EnumFacing.SOUTH)) {
                this.field_149754_D = Math.min(this.field_149754_D, 0.96875);
                this.field_149757_G = Math.max(this.field_149757_G, 1.0);
            }
        }
        if (sides.containsKey(EnumFacing.EAST) || sides.containsKey(EnumFacing.WEST)) {
            this.field_149754_D = Math.min(this.field_149754_D, 0.375);
            this.field_149757_G = Math.max(this.field_149757_G, 0.625);
            if (sides.containsKey(EnumFacing.WEST)) {
                this.field_149759_B = Math.min(this.field_149759_B, 0.0);
                this.field_149755_E = Math.max(this.field_149755_E, 0.09375);
            }
            if (sides.containsKey(EnumFacing.EAST)) {
                this.field_149759_B = Math.min(this.field_149759_B, 0.96875);
                this.field_149755_E = Math.max(this.field_149755_E, 1.0);
            }
        }
    }

    public AxisAlignedBB func_180646_a(World world, BlockPos pos) {
        this.func_180654_a((IBlockAccess)world, pos);
        return super.func_180646_a(world, pos);
    }

    protected static Map<EnumFacing, IEnergyHandler> getDisplays(IBlockAccess world, BlockPos pos) {
        EnumMap<EnumFacing, IEnergyHandler> sides = new EnumMap<EnumFacing, IEnergyHandler>(EnumFacing.class);
        for (EnumFacing face : EnumFacing.Plane.HORIZONTAL) {
            IEnergyHandler eh;
            BlockPos neighbor = pos.func_177972_a(face);
            TileEntity tile = world.func_175625_s(neighbor);
            if (!(tile instanceof IEnergyHandler) || tile instanceof TileCapBank || tile instanceof IConduitBundle || !(eh = (IEnergyHandler)tile).canConnectEnergy(face.func_176734_d())) continue;
            sides.put(face, eh);
        }
        return sides;
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        return null;
    }

    @Override
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return RenderMapperGauge.instance;
    }

    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.func_149739_a();
    }
}

