/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.CustomSeedFarmer;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class StemFarmer
extends CustomSeedFarmer {
    private static final HeightCompatator COMP = new HeightCompatator();

    public StemFarmer(Block plantedBlock, ItemStack seeds) {
        super(plantedBlock, seeds);
    }

    @Override
    public boolean prepareBlock(TileFarmStation farm, BlockCoord bc, Block block, IBlockState meta) {
        if (this.plantedBlock == block) {
            return true;
        }
        return this.plantFromInventory(farm, bc);
    }

    @Override
    public boolean canHarvest(TileFarmStation farm, BlockCoord bc, Block block, IBlockState meta) {
        BlockCoord up = bc.getLocation(EnumFacing.UP);
        Block upBLock = farm.getBlock(up);
        return upBLock == this.plantedBlock;
    }

    @Override
    public boolean canPlant(ItemStack stack) {
        return this.seeds.func_77969_a(stack);
    }

    @Override
    public IHarvestResult harvestBlock(TileFarmStation farm, BlockCoord bc, Block block, IBlockState meta) {
        HarvestResult res = new HarvestResult();
        BlockPos harvestCoord = bc.getBlockPos();
        boolean done = false;
        do {
            harvestCoord = harvestCoord.func_177972_a(EnumFacing.UP);
            boolean hasHoe = farm.hasHoe();
            if (this.plantedBlock == farm.getBlock(harvestCoord) && hasHoe) {
                res.harvestedBlocks.add(harvestCoord);
                List drops = this.plantedBlock.getDrops((IBlockAccess)farm.func_145831_w(), harvestCoord, meta, farm.getMaxLootingValue());
                if (drops != null) {
                    for (ItemStack drop : drops) {
                        res.drops.add(new EntityItem(farm.func_145831_w(), (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, drop.func_77946_l()));
                    }
                }
                farm.damageHoe(1, new BlockCoord(harvestCoord));
                farm.actionPerformed(false);
                continue;
            }
            if (!hasHoe) {
                farm.setNotification("noHoe");
            } else {
                farm.clearNotification();
            }
            done = true;
        } while (!done);
        ArrayList<BlockPos> toClear = new ArrayList<BlockPos>(res.getHarvestedBlocks());
        Collections.sort(toClear, COMP);
        for (BlockPos coord : toClear) {
            farm.func_145831_w().func_175698_g(coord);
        }
        return res;
    }

    @Override
    protected boolean plantFromInventory(TileFarmStation farm, BlockCoord bc) {
        World worldObj = farm.func_145831_w();
        if (this.canPlant(worldObj, bc) && farm.takeSeedFromSupplies(this.seeds, bc) != null) {
            return this.plant(farm, worldObj, bc);
        }
        return false;
    }

    private static class HeightCompatator
    implements Comparator<BlockPos> {
        private HeightCompatator() {
        }

        @Override
        public int compare(BlockPos o1, BlockPos o2) {
            return -HeightCompatator.compare(o1.func_177956_o(), o2.func_177956_o());
        }

        public static int compare(int x, int y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }
    }
}

