/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.IFarmerJoe;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStem;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class PlantableFarmer
implements IFarmerJoe {
    private Set<Block> harvestExcludes = new HashSet<Block>();

    public void addHarvestExlude(Block block) {
        this.harvestExcludes.add(block);
    }

    @Override
    public boolean canPlant(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.func_77973_b() instanceof IPlantable;
    }

    @Override
    public boolean prepareBlock(TileFarmStation farm, BlockCoord bc, Block block, IBlockState meta) {
        if (block == null) {
            return false;
        }
        ItemStack seedStack = farm.getSeedTypeInSuppliesFor(bc);
        if (seedStack == null) {
            farm.setNotification("noSeeds");
            return false;
        }
        if (!(seedStack.func_77973_b() instanceof IPlantable)) {
            return false;
        }
        IPlantable plantable = (IPlantable)seedStack.func_77973_b();
        EnumPlantType type = plantable.getPlantType((IBlockAccess)farm.func_145831_w(), bc.getBlockPos());
        if (type == null) {
            return false;
        }
        Block ground = farm.getBlock(bc.getLocation(EnumFacing.DOWN));
        if (type == EnumPlantType.Nether) {
            if (ground != Blocks.field_150425_aM) {
                return false;
            }
            return this.plantFromInventory(farm, bc, plantable);
        }
        if (type == EnumPlantType.Crop) {
            farm.tillBlock(bc);
            return this.plantFromInventory(farm, bc, plantable);
        }
        if (type == EnumPlantType.Water) {
            return this.plantFromInventory(farm, bc, plantable);
        }
        return false;
    }

    protected boolean plantFromInventory(TileFarmStation farm, BlockCoord bc, IPlantable plantable) {
        World worldObj = farm.func_145831_w();
        if (this.canPlant(worldObj, bc, plantable) && farm.takeSeedFromSupplies(bc) != null) {
            return this.plant(farm, worldObj, bc, plantable);
        }
        return false;
    }

    protected boolean plant(TileFarmStation farm, World worldObj, BlockCoord bc, IPlantable plantable) {
        worldObj.func_180501_a(bc.getBlockPos(), Blocks.field_150350_a.func_176223_P(), 3);
        IBlockState target = plantable.getPlant(null, new BlockPos(0, 0, 0));
        worldObj.func_180501_a(bc.getBlockPos(), target, 3);
        farm.actionPerformed(false);
        return true;
    }

    protected boolean canPlant(World worldObj, BlockCoord bc, IPlantable plantable) {
        IBlockState target = plantable.getPlant(null, new BlockPos(0, 0, 0));
        BlockPos groundPos = bc.getBlockPos().func_177977_b();
        IBlockState groundBS = worldObj.func_180495_p(groundPos);
        Block ground = groundBS.func_177230_c();
        return target != null && target.func_177230_c().func_176196_c(worldObj, bc.getBlockPos()) && ground.canSustainPlant((IBlockAccess)worldObj, groundPos, EnumFacing.UP, plantable);
    }

    @Override
    public boolean canHarvest(TileFarmStation farm, BlockCoord bc, Block block, IBlockState meta) {
        if (!this.harvestExcludes.contains(block) && block instanceof IGrowable && !(block instanceof BlockStem)) {
            return !((IGrowable)block).func_176473_a(farm.func_145831_w(), bc.getBlockPos(), meta, true);
        }
        return false;
    }

    @Override
    public IHarvestResult harvestBlock(TileFarmStation farm, BlockCoord bc, Block block, IBlockState meta) {
        if (!this.canHarvest(farm, bc, block, meta)) {
            return null;
        }
        if (!farm.hasHoe()) {
            farm.setNotification("noHoe");
            return null;
        }
        World worldObj = farm.func_145831_w();
        ArrayList<EntityItem> result = new ArrayList<EntityItem>();
        ItemStack removedPlantable = null;
        List drops = block.getDrops((IBlockAccess)worldObj, bc.getBlockPos(), meta, farm.getMaxLootingValue());
        farm.damageHoe(1, bc);
        farm.actionPerformed(false);
        boolean removed = false;
        if (drops != null) {
            for (ItemStack stack : drops) {
                if (stack == null || stack.field_77994_a <= 0) continue;
                if (!removed && this.isPlantableForBlock(stack, block)) {
                    removed = true;
                    removedPlantable = stack.func_77946_l();
                    removedPlantable.field_77994_a = 1;
                    --stack.field_77994_a;
                    if (stack.field_77994_a <= 0) continue;
                    result.add(new EntityItem(worldObj, (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, stack.func_77946_l()));
                    continue;
                }
                result.add(new EntityItem(worldObj, (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, stack.func_77946_l()));
            }
        }
        if (removed) {
            if (!this.plant(farm, worldObj, bc, (IPlantable)removedPlantable.func_77973_b())) {
                result.add(new EntityItem(worldObj, (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, removedPlantable.func_77946_l()));
                worldObj.func_180501_a(bc.getBlockPos(), Blocks.field_150350_a.func_176223_P(), 3);
            }
        } else {
            worldObj.func_180501_a(bc.getBlockPos(), Blocks.field_150350_a.func_176223_P(), 3);
        }
        return new HarvestResult(result, bc.getBlockPos());
    }

    private boolean isPlantableForBlock(ItemStack stack, Block block) {
        if (!(stack.func_77973_b() instanceof IPlantable)) {
            return false;
        }
        IPlantable plantable = (IPlantable)stack.func_77973_b();
        return plantable.getPlant(null, new BlockPos(0, 0, 0)) == block;
    }
}

