/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.machine.farm.FarmStationContainer;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.IFarmerJoe;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FlowerPicker
implements IFarmerJoe {
    protected List<Block> flowers = new ArrayList<Block>();

    public FlowerPicker add(Block ... flowers) {
        for (Block block : flowers) {
            if (block == null) continue;
            this.flowers.add(block);
            FarmStationContainer.slotItemsProduce.add(new ItemStack(block));
        }
        return this;
    }

    @Override
    public boolean prepareBlock(TileFarmStation farm, BlockCoord bc, Block block, IBlockState meta) {
        return false;
    }

    @Override
    public boolean canHarvest(TileFarmStation farm, BlockCoord bc, Block block, IBlockState meta) {
        for (Block flower : this.flowers) {
            if (block != flower) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canPlant(ItemStack stack) {
        return false;
    }

    @Override
    public IHarvestResult harvestBlock(TileFarmStation farm, BlockCoord bc, Block block, IBlockState meta) {
        if (!farm.hasHoe()) {
            farm.setNotification("noHoe");
            return null;
        }
        World worldObj = farm.func_145831_w();
        ArrayList<EntityItem> result = new ArrayList<EntityItem>();
        List drops = block.getDrops((IBlockAccess)worldObj, bc.getBlockPos(), meta, farm.getMaxLootingValue());
        farm.damageHoe(1, bc);
        farm.actionPerformed(false);
        if (drops != null) {
            for (ItemStack stack : drops) {
                result.add(new EntityItem(worldObj, (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, stack.func_77946_l()));
            }
        }
        worldObj.func_175698_g(bc.getBlockPos());
        return new HarvestResult(result, bc.getBlockPos());
    }
}

