/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank.network;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.capbank.network.CapBankNetwork;
import crazypants.enderio.machine.capbank.network.ICapBankNetwork;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class NetworkUtil {
    private static AtomicInteger nextID = new AtomicInteger(0);

    public static void ensureValidNetwork(TileCapBank cap) {
        World world = cap.func_145831_w();
        Collection<TileCapBank> neighbours = NetworkUtil.getNeigbours(cap);
        if (NetworkUtil.reuseNetwork(cap, neighbours, world)) {
            return;
        }
        CapBankNetwork network = new CapBankNetwork(nextID.getAndIncrement());
        network.init(cap, neighbours, world);
    }

    public static Collection<TileCapBank> getNeigbours(TileCapBank cap) {
        if (!cap.getType().isMultiblock()) {
            return Collections.emptyList();
        }
        ArrayList<TileCapBank> res = new ArrayList<TileCapBank>();
        NetworkUtil.getNeigbours(cap, res);
        return res;
    }

    public static void getNeigbours(TileCapBank cap, Collection<TileCapBank> res) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            TileCapBank neighbour;
            BlockCoord bc = cap.getLocation().getLocation(dir);
            TileEntity te = cap.func_145831_w().func_175625_s(bc.getBlockPos());
            if (!(te instanceof TileCapBank) || !(neighbour = (TileCapBank)te).canConnectTo(cap)) continue;
            res.add(neighbour);
        }
    }

    private static boolean reuseNetwork(TileCapBank cap, Collection<TileCapBank> neighbours, World world) {
        ICapBankNetwork network = null;
        for (TileCapBank conduit : neighbours) {
            if (network == null) {
                network = conduit.getNetwork();
                continue;
            }
            if (network == conduit.getNetwork()) continue;
            return false;
        }
        if (network == null) {
            return false;
        }
        if (cap.setNetwork(network)) {
            network.addMember(cap);
            return true;
        }
        return false;
    }
}

