/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.jei;

import crazypants.enderio.machine.recipe.IRecipe;
import crazypants.enderio.machine.recipe.RecipeOutput;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeWrapper
extends BlankRecipeWrapper {
    private final IRecipe recipe;

    public RecipeWrapper(IRecipe recipe) {
        this.recipe = recipe;
    }

    @Nonnull
    public List<?> getInputs() {
        ArrayList inputStacks = this.recipe.getInputStacks();
        return inputStacks != null ? inputStacks : new ArrayList();
    }

    @Nonnull
    public List<?> getOutputs() {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (RecipeOutput out : this.recipe.getOutputs()) {
            if (out.getOutput() == null) continue;
            outputs.add(out.getOutput());
        }
        return outputs;
    }

    @Nonnull
    public List<FluidStack> getFluidInputs() {
        ArrayList inputFluidStacks = this.recipe.getInputFluidStacks();
        return inputFluidStacks != null ? inputFluidStacks : new ArrayList();
    }

    @Nonnull
    public List<FluidStack> getFluidOutputs() {
        ArrayList<FluidStack> outputs = new ArrayList<FluidStack>();
        for (RecipeOutput out : this.recipe.getOutputs()) {
            if (out.getFluidOutput() == null) continue;
            outputs.add(out.getFluidOutput());
        }
        return outputs;
    }

    public boolean isValid() {
        return this.recipe != null && this.recipe.isValid();
    }

    public int getEnergyRequired() {
        return this.recipe.getEnergyRequired();
    }

    public IRecipe getRecipe() {
        return this.recipe;
    }
}

