/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.jei;

import com.enderio.core.common.util.ItemUtil;
import crazypants.enderio.machine.crafter.ContainerCrafter;
import crazypants.enderio.machine.crafter.GuiCrafter;
import crazypants.enderio.machine.gui.AbstractMachineContainer;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import mezz.jei.gui.ingredients.IGuiIngredient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class CrafterRecipeTransferHandler
implements IRecipeTransferHandler {
    public static void register(IModRegistry registry) {
        IRecipeTransferRegistry recipeTransferRegistry = registry.getRecipeTransferRegistry();
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferHandler)new CrafterRecipeTransferHandler());
        registry.addRecipeClickArea(GuiCrafter.class, 198, 62, 16, 16, new String[]{"minecraft.crafting"});
    }

    private CrafterRecipeTransferHandler() {
    }

    public Class<? extends Container> getContainerClass() {
        return ContainerCrafter.class;
    }

    public String getRecipeCategoryUid() {
        return "minecraft.crafting";
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@Nonnull Container container, @Nonnull IRecipeLayout recipeLayout, @Nonnull EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        if (!doTransfer) {
            return null;
        }
        if (container instanceof ContainerCrafter) {
            ContainerCrafter crafter = (ContainerCrafter)container;
            List<ContainerCrafter.DummySlot> dummySlots = crafter.getDummySlots();
            IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
            Map guiIngredients = itemStacks.getGuiIngredients();
            for (int i = 0; i < 9; ++i) {
                if (i >= dummySlots.size()) continue;
                if (guiIngredients.containsKey(i + 1)) {
                    IGuiIngredient guiIngredient = (IGuiIngredient)guiIngredients.get(i + 1);
                    List allIngredients = guiIngredient.getAllIngredients();
                    if (!allIngredients.isEmpty()) {
                        dummySlots.get(i).putStack(CrafterRecipeTransferHandler.findBestMatchInInventory(crafter, allIngredients));
                        continue;
                    }
                    dummySlots.get(i).putStack(null);
                    continue;
                }
                dummySlots.get(i).putStack(null);
            }
        }
        return null;
    }

    private static ItemStack findBestMatchInInventory(ContainerCrafter crafter, List<ItemStack> allIngredients) {
        if (allIngredients.size() > 1) {
            AbstractMachineContainer.SlotRange slotRange = crafter.getPlayerInventorySlotRange(false);
            for (int i = slotRange.getStart(); i < slotRange.getEnd(); ++i) {
                Slot slot = (Slot)crafter.field_75151_b.get(i);
                if (!slot.func_75216_d()) continue;
                ItemStack stack = slot.func_75211_c();
                for (ItemStack ingredient : allIngredients) {
                    if (!ItemUtil.areStacksEqual((ItemStack)stack, (ItemStack)ingredient)) continue;
                    return ingredient;
                }
            }
        }
        return allIngredients.get(0);
    }
}

