/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.skull;

import crazypants.enderio.BlockEio;
import crazypants.enderio.IHaveRenderers;
import crazypants.enderio.ModObject;
import crazypants.enderio.item.skull.ItemEndermanSkull;
import crazypants.enderio.item.skull.TileEndermanSkull;
import crazypants.util.ClientUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.crafting.IInfusionStabiliser;

@Optional.Interface(iface="thaumcraft.api.crafting.IInfusionStabiliser", modid="Thaumcraft")
public class BlockEndermanSkull
extends BlockEio<TileEndermanSkull>
implements IInfusionStabiliser,
IHaveRenderers {
    public static final PropertyEnum<SkullType> VARIANT = PropertyEnum.func_177709_a((String)"variant", SkullType.class);

    public static BlockEndermanSkull create() {
        BlockEndermanSkull res = new BlockEndermanSkull();
        res.init();
        return res;
    }

    private BlockEndermanSkull() {
        super(ModObject.blockEndermanSkull.getUnlocalisedName(), TileEndermanSkull.class, ItemEndermanSkull.class, Material.field_151594_q);
        this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.5f, 0.75f);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers() {
        Item item = Item.func_150898_a((Block)this);
        int num = SkullType.values().length;
        for (int i = 0; i < num; ++i) {
            SkullType st = SkullType.values()[i];
            ClientUtil.regRenderer(item, i, ModObject.blockEndermanSkull.getUnlocalisedName() + "_" + st.name);
        }
    }

    public int func_180651_a(IBlockState state) {
        SkullType var = (SkullType)((Object)state.func_177229_b(VARIANT));
        return var.ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        SkullType var = SkullType.values()[meta];
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)var));
    }

    public int func_176201_c(IBlockState state) {
        SkullType var = (SkullType)((Object)state.func_177229_b(VARIANT));
        return var.ordinal();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{VARIANT});
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return 2;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        int inc = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
        float facingYaw = -22.5f * (float)inc;
        TileEndermanSkull te = (TileEndermanSkull)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            te.setYaw(facingYaw);
        }
        if (world.field_72995_K) {
            return;
        }
        world.func_175656_a(pos, this.func_176203_a(stack.func_77952_i()));
        world.func_175689_h(pos);
    }

    public AxisAlignedBB func_180646_a(World worldIn, BlockPos pos) {
        TileEndermanSkull tileEntity = (TileEndermanSkull)this.getTileEntity((IBlockAccess)worldIn, pos);
        if (tileEntity != null) {
            tileEntity.lookingAt = 20;
        }
        return super.func_180646_a(worldIn, pos);
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean canStabaliseInfusion(World world, BlockPos pos) {
        return true;
    }

    public static enum SkullType implements IStringSerializable
    {
        BASE("base", false),
        REANIMATED("reanimated", true),
        TORMENTED("tormented", false),
        REANIMATED_TORMENTED("reanimatedTormented", true);

        final String name;
        final boolean showEyes;

        private SkullType(String name, boolean showEyes) {
            this.name = name;
            this.showEyes = showEyes;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

