/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.gui;

import com.enderio.core.client.gui.GuiContainerBase;
import com.enderio.core.client.render.RenderUtil;
import crazypants.enderio.EnderIO;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class GuiContainerBaseEIO
extends GuiContainerBase {
    private static final String TEXTURE_PATH = ":textures/gui/23/";
    private static final String TEXTURE_EXT = ".png";
    private final List<ResourceLocation> guiTextures = new ArrayList<ResourceLocation>();

    public GuiContainerBaseEIO(Container par1Container, String ... guiTexture) {
        super(par1Container);
        for (String string : guiTexture) {
            this.guiTextures.add(GuiContainerBaseEIO.getGuiTexture(string));
        }
    }

    public void bindGuiTexture() {
        this.bindGuiTexture(0);
    }

    public void bindGuiTexture(int id) {
        RenderUtil.bindTexture((ResourceLocation)this.getGuiTexture(id));
    }

    protected ResourceLocation getGuiTexture(int id) {
        return this.guiTextures.size() > id ? this.guiTextures.get(id) : null;
    }

    public List<Rectangle> getBlockingAreas() {
        return Collections.emptyList();
    }

    @Nonnull
    public static ResourceLocation getGuiTexture(String name) {
        return new ResourceLocation(EnderIO.DOMAIN + TEXTURE_PATH + name + TEXTURE_EXT);
    }
}

