/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.fluid;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BucketHandler {
    public static BucketHandler instance = new BucketHandler();
    private Map<BlockFluidClassic, Item> buckets = new HashMap<BlockFluidClassic, Item>();

    private BucketHandler() {
    }

    public void registerFluid(BlockFluidClassic fluidBlock, Item fullBucket) {
        this.buckets.put(fluidBlock, fullBucket);
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        ItemStack res;
        if (event.current != null && event.current.func_77973_b() == Items.field_151133_ar && event.current.field_77994_a > 0 && (res = this.getFilledBucket(event.world, event.target)) != null) {
            event.result = res;
            event.setResult(Event.Result.ALLOW);
        }
    }

    private ItemStack getFilledBucket(World world, MovingObjectPosition pos) {
        Item bucket;
        BlockPos blockPos = pos.func_178782_a();
        Block block = world.func_180495_p(blockPos).func_177230_c();
        if (block instanceof BlockFluidClassic && this.buckets.containsKey(block) && ((BlockFluidClassic)block).isSourceBlock((IBlockAccess)world, blockPos) && (bucket = this.buckets.get(block)) != null) {
            world.func_175698_g(blockPos);
            return new ItemStack(bucket);
        }
        return null;
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }
}

