/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.fluid;

import crazypants.enderio.config.Config;
import crazypants.enderio.fluid.Fluids;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class BlockFluidEio
extends BlockFluidClassic {
    protected Fluid fluid;

    public static BlockFluidEio create(Fluid fluid, Material material) {
        BlockFluidEio res = new BlockFluidEio(fluid, material);
        res.init();
        fluid.setBlock((Block)res);
        return res;
    }

    protected BlockFluidEio(Fluid fluid, Material material) {
        super(fluid, material);
        this.fluid = fluid;
        this.func_149663_c(fluid.getUnlocalizedName());
    }

    protected void init() {
        GameRegistry.registerBlock((Block)this, (String)("block" + StringUtils.capitalize((String)this.fluidName)));
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c().func_149688_o().func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c().func_149688_o().func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, pos);
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (entity.field_70170_p.field_72995_K) {
            super.func_176199_a(world, pos, entity);
            return;
        }
        if (this == Fluids.blockFireWater) {
            entity.func_70015_d(50);
        } else if (this == Fluids.blockRocketFuel && entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 150, 3, true, true));
        } else if (this == Fluids.blockNutrientDistillation && entity instanceof EntityPlayerMP) {
            long time = entity.field_70170_p.func_82737_E();
            EntityPlayerMP player = (EntityPlayerMP)entity;
            if (time % Config.nutrientFoodBoostDelay == 0L && player.getEntityData().func_74763_f("eioLastFoodBoost") != time) {
                player.func_71024_bL().func_75122_a(1, 0.1f);
                player.getEntityData().func_74772_a("eioLastFoodBoost", time);
            }
        } else if (this == Fluids.blockHootch && entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 150, 0, true, true));
        }
        super.func_176199_a(world, pos, entity);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        if (tab != null) {
            super.func_149666_a(itemIn, tab, list);
        }
    }
}

