/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.enchantment;

import com.enderio.core.api.common.enchant.IAdvancedEnchant;
import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.config.Config;
import crazypants.util.BaublesUtil;
import crazypants.util.GalacticraftUtil;
import java.util.ListIterator;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentSoulBound
extends Enchantment
implements IAdvancedEnchant {
    private final int id;

    public static EnchantmentSoulBound create(int id) {
        EnchantmentSoulBound res = new EnchantmentSoulBound(id);
        Enchantment.addToBookList((Enchantment)res);
        MinecraftForge.EVENT_BUS.register((Object)res);
        return res;
    }

    private EnchantmentSoulBound(int id) {
        super(id, new ResourceLocation(EnderIO.DOMAIN, "soulBound"), Config.enchantmentSoulBoundWeight, EnumEnchantmentType.ALL);
        this.id = id;
        this.func_77322_b("soulBound");
    }

    public int func_77317_b(int level) {
        return super.func_77317_b(level) + 30;
    }

    public int func_77321_a(int level) {
        return super.func_77321_a(level);
    }

    public int func_77325_b() {
        return 1;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(PlayerDropsEvent evt) {
        IInventory galacticraft;
        if (evt.entityPlayer == null || evt.entityPlayer instanceof FakePlayer || evt.isCanceled()) {
            return;
        }
        if (evt.entityPlayer.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        Log.debug("Running onPlayerDeathEarly logic for " + evt.entityPlayer.func_70005_c_());
        ListIterator iter = evt.drops.listIterator();
        while (iter.hasNext()) {
            EntityItem ei = (EntityItem)iter.next();
            ItemStack item = ei.func_92059_d();
            if (!this.isSoulBound(item) || !this.addToPlayerInventory(evt.entityPlayer, item)) continue;
            iter.remove();
        }
        IInventory baubles = BaublesUtil.instance().getBaubles(evt.entityPlayer);
        if (baubles != null) {
            for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                ItemStack item = baubles.func_70301_a(i);
                if (!this.isSoulBound(item) || !this.addToPlayerInventory(evt.entityPlayer, item)) continue;
                baubles.func_70299_a(i, null);
            }
        }
        if (evt.entityPlayer instanceof EntityPlayerMP && (galacticraft = GalacticraftUtil.getGCInventoryForPlayer((EntityPlayerMP)evt.entityPlayer)) != null) {
            for (int i = 0; i < galacticraft.func_70302_i_(); ++i) {
                ItemStack item = galacticraft.func_70301_a(i);
                if (!this.isSoulBound(item) || !this.addToPlayerInventory(evt.entityPlayer, item)) continue;
                galacticraft.func_70299_a(i, null);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerDeathLate(PlayerDropsEvent evt) {
        if (evt.entityPlayer == null || evt.entityPlayer instanceof FakePlayer || evt.isCanceled()) {
            return;
        }
        if (evt.entityPlayer.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        Log.debug("Running onPlayerDeathLate logic for " + evt.entityPlayer.func_70005_c_());
        ListIterator iter = evt.drops.listIterator();
        while (iter.hasNext()) {
            EntityItem ei = (EntityItem)iter.next();
            ItemStack item = ei.func_92059_d();
            if (!this.isSoulBound(item) || !this.addToPlayerInventory(evt.entityPlayer, item)) continue;
            iter.remove();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerClone(PlayerEvent.Clone evt) {
        ItemStack item;
        int i;
        if (!evt.wasDeath || evt.isCanceled()) {
            return;
        }
        if (evt.original == null || evt.entityPlayer == null || evt.entityPlayer instanceof FakePlayer) {
            return;
        }
        if (evt.entityPlayer.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        if (evt.original == evt.entityPlayer || evt.original.field_71071_by == evt.entityPlayer.field_71071_by || evt.original.field_71071_by.field_70460_b == evt.entityPlayer.field_71071_by.field_70460_b && evt.original.field_71071_by.field_70462_a == evt.entityPlayer.field_71071_by.field_70462_a) {
            Log.warn("Player " + evt.entityPlayer.func_70005_c_() + " just died and respawned in their old body. Did someone fire a PlayerEvent.Clone(death=true) " + "for a teleportation? Supressing Soulbound enchantment for zombie player.");
            return;
        }
        Log.debug("Running onPlayerCloneEarly logic for " + evt.entityPlayer.func_70005_c_());
        for (i = 0; i < evt.original.field_71071_by.field_70460_b.length; ++i) {
            item = evt.original.field_71071_by.field_70460_b[i];
            if (!this.isSoulBound(item) || !this.addToPlayerInventory(evt.entityPlayer, item)) continue;
            evt.original.field_71071_by.field_70460_b[i] = null;
        }
        for (i = 0; i < evt.original.field_71071_by.field_70462_a.length; ++i) {
            item = evt.original.field_71071_by.field_70462_a[i];
            if (!this.isSoulBound(item) || !this.addToPlayerInventory(evt.entityPlayer, item)) continue;
            evt.original.field_71071_by.field_70462_a[i] = null;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerCloneLast(PlayerEvent.Clone evt) {
        ItemStack item;
        int i;
        if (!evt.wasDeath || evt.isCanceled()) {
            return;
        }
        if (evt.original == null || evt.entityPlayer == null || evt.entityPlayer instanceof FakePlayer) {
            return;
        }
        if (evt.entityPlayer.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        if (evt.original == evt.entityPlayer || evt.original.field_71071_by == evt.entityPlayer.field_71071_by || evt.original.field_71071_by.field_70460_b == evt.entityPlayer.field_71071_by.field_70460_b && evt.original.field_71071_by.field_70462_a == evt.entityPlayer.field_71071_by.field_70462_a) {
            return;
        }
        Log.debug("Running onPlayerCloneLate logic for " + evt.entityPlayer.func_70005_c_());
        for (i = 0; i < evt.original.field_71071_by.field_70460_b.length; ++i) {
            item = evt.original.field_71071_by.field_70460_b[i];
            if (!this.isSoulBound(item) || !this.addToPlayerInventory(evt.entityPlayer, item) && !this.tryToSpawnItemInWorld(evt.original, item)) continue;
            evt.original.field_71071_by.field_70460_b[i] = null;
        }
        for (i = 0; i < evt.original.field_71071_by.field_70462_a.length; ++i) {
            item = evt.original.field_71071_by.field_70462_a[i];
            if (!this.isSoulBound(item) || !this.addToPlayerInventory(evt.entityPlayer, item) && !this.tryToSpawnItemInWorld(evt.original, item)) continue;
            evt.original.field_71071_by.field_70462_a[i] = null;
        }
    }

    private boolean tryToSpawnItemInWorld(EntityPlayer entityPlayer, ItemStack item) {
        if (entityPlayer != null && entityPlayer.field_70170_p != null) {
            EntityItem entityitem = new EntityItem(entityPlayer.field_70170_p, entityPlayer.field_70165_t, entityPlayer.field_70163_u + 0.5, entityPlayer.field_70161_v, item);
            entityitem.func_174867_a(40);
            entityitem.lifespan *= 2;
            entityitem.field_70159_w = 0.0;
            entityitem.field_70179_y = 0.0;
            entityPlayer.field_70170_p.func_72838_d((Entity)entityitem);
            Log.debug("Running tryToSpawnItemInWorld logic for " + entityPlayer.func_70005_c_() + ": " + item);
            return true;
        }
        return false;
    }

    private boolean isSoulBound(ItemStack item) {
        return EnchantmentHelper.func_77506_a((int)this.id, (ItemStack)item) > 0;
    }

    private boolean addToPlayerInventory(EntityPlayer entityPlayer, ItemStack item) {
        if (item == null || entityPlayer == null) {
            return false;
        }
        if (item.func_77973_b() instanceof ItemArmor) {
            ItemArmor arm = (ItemArmor)item.func_77973_b();
            int index = 3 - arm.field_77881_a;
            if (entityPlayer.field_71071_by.func_70440_f(index) == null) {
                entityPlayer.field_71071_by.field_70460_b[index] = item;
                Log.debug("Running addToPlayerInventory/armor logic for " + entityPlayer.func_70005_c_() + ": " + item);
                return true;
            }
        }
        InventoryPlayer inv = entityPlayer.field_71071_by;
        for (int i = 0; i < inv.field_70462_a.length; ++i) {
            if (inv.field_70462_a[i] != null) continue;
            inv.field_70462_a[i] = item.func_77946_l();
            Log.debug("Running addToPlayerInventory/main logic for " + entityPlayer.func_70005_c_() + ": " + item);
            return true;
        }
        Log.debug("Running addToPlayerInventory/fail logic for " + entityPlayer.func_70005_c_() + ": " + item);
        return false;
    }

    public String[] getTooltipDetails(ItemStack stack) {
        return new String[]{EnderIO.lang.localizeExact("description.enchantment.enderio.soulBound")};
    }
}

