/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.render;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.render.BakedQuadBuilder;
import crazypants.enderio.conduit.render.ConduitBundleRenderManager;
import crazypants.enderio.conduit.render.ConduitBundleRenderer;
import crazypants.enderio.conduit.render.ConduitRenderer;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;

public class DefaultConduitRenderer
implements ConduitRenderer {
    static final Vector3d[] verts = new Vector3d[8];
    protected float transmissionScaleFactor;

    @Override
    public boolean isRendererForConduit(IConduit conduit) {
        return true;
    }

    protected boolean renderComponent(CollidableComponent component) {
        return true;
    }

    @Override
    public void addBakedQuads(ConduitBundleRenderer conduitBundleRenderer, IConduitBundle bundle, IConduit conduit, float brightness, List<BakedQuad> quads) {
        Collection<CollidableComponent> components = conduit.getCollidableComponents();
        this.transmissionScaleFactor = conduit.getTransmitionGeometryScale();
        for (CollidableComponent component : components) {
            TextureAtlasSprite tex;
            if (!this.renderComponent(component)) continue;
            float selfIllum = Math.max(brightness, conduit.getSelfIlluminationForState(component));
            if (this.isNSEWUD(component.dir) && conduit.getTransmitionTextureForState(component) != null) {
                tex = conduit.getTransmitionTextureForState(component);
                if (tex == null) {
                    tex = IconUtil.instance.errorTexture;
                }
                this.addTransmissionQuads(tex, conduit, component, selfIllum, quads);
            }
            tex = conduit.getTextureForState(component);
            this.addConduitQuads(bundle, conduit, tex, component, selfIllum, quads);
        }
    }

    protected void addConduitQuads(IConduitBundle bundle, IConduit conduit, TextureAtlasSprite tex, CollidableComponent component, float selfIllum, List<BakedQuad> quads) {
        if (this.isNSEWUD(component.dir)) {
            float scaleFactor = 0.75f;
            float xLen = Math.abs(component.dir.func_82601_c()) == 1 ? 1.0f : scaleFactor;
            float yLen = Math.abs(component.dir.func_96559_d()) == 1 ? 1.0f : scaleFactor;
            float zLen = Math.abs(component.dir.func_82599_e()) == 1 ? 1.0f : scaleFactor;
            BoundingBox cube = component.bound;
            BoundingBox bb = cube.scale(xLen, yLen, zLen);
            this.addQuadsForSection(bb, tex, component.dir, quads);
            if (conduit.getConnectionMode(component.dir) == ConnectionMode.DISABLED) {
                tex = ConduitBundleRenderManager.instance.getConnectorIcon(component.data);
                BakedQuadBuilder.addBakedQuadForFace(quads, bb, tex, component.dir);
            }
        } else {
            BakedQuadBuilder.addBakedQuads(quads, component.bound, tex);
        }
    }

    protected void addQuadsForSection(BoundingBox bb, TextureAtlasSprite tex, EnumFacing dir, List<BakedQuad> quads) {
        this.addQuadsForSection(bb, tex, dir, quads, null);
    }

    protected void addQuadsForSection(BoundingBox bb, TextureAtlasSprite tex, EnumFacing dir, List<BakedQuad> quads, Vector4f color) {
        boolean rotateSides = dir == EnumFacing.UP || dir == EnumFacing.DOWN;
        boolean rotateTopBottom = dir == EnumFacing.DOWN || dir == EnumFacing.EAST || dir == EnumFacing.SOUTH;
        boolean doRotSides = rotateSides;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (face == dir || face.func_176734_d() == dir) continue;
            doRotSides = face == EnumFacing.UP || face == EnumFacing.DOWN ? dir == EnumFacing.SOUTH || dir == EnumFacing.NORTH : rotateSides;
            BakedQuadBuilder.addBakedQuadForFace(quads, bb, tex, face, doRotSides, rotateTopBottom, color);
        }
    }

    protected void addTransmissionQuads(TextureAtlasSprite tex, IConduit conduit, CollidableComponent component, float selfIllum, List<BakedQuad> quads) {
        float scaleFactor = 0.6f;
        float xLen = Math.abs(component.dir.func_82601_c()) == 1 ? 1.0f : scaleFactor;
        float yLen = Math.abs(component.dir.func_96559_d()) == 1 ? 1.0f : scaleFactor;
        float zLen = Math.abs(component.dir.func_82599_e()) == 1 ? 1.0f : scaleFactor;
        BoundingBox cube = component.bound;
        BoundingBox bb = cube.scale(xLen, yLen, zLen);
        this.addQuadsForSection(bb, tex, component.dir, quads);
    }

    @Override
    public void renderDynamicEntity(ConduitBundleRenderer conduitBundleRenderer, IConduitBundle te, IConduit conduit, double x, double y, double z, float partialTick, float worldLight) {
        Collection<CollidableComponent> components = conduit.getCollidableComponents();
        this.transmissionScaleFactor = conduit.getTransmitionGeometryScale();
        for (CollidableComponent component : components) {
            TextureAtlasSprite tex;
            if (!this.renderComponent(component)) continue;
            float selfIllum = Math.max(worldLight, conduit.getSelfIlluminationForState(component));
            if (this.isNSEWUD(component.dir) && conduit.getTransmitionTextureForState(component) != null) {
                tex = conduit.getTransmitionTextureForState(component);
                if (tex == null) {
                    tex = IconUtil.instance.errorTexture;
                }
                this.renderTransmissionDynamic(conduit, tex, component, selfIllum);
            }
            tex = conduit.getTextureForState(component);
            this.renderConduitDynamic(tex, conduit, component, selfIllum);
        }
    }

    protected void renderConduitDynamic(TextureAtlasSprite tex, IConduit conduit, CollidableComponent component, float brightness) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isNSEWUD(component.dir)) {
            float scaleFactor = 0.75f;
            float xLen = Math.abs(component.dir.func_82601_c()) == 1 ? 1.0f : scaleFactor;
            float yLen = Math.abs(component.dir.func_96559_d()) == 1 ? 1.0f : scaleFactor;
            float zLen = Math.abs(component.dir.func_82599_e()) == 1 ? 1.0f : scaleFactor;
            BoundingBox cube = component.bound;
            BoundingBox bb = cube.scale(xLen, yLen, zLen);
            this.drawDynamicSection(bb, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h(), component.dir, false, conduit.shouldMirrorTexture());
            if (conduit.getConnectionMode(component.dir) == ConnectionMode.DISABLED) {
                tex = ConduitBundleRenderManager.instance.getConnectorIcon(component.data);
                List corners = component.bound.getCornersWithUvForFace(component.dir, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h());
                RenderUtil.addVerticesToTessellator((List)corners, (VertexFormat)DefaultVertexFormats.field_181707_g, (boolean)false);
            }
        } else {
            this.drawDynamicSection(component.bound, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h(), component.dir, true);
        }
    }

    protected void renderTransmissionDynamic(IConduit conduit, TextureAtlasSprite tex, CollidableComponent component, float selfIllum) {
        float scaleFactor = 0.6f;
        float xLen = Math.abs(component.dir.func_82601_c()) == 1 ? 1.0f : scaleFactor;
        float yLen = Math.abs(component.dir.func_96559_d()) == 1 ? 1.0f : scaleFactor;
        float zLen = Math.abs(component.dir.func_82599_e()) == 1 ? 1.0f : scaleFactor;
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        BoundingBox cube = component.bound;
        BoundingBox bb = cube.scale(xLen, yLen, zLen);
        this.drawDynamicSection(bb, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h(), component.dir, false);
    }

    protected boolean isNSEWUD(EnumFacing dir) {
        return dir != null;
    }

    protected void drawDynamicSection(BoundingBox bound, float minU, float maxU, float minV, float maxV, EnumFacing dir, boolean isTransmission) {
        this.drawDynamicSection(bound, minU, maxU, minV, maxV, dir, isTransmission, true);
    }

    protected void drawDynamicSection(BoundingBox bound, float minU, float maxU, float minV, float maxV, EnumFacing dir, boolean isTransmission, boolean mirrorTexture) {
        boolean rotateTopBottom;
        if (isTransmission) {
            this.setVerticesForTransmission(bound, dir);
        } else {
            this.setupVertices(bound);
        }
        if (mirrorTexture && (dir == EnumFacing.NORTH || dir == EnumFacing.UP || dir == EnumFacing.EAST)) {
            float tmp = minU;
            minU = maxU;
            maxU = tmp;
        }
        boolean rotateSides = dir == EnumFacing.UP || dir == EnumFacing.DOWN;
        boolean bl = rotateTopBottom = dir == EnumFacing.NORTH || dir == EnumFacing.SOUTH;
        if (dir != EnumFacing.NORTH && dir != EnumFacing.SOUTH) {
            float tmp;
            if (!isTransmission) {
                // empty if block
            }
            if (rotateSides) {
                this.addVecWithUV(verts[1], maxU, maxV);
                this.addVecWithUV(verts[0], maxU, minV);
                this.addVecWithUV(verts[3], minU, minV);
                this.addVecWithUV(verts[2], minU, maxV);
            } else {
                this.addVecWithUV(verts[1], minU, minV);
                this.addVecWithUV(verts[0], maxU, minV);
                this.addVecWithUV(verts[3], maxU, maxV);
                this.addVecWithUV(verts[2], minU, maxV);
            }
            if (dir == EnumFacing.WEST || dir == EnumFacing.EAST) {
                tmp = minU;
                minU = maxU;
                maxU = tmp;
            }
            if (!isTransmission) {
                // empty if block
            }
            if (rotateSides) {
                this.addVecWithUV(verts[4], maxU, maxV);
                this.addVecWithUV(verts[5], maxU, minV);
                this.addVecWithUV(verts[6], minU, minV);
                this.addVecWithUV(verts[7], minU, maxV);
            } else {
                this.addVecWithUV(verts[4], minU, minV);
                this.addVecWithUV(verts[5], maxU, minV);
                this.addVecWithUV(verts[6], maxU, maxV);
                this.addVecWithUV(verts[7], minU, maxV);
            }
            if (dir == EnumFacing.WEST || dir == EnumFacing.EAST) {
                tmp = minU;
                minU = maxU;
                maxU = tmp;
            }
        }
        if (dir != EnumFacing.UP && dir != EnumFacing.DOWN) {
            if (!isTransmission) {
                // empty if block
            }
            if (rotateTopBottom) {
                this.addVecWithUV(verts[6], maxU, maxV);
                this.addVecWithUV(verts[2], minU, maxV);
                this.addVecWithUV(verts[3], minU, minV);
                this.addVecWithUV(verts[7], maxU, minV);
            } else {
                this.addVecWithUV(verts[6], minU, minV);
                this.addVecWithUV(verts[2], minU, maxV);
                this.addVecWithUV(verts[3], maxU, maxV);
                this.addVecWithUV(verts[7], maxU, minV);
            }
            if (!isTransmission) {
                // empty if block
            }
            if (rotateTopBottom) {
                this.addVecWithUV(verts[0], minU, minV);
                this.addVecWithUV(verts[1], minU, maxV);
                this.addVecWithUV(verts[5], maxU, maxV);
                this.addVecWithUV(verts[4], maxU, minV);
            } else {
                this.addVecWithUV(verts[0], maxU, maxV);
                this.addVecWithUV(verts[1], minU, maxV);
                this.addVecWithUV(verts[5], minU, minV);
                this.addVecWithUV(verts[4], maxU, minV);
            }
        }
        if (dir != EnumFacing.EAST && dir != EnumFacing.WEST) {
            if (!isTransmission) {
                // empty if block
            }
            if (rotateSides) {
                this.addVecWithUV(verts[2], minU, maxV);
                this.addVecWithUV(verts[6], minU, minV);
                this.addVecWithUV(verts[5], maxU, minV);
                this.addVecWithUV(verts[1], maxU, maxV);
            } else {
                this.addVecWithUV(verts[2], minU, maxV);
                this.addVecWithUV(verts[6], maxU, maxV);
                this.addVecWithUV(verts[5], maxU, minV);
                this.addVecWithUV(verts[1], minU, minV);
            }
            if (!isTransmission) {
                // empty if block
            }
            if (rotateSides) {
                this.addVecWithUV(verts[0], maxU, maxV);
                this.addVecWithUV(verts[4], maxU, minV);
                this.addVecWithUV(verts[7], minU, minV);
                this.addVecWithUV(verts[3], minU, maxV);
            } else {
                this.addVecWithUV(verts[0], minU, minV);
                this.addVecWithUV(verts[4], maxU, minV);
                this.addVecWithUV(verts[7], maxU, maxV);
                this.addVecWithUV(verts[3], minU, maxV);
            }
        }
    }

    public BoundingBox[] toCubes(BoundingBox bb) {
        float width = bb.maxX - bb.minX;
        float height = bb.maxY - bb.minY;
        float depth = bb.maxZ - bb.minZ;
        if (width > 0.0f && height > 0.0f && depth > 0.0f) {
            if (width / depth > 1.5f || depth / width > 1.5f) {
                if (width > depth) {
                    int numSplits = Math.round(width / depth);
                    float newWidth = width / (float)numSplits;
                    BoundingBox[] result = new BoundingBox[numSplits];
                    float lastMax = bb.minX;
                    for (int i = 0; i < numSplits; ++i) {
                        float max = lastMax + newWidth;
                        result[i] = new BoundingBox(lastMax, bb.minY, bb.minZ, max, bb.maxY, bb.maxZ);
                        lastMax = max;
                    }
                    return result;
                }
                int numSplits = Math.round(depth / width);
                float newWidth = depth / (float)numSplits;
                BoundingBox[] result = new BoundingBox[numSplits];
                float lastMax = bb.minZ;
                for (int i = 0; i < numSplits; ++i) {
                    float max = lastMax + newWidth;
                    result[i] = new BoundingBox(bb.minX, bb.minY, lastMax, bb.maxX, bb.maxY, max);
                    lastMax = max;
                }
                return result;
            }
            if ((double)(height / width) > 1.5) {
                int numSplits = Math.round(height / width);
                float newWidth = height / (float)numSplits;
                BoundingBox[] result = new BoundingBox[numSplits];
                float lastMax = bb.minY;
                for (int i = 0; i < numSplits; ++i) {
                    float max = lastMax + newWidth;
                    result[i] = new BoundingBox(bb.minX, lastMax, bb.minZ, bb.maxX, max, bb.maxZ);
                    lastMax = max;
                }
                return result;
            }
        }
        return new BoundingBox[]{bb};
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    protected void setVerticesForTransmission(BoundingBox bound, EnumFacing dir) {
        float xs = dir.func_82601_c() == 0 ? this.transmissionScaleFactor : 1.0f;
        float ys = dir.func_96559_d() == 0 ? this.transmissionScaleFactor : 1.0f;
        float zs = dir.func_82599_e() == 0 ? this.transmissionScaleFactor : 1.0f;
        this.setupVertices(bound.scale(xs, ys, zs));
    }

    protected void addVecWithUV(Vector3d vec, double u, double v) {
        WorldRenderer tes = Tessellator.func_178181_a().func_178180_c();
        tes.func_181662_b(vec.x, vec.y, vec.z).func_181673_a(u, v).func_181675_d();
    }

    protected void setupVertices(BoundingBox bound) {
        this.setupVertices(bound, null);
    }

    protected void setupVertices(BoundingBox bound, VertexTransform xForm) {
        verts[0].set((double)bound.minX, (double)bound.minY, (double)bound.minZ);
        verts[1].set((double)bound.maxX, (double)bound.minY, (double)bound.minZ);
        verts[2].set((double)bound.maxX, (double)bound.maxY, (double)bound.minZ);
        verts[3].set((double)bound.minX, (double)bound.maxY, (double)bound.minZ);
        verts[4].set((double)bound.minX, (double)bound.minY, (double)bound.maxZ);
        verts[5].set((double)bound.maxX, (double)bound.minY, (double)bound.maxZ);
        verts[6].set((double)bound.maxX, (double)bound.maxY, (double)bound.maxZ);
        verts[7].set((double)bound.minX, (double)bound.maxY, (double)bound.maxZ);
        if (xForm != null) {
            for (Vector3d vec : verts) {
                xForm.apply(vec);
            }
        }
    }

    static {
        for (int i = 0; i < verts.length; ++i) {
            DefaultConduitRenderer.verts[i] = new Vector3d();
        }
    }
}

