/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.packet;

import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.packet.AbstractConduitBundlePacket;
import crazypants.enderio.conduit.packet.ConTypeEnum;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class AbstractConduitPacket<T extends IConduit>
extends AbstractConduitBundlePacket {
    protected ConTypeEnum conType;

    public AbstractConduitPacket() {
    }

    public AbstractConduitPacket(TileEntity tile, ConTypeEnum conType) {
        super(tile);
        this.conType = conType;
    }

    protected Class<? extends IConduit> getConType() {
        return this.conType.getBaseType();
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeShort(this.conType.ordinal());
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        short ordinal = buf.readShort();
        this.conType = ConTypeEnum.values()[ordinal];
    }

    protected T getTileCasted(MessageContext ctx) {
        World world = this.getWorld(ctx);
        if (world == null) {
            return null;
        }
        TileEntity te = world.func_175625_s(new BlockPos(this.x, this.y, this.z));
        if (!(te instanceof IConduitBundle)) {
            return null;
        }
        IConduitBundle bundle = (IConduitBundle)te;
        return (T)bundle.getConduit(this.getConType());
    }
}

